/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.tools;

import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ClassHelper {
    private static final Logger log = Logger.getLogger(ClassHelper.class.getName());

    private ClassHelper() {
    }

    @Nullable
    public static Class<?> loadClass(@Nonnull String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Exception e) {
            log.warning("class [" + className + "] could not be found (" + e.getMessage() + ")");
            return null;
        }
    }

    @Nullable
    public static <T> T getInstance(@Nonnull String className, @Nonnull Class<T> type) {
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(className);
            if (type.isAssignableFrom(cls)) {
                return type.cast(cls.newInstance());
            }
            log.warning("given class [" + className + "] does not implement [" + type.getName() + "]");
        }
        catch (Exception e) {
            log.warning("class [" + className + "] could not be instantiated (" + e.toString() + ")");
        }
        return null;
    }

    @Nullable
    public static <T> T getInstance(@Nonnull Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            log.warning("class [" + clazz.getName() + "] could not be instantiated");
            return null;
        }
    }
}

