/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.lwxs.processor;

import de.lessvoid.xml.lwxs.Schema;
import de.lessvoid.xml.lwxs.elements.Type;
import de.lessvoid.xml.lwxs.processor.TypeProcessorElement;
import de.lessvoid.xml.lwxs.processor.TypeProcessorSubstitutionGroup;
import de.lessvoid.xml.xpp3.Attributes;
import de.lessvoid.xml.xpp3.SubstitutionGroup;
import de.lessvoid.xml.xpp3.XmlParser;
import de.lessvoid.xml.xpp3.XmlProcessor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TypeProcessor
implements XmlProcessor {
    @Nonnull
    private final Schema niftyXmlSchema;

    public TypeProcessor(@Nonnull Schema niftyXmlSchemaParam) {
        this.niftyXmlSchema = niftyXmlSchemaParam;
    }

    @Override
    public void process(@Nonnull XmlParser xmlParser, @Nonnull Attributes attributes) throws Exception {
        String name = this.getNameAttribute(attributes);
        Type type = new Type(name, this.getExtendsAttribute(attributes));
        this.niftyXmlSchema.addType(name, type);
        SubstitutionGroup substGroup = new SubstitutionGroup();
        substGroup.add("element", new TypeProcessorElement(type));
        substGroup.add("group", new TypeProcessorSubstitutionGroup(type));
        xmlParser.nextTag();
        xmlParser.zeroOrMore(substGroup);
    }

    @Nonnull
    private String getNameAttribute(@Nonnull Attributes attributes) throws Exception {
        String name = attributes.get("name");
        if (name == null) {
            throw new Exception("[name] attribute is a required attribute");
        }
        return name;
    }

    @Nullable
    private String getExtendsAttribute(@Nonnull Attributes attributes) {
        return attributes.get("extends");
    }
}

