/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.lwxs.processor;

import de.lessvoid.nifty.tools.resourceloader.NiftyResourceLoader;
import de.lessvoid.xml.lwxs.Schema;
import de.lessvoid.xml.lwxs.elements.Type;
import de.lessvoid.xml.xpp3.Attributes;
import de.lessvoid.xml.xpp3.XmlParser;
import de.lessvoid.xml.xpp3.XmlProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nonnull;
import org.xmlpull.v1.XmlPullParserFactory;

public class IncludeProcessor
implements XmlProcessor {
    @Nonnull
    private final Map<String, Type> types;
    @Nonnull
    private final XmlPullParserFactory parserFactory;
    @Nonnull
    private final NiftyResourceLoader resourceLoader;

    public IncludeProcessor(@Nonnull XmlPullParserFactory parserFactory, @Nonnull NiftyResourceLoader resourceLoader, @Nonnull Map<String, Type> typesParam) {
        this.resourceLoader = resourceLoader;
        this.types = typesParam;
        this.parserFactory = parserFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(@Nonnull XmlParser xmlParser, @Nonnull Attributes attributes) throws Exception {
        String filename = attributes.get("filename");
        if (filename == null) {
            return;
        }
        Schema niftyXmlSchema = new Schema(this.parserFactory, this.resourceLoader);
        XmlParser parser = new XmlParser(this.parserFactory.newPullParser());
        InputStream stream = this.resourceLoader.getResourceAsStream(filename);
        if (stream != null) {
            try {
                parser.read(stream);
                parser.nextTag();
                parser.required("nxs", niftyXmlSchema);
                this.types.putAll(niftyXmlSchema.getTypes());
                xmlParser.nextTag();
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

