/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools.time;

import de.lessvoid.nifty.spi.time.TimeProvider;
import de.lessvoid.nifty.tools.time.interpolator.ExpTime;
import de.lessvoid.nifty.tools.time.interpolator.Interpolator;
import de.lessvoid.nifty.tools.time.interpolator.LinearTime;
import de.lessvoid.nifty.tools.time.interpolator.NullTime;
import de.lessvoid.nifty.tools.time.interpolator.OneTime;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class TimeInterpolator {
    @Nonnull
    private static final Logger log = Logger.getLogger(TimeInterpolator.class.getName());
    @Nonnull
    private final TimeProvider timeProvider;
    @Nonnull
    private Interpolator interpolatorProvider;
    private float value = 0.0f;
    private long startTime;
    private long lengthParam;
    private long startDelayParam = 0L;

    public TimeInterpolator(@Nonnull Properties parameter, @Nonnull TimeProvider newTimeProvider, boolean infinite) {
        this.timeProvider = newTimeProvider;
        this.initialize(parameter, infinite);
    }

    public void initialize(@Nonnull Properties parameter, boolean infinite) {
        this.startDelayParam = TimeInterpolator.parseLongParameter(parameter, "startDelay", 0L);
        String lengthDefault = infinite ? "infinite" : null;
        Interpolator interpolatorProvider = null;
        if ("infinite".equals(parameter.getProperty("length", lengthDefault))) {
            interpolatorProvider = new NullTime();
        } else {
            this.lengthParam = TimeInterpolator.parseLongParameter(parameter, "length", 1000L);
            if (Boolean.parseBoolean(parameter.getProperty("oneShot"))) {
                interpolatorProvider = new OneTime();
            }
        }
        if (interpolatorProvider == null) {
            String timeType = parameter.getProperty("timeType", "linear");
            if ("infinite".equals(timeType)) {
                interpolatorProvider = new NullTime();
            } else if ("linear".equals(timeType)) {
                interpolatorProvider = new LinearTime();
            } else if ("exp".equals(timeType)) {
                interpolatorProvider = new ExpTime();
            } else {
                log.warning(timeType + " is not supported, using NullTime for fallback. probably not what you want...");
                interpolatorProvider = new NullTime();
            }
        }
        interpolatorProvider.initialize(parameter);
        this.interpolatorProvider = interpolatorProvider;
    }

    public void start() {
        this.interpolatorProvider.start();
        this.value = 0.0f;
        this.startTime = this.timeProvider.getMsTime() + this.startDelayParam;
    }

    public final boolean update() {
        long now = this.timeProvider.getMsTime();
        long timePassed = now - this.startTime;
        if (timePassed < 0L) {
            return true;
        }
        this.value = this.interpolatorProvider.getValue(this.lengthParam, timePassed);
        if (this.value > 1.0f) {
            this.value = 1.0f;
            return false;
        }
        return true;
    }

    public final float getValue() {
        return this.value;
    }

    private static long parseLongParameter(@Nonnull Properties parameter, @Nonnull String key, long defaultValue) {
        String property = parameter.getProperty(key);
        if (property == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(property);
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, "Error parsing the \"" + key + "\" properly.", e);
            return defaultValue;
        }
    }
}

