/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools;

import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.screen.Screen;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TargetElementResolver {
    @Nonnull
    private static final String PARENT = "#parent";
    @Nonnull
    private final Screen screen;
    @Nonnull
    private final Element base;

    public TargetElementResolver(@Nonnull Screen screen, @Nonnull Element baseElement) {
        this.screen = screen;
        this.base = baseElement;
    }

    @Nullable
    public Element resolve(@Nullable String id) {
        if (id == null) {
            return null;
        }
        if (id.startsWith(PARENT)) {
            return this.resolveParents(id, this.base.getParent());
        }
        if (id.startsWith("#")) {
            return this.base.findElementById(id);
        }
        return this.screen.findElementById(id);
    }

    @Nullable
    private Element resolveParents(@Nonnull String id, @Nonnull Element parent) {
        String subParentId = id.replaceFirst(PARENT, "");
        if (!subParentId.startsWith(PARENT)) {
            if (subParentId.startsWith("#")) {
                return parent.findElementById(subParentId.replaceFirst("#", ""));
            }
            return parent;
        }
        return this.resolveParents(subParentId, parent.getParent());
    }
}

