/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools;

import de.lessvoid.nifty.tools.Factory;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Deque;
import java.util.LinkedList;
import javax.annotation.Nonnull;

public class ObjectPool<T> {
    @Nonnull
    private final Deque<Reference<T>> pool;
    @Nonnull
    private final Factory<T> factory;

    public ObjectPool(@Nonnull Factory<T> factory) {
        this.factory = factory;
        this.pool = new LinkedList<Reference<T>>();
    }

    @Nonnull
    public T allocate() {
        while (!this.pool.isEmpty()) {
            T obj = this.pool.removeLast().get();
            if (obj == null) continue;
            return obj;
        }
        return this.factory.createNew();
    }

    public void free(@Nonnull T item) {
        this.pool.addFirst(new SoftReference<T>(item));
    }
}

