/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.image;

import de.lessvoid.nifty.ParameterizedObjectFactory;
import de.lessvoid.nifty.render.image.CompoundImageMode;
import de.lessvoid.nifty.render.image.ImageMode;
import de.lessvoid.nifty.render.image.areaprovider.AreaProvider;
import de.lessvoid.nifty.render.image.areaprovider.CachedAreaProvider;
import de.lessvoid.nifty.render.image.areaprovider.FullImageAreaProvider;
import de.lessvoid.nifty.render.image.areaprovider.SpriteAreaProvider;
import de.lessvoid.nifty.render.image.areaprovider.SubImageAreaProvider;
import de.lessvoid.nifty.render.image.renderstrategy.ClampStrategy;
import de.lessvoid.nifty.render.image.renderstrategy.NinePartResizeStrategy;
import de.lessvoid.nifty.render.image.renderstrategy.RenderDirectlyStrategy;
import de.lessvoid.nifty.render.image.renderstrategy.RenderStrategy;
import de.lessvoid.nifty.render.image.renderstrategy.RepeatStrategy;
import de.lessvoid.nifty.render.image.renderstrategy.ResizeStrategy;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImageModeFactory {
    @Nullable
    private static ImageModeFactory s_sharedInstance = null;
    @Nonnull
    private final ParameterizedObjectFactory<AreaProvider> m_areaProviderFactory;
    @Nonnull
    private final ParameterizedObjectFactory<RenderStrategy> m_renderStrategyFactory;

    public ImageModeFactory(@Nonnull Map<String, Class<? extends AreaProvider>> areaProviderMapping, @Nonnull String fallbackAreaProvider, @Nonnull Map<String, Class<? extends RenderStrategy>> renderStrategyMapping, @Nonnull String fallbackRenderStrategyName) {
        this.m_areaProviderFactory = new ParameterizedObjectFactory<AreaProvider>(areaProviderMapping, fallbackAreaProvider);
        this.m_renderStrategyFactory = new ParameterizedObjectFactory<RenderStrategy>(renderStrategyMapping, fallbackRenderStrategyName);
    }

    @Nonnull
    public ImageMode createImageMode(@Nullable String areaProviderDescription, @Nullable String renderStrategyDescription) {
        return new CompoundImageMode(new CachedAreaProvider(this.getAreaProvider(areaProviderDescription)), this.getRenderStrategy(renderStrategyDescription));
    }

    @Nonnull
    AreaProvider getAreaProvider(@Nullable String areaProviderDescription) {
        return this.m_areaProviderFactory.create(areaProviderDescription);
    }

    @Nonnull
    RenderStrategy getRenderStrategy(@Nullable String renderStrategyDescription) {
        return this.m_renderStrategyFactory.create(renderStrategyDescription);
    }

    @Nonnull
    public static synchronized ImageModeFactory getSharedInstance() {
        if (s_sharedInstance == null) {
            HashMap<String, Class<? extends AreaProvider>> areaProviderMapping = new HashMap<String, Class<? extends AreaProvider>>();
            areaProviderMapping.put("fullimage", FullImageAreaProvider.class);
            areaProviderMapping.put("sprite", SpriteAreaProvider.class);
            areaProviderMapping.put("subimage", SubImageAreaProvider.class);
            HashMap<String, Class<? extends RenderStrategy>> renderStrategyMapping = new HashMap<String, Class<? extends RenderStrategy>>();
            renderStrategyMapping.put("clamp", ClampStrategy.class);
            renderStrategyMapping.put("nine-part", NinePartResizeStrategy.class);
            renderStrategyMapping.put("repeat", RepeatStrategy.class);
            renderStrategyMapping.put("resize", ResizeStrategy.class);
            renderStrategyMapping.put("direct", RenderDirectlyStrategy.class);
            s_sharedInstance = new ImageModeFactory(areaProviderMapping, "fullimage", renderStrategyMapping, "resize");
        }
        return s_sharedInstance;
    }
}

