/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.batch.spi.core;

import java.nio.FloatBuffer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CoreVector4f {
    public float x;
    public float y;
    public float z;
    public float w;

    public CoreVector4f() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 1.0f;
    }

    public CoreVector4f(@Nonnull CoreVector4f src) {
        this.set(src);
    }

    public CoreVector4f(float x, float y, float z, float w) {
        this.set(x, y, z, w);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getW() {
        return this.w;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public void setW(float w) {
        this.w = w;
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    @Nonnull
    public CoreVector4f set(@Nonnull CoreVector4f src) {
        this.x = src.getX();
        this.y = src.getY();
        this.z = src.getZ();
        this.w = src.getW();
        return this;
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    @Nonnull
    public CoreVector4f translate(float x, float y, float z, float w) {
        this.x += x;
        this.y += y;
        this.z += z;
        this.w += w;
        return this;
    }

    @Nonnull
    public static CoreVector4f add(@Nonnull CoreVector4f left, @Nonnull CoreVector4f right, @Nullable CoreVector4f result) {
        if (result == null) {
            return new CoreVector4f(left.x + right.x, left.y + right.y, left.z + right.z, left.w + right.w);
        }
        result.set(left.x + right.x, left.y + right.y, left.z + right.z, left.w + right.w);
        return result;
    }

    @Nonnull
    public static CoreVector4f subtract(@Nonnull CoreVector4f left, @Nonnull CoreVector4f right, @Nullable CoreVector4f result) {
        if (result == null) {
            return new CoreVector4f(left.x - right.x, left.y - right.y, left.z - right.z, left.w - right.w);
        }
        result.set(left.x - right.x, left.y - right.y, left.z - right.z, left.w - right.w);
        return result;
    }

    @Nonnull
    public CoreVector4f negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    @Nonnull
    public CoreVector4f negate(@Nullable CoreVector4f result) {
        if (result == null) {
            result = new CoreVector4f();
        }
        result.x = -this.x;
        result.y = -this.y;
        result.z = -this.z;
        result.w = -this.w;
        return result;
    }

    @Nonnull
    public CoreVector4f normalize(@Nullable CoreVector4f result) {
        float l = this.length();
        if (result == null) {
            result = new CoreVector4f(this.x / l, this.y / l, this.z / l, this.w / l);
        } else {
            result.set(this.x / l, this.y / l, this.z / l, this.w / l);
        }
        return result;
    }

    public static float dot(@Nonnull CoreVector4f left, @Nonnull CoreVector4f right) {
        return left.x * right.x + left.y * right.y + left.z * right.z + left.w * right.w;
    }

    public static float angle(@Nonnull CoreVector4f a, @Nonnull CoreVector4f b) {
        float dls = CoreVector4f.dot(a, b) / (a.length() * b.length());
        if (dls < -1.0f) {
            dls = -1.0f;
        } else if (dls > 1.0f) {
            dls = 1.0f;
        }
        return (float)Math.acos(dls);
    }

    @Nonnull
    public CoreVector4f load(@Nonnull FloatBuffer buffer) {
        this.x = buffer.get();
        this.y = buffer.get();
        this.z = buffer.get();
        this.w = buffer.get();
        return this;
    }

    @Nonnull
    public CoreVector4f scale(float scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
        this.w *= scale;
        return this;
    }

    @Nonnull
    public CoreVector4f store(@Nonnull FloatBuffer buffer) {
        buffer.put(this.x);
        buffer.put(this.y);
        buffer.put(this.z);
        buffer.put(this.w);
        return this;
    }

    @Nonnull
    public String toString() {
        return "Vector4f: " + this.x + " " + this.y + " " + this.z + " " + this.w;
    }
}

