/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.batch.core;

import de.lessvoid.nifty.render.batch.CheckGL;
import de.lessvoid.nifty.render.batch.spi.BufferFactory;
import de.lessvoid.nifty.render.batch.spi.core.CoreGL;
import java.nio.IntBuffer;
import javax.annotation.Nonnull;

public class CoreElementVBO {
    @Nonnull
    private final CoreGL gl;
    @Nonnull
    private final IntBuffer indexBuffer;
    @Nonnull
    private final IntBuffer idBuffer;
    private final int id;
    private final int usage;

    @Nonnull
    public static CoreElementVBO createStaticVBO(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory, @Nonnull int[] data) {
        return new CoreElementVBO(gl, bufferFactory, gl.GL_STATIC_DRAW(), data);
    }

    @Nonnull
    public static CoreElementVBO createAndSendStaticVBO(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory, @Nonnull int[] data) {
        CoreElementVBO result = new CoreElementVBO(gl, bufferFactory, gl.GL_STATIC_DRAW(), data);
        result.send();
        return result;
    }

    @Nonnull
    public static CoreElementVBO createAndSendStaticVBO(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory, @Nonnull IntBuffer data) {
        CoreElementVBO result = new CoreElementVBO(gl, bufferFactory, gl.GL_STATIC_DRAW(), data.array());
        result.send();
        return result;
    }

    @Nonnull
    public static CoreElementVBO createDynamicVBO(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory, @Nonnull int[] data) {
        return new CoreElementVBO(gl, bufferFactory, gl.GL_DYNAMIC_DRAW(), data);
    }

    @Nonnull
    public static CoreElementVBO createStreamVBO(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory, @Nonnull int[] data) {
        return new CoreElementVBO(gl, bufferFactory, gl.GL_STREAM_DRAW(), data);
    }

    public IntBuffer getBuffer() {
        return this.indexBuffer;
    }

    public void bind() {
        this.gl.glBindBuffer(this.gl.GL_ELEMENT_ARRAY_BUFFER(), this.id);
        CheckGL.checkGLError(this.gl, "glBindBuffer(GL_ELEMENT_ARRAY_BUFFER)");
    }

    public void unbind() {
        this.gl.glBindBuffer(this.gl.GL_ELEMENT_ARRAY_BUFFER(), 0);
        CheckGL.checkGLError(this.gl, "glBindBuffer(GL_ELEMENT_ARRAY_BUFFER -> unbind)");
    }

    public void send() {
        this.gl.glBufferData(this.gl.GL_ELEMENT_ARRAY_BUFFER(), this.indexBuffer, this.usage);
        CheckGL.checkGLError(this.gl, "glBufferData(GL_ELEMENT_ARRAY_BUFFER)");
    }

    public void delete() {
        this.idBuffer.clear();
        this.idBuffer.put(this.id);
        this.gl.glDeleteBuffers(1, this.idBuffer);
    }

    public void enablePrimitiveRestart(int value) {
        this.gl.glPrimitiveRestartIndex(value);
        this.gl.glEnable(this.gl.GL_PRIMITIVE_RESTART());
    }

    public void disablePrimitiveRestart() {
        this.gl.glDisable(this.gl.GL_PRIMITIVE_RESTART());
    }

    private CoreElementVBO(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory, int usageType, @Nonnull int[] data) {
        this.gl = gl;
        this.usage = usageType;
        this.indexBuffer = bufferFactory.createNativeOrderedIntBuffer(data.length);
        this.indexBuffer.put(data);
        this.indexBuffer.rewind();
        this.idBuffer = bufferFactory.createNativeOrderedIntBuffer(data.length);
        gl.glGenBuffers(1, this.idBuffer);
        this.id = this.idBuffer.get(0);
        CheckGL.checkGLError(gl, "glGenBuffers");
        this.bind();
        this.send();
    }
}

