/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.loaderv2.types;

import de.lessvoid.nifty.loaderv2.types.AttributesType;
import de.lessvoid.nifty.loaderv2.types.EffectsType;
import de.lessvoid.nifty.loaderv2.types.ElementType;
import de.lessvoid.nifty.loaderv2.types.InteractType;
import de.lessvoid.nifty.loaderv2.types.XmlBaseType;
import de.lessvoid.nifty.loaderv2.types.resolver.style.StyleResolver;
import de.lessvoid.nifty.tools.StringHelper;
import de.lessvoid.xml.xpp3.Attributes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StyleType
extends XmlBaseType {
    @Nullable
    private AttributesType attributesType;
    @Nullable
    private EffectsType effectsType;
    @Nullable
    private InteractType interactType;

    public StyleType() {
    }

    public StyleType(@Nonnull Attributes attributes) {
        super(attributes);
    }

    public void setAttributes(@Nonnull AttributesType styleAttributesTypeParam) {
        this.attributesType = styleAttributesTypeParam;
    }

    public void setEffect(@Nonnull EffectsType effectTypeParam) {
        this.effectsType = effectTypeParam;
    }

    public void setInteract(@Nonnull InteractType interactTypeParam) {
        this.interactType = interactTypeParam;
    }

    @Override
    @Nonnull
    public String output(int offset) {
        String result = StringHelper.whitespace(offset) + "<style> (" + this.getAttributes().toString() + ")";
        if (this.attributesType != null) {
            result = result + "\n" + this.attributesType.output(offset + 1);
        }
        if (this.interactType != null) {
            result = result + "\n" + this.interactType.output(offset + 1);
        }
        if (this.effectsType != null) {
            result = result + "\n" + this.effectsType.output(offset + 1);
        }
        return result;
    }

    @Nullable
    public String getStyleId() {
        return this.getAttributes().get("id");
    }

    @Nullable
    public String getBaseStyleId() {
        return this.getAttributes().get("base");
    }

    public void applyTo(@Nonnull ElementType elementType, @Nonnull StyleResolver styleResolver) {
        this.applyToBaseStyleInternal(styleResolver, elementType);
        this.applyToInternal(elementType);
    }

    void applyToInternal(@Nonnull ElementType elementType) {
        String styleId = this.getStyleId();
        if (styleId == null) {
            return;
        }
        elementType.removeWithTag(styleId);
        if (this.attributesType != null) {
            this.attributesType.apply(elementType.getAttributes(), styleId);
        }
        if (this.effectsType != null) {
            this.effectsType.apply(elementType.getEffects(), styleId);
        }
        if (this.interactType != null) {
            this.interactType.apply(elementType.getInteract(), styleId);
        }
    }

    void applyToBaseStyleInternal(@Nonnull StyleResolver styleResolver, @Nonnull ElementType elementType) {
        StyleType baseStyle = styleResolver.resolve(this.getBaseStyleId());
        if (baseStyle != null) {
            baseStyle.applyTo(elementType, styleResolver);
        }
    }
}

