/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.loaderv2.types;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyIdCreator;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputMapping;
import de.lessvoid.nifty.layout.LayoutPart;
import de.lessvoid.nifty.loaderv2.NiftyLoader;
import de.lessvoid.nifty.loaderv2.types.LayerType;
import de.lessvoid.nifty.loaderv2.types.NiftyType;
import de.lessvoid.nifty.loaderv2.types.XmlBaseType;
import de.lessvoid.nifty.loaderv2.types.helper.CollectionLogger;
import de.lessvoid.nifty.screen.DefaultScreenController;
import de.lessvoid.nifty.screen.KeyInputHandler;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import de.lessvoid.nifty.spi.time.TimeProvider;
import de.lessvoid.nifty.tools.StopWatch;
import de.lessvoid.nifty.tools.StringHelper;
import de.lessvoid.xml.tools.ClassHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ScreenType
extends XmlBaseType {
    private static final Logger log = Logger.getLogger(ScreenType.class.getName());
    @Nonnull
    private final Collection<LayerType> layers = new ArrayList<LayerType>();

    public void addLayer(LayerType layer) {
        this.layers.add(layer);
    }

    @Override
    @Nonnull
    public String output(int offset) {
        return StringHelper.whitespace(offset) + "<screen> " + super.output(offset) + "\n" + CollectionLogger.out(offset + 1, this.layers, "layers");
    }

    public void create(@Nonnull Nifty nifty, @Nonnull NiftyType niftyType, @Nonnull TimeProvider timeProvider) {
        NiftyInputMapping inputMapping;
        String inputMappingPreClass;
        NiftyInputMapping inputMapping2;
        String controller = this.getAttributes().get("controller");
        ScreenController screenController = this.resolveScreenController(nifty, controller);
        String id = this.getAttributes().get("id");
        if (id == null) {
            log.warning("Screen misses ID. Applying automatic ID.");
            id = NiftyIdCreator.generate();
        }
        if (screenController == null) {
            log.warning("Missing ScreenController for screen [" + id + "] using DefaultScreenController() instead but this might not be what you want.");
            screenController = new DefaultScreenController();
        }
        Screen screen = new Screen(nifty, id, screenController, timeProvider);
        screen.setDefaultFocusElement(this.getAttributes().get("defaultFocusElement"));
        String inputMappingClass = this.getAttributes().get("inputMapping");
        if (inputMappingClass != null && (inputMapping2 = ClassHelper.getInstance(inputMappingClass, NiftyInputMapping.class)) != null) {
            if (!(screenController instanceof KeyInputHandler)) {
                log.warning("class [" + controller + "] tries to use inputMapping [" + inputMappingClass + "] but does not implement [" + KeyInputHandler.class.getName() + "]");
            } else {
                screen.addKeyboardInputHandler(inputMapping2, (KeyInputHandler)KeyInputHandler.class.cast(screenController));
            }
        }
        if ((inputMappingPreClass = this.getAttributes().get("inputMappingPre")) != null && (inputMapping = ClassHelper.getInstance(inputMappingPreClass, NiftyInputMapping.class)) != null) {
            if (!(screenController instanceof KeyInputHandler)) {
                log.warning("class [" + controller + "] tries to use inputMapping [" + inputMappingPreClass + "] but does not implement [" + KeyInputHandler.class.getName() + "]");
            } else {
                screen.addPreKeyboardInputHandler(inputMapping, (KeyInputHandler)KeyInputHandler.class.cast(screenController));
            }
        }
        Element rootElement = nifty.getRootLayerFactory().createRootLayer("root", nifty, screen, timeProvider);
        screen.setRootElement(rootElement);
        StopWatch stopWatch = new StopWatch(timeProvider);
        stopWatch.start();
        for (LayerType layerType : this.layers) {
            layerType.prepare(nifty, screen, rootElement.getElementType());
        }
        Logger.getLogger(NiftyLoader.class.getName()).fine("internal prepare screen (" + id + ") [" + stopWatch.stop() + "]");
        stopWatch.start();
        for (LayerType layerType : this.layers) {
            LayoutPart layerLayout = nifty.getRootLayerFactory().createRootLayerLayoutPart(nifty);
            screen.addLayerElement(layerType.create(rootElement, nifty, screen, layerLayout));
        }
        Logger.getLogger(NiftyLoader.class.getName()).fine("internal create screen (" + id + ") [" + stopWatch.stop() + "]");
        screen.processAddAndRemoveLayerElements();
        nifty.addScreen(id, screen);
    }

    @Nullable
    private ScreenController resolveScreenController(@Nonnull Nifty nifty, @Nullable String controller) {
        ScreenController screenController = null;
        if (controller != null && (screenController = nifty.findScreenController(controller)) == null) {
            screenController = ClassHelper.getInstance(controller, ScreenController.class);
        }
        return screenController;
    }
}

