/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.loaderv2.types;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyDefaults;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.NiftyInputControl;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlAttributes;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.ElementRenderer;
import de.lessvoid.nifty.input.NiftyInputMapping;
import de.lessvoid.nifty.layout.LayoutPart;
import de.lessvoid.nifty.loaderv2.types.EffectsType;
import de.lessvoid.nifty.loaderv2.types.InteractType;
import de.lessvoid.nifty.loaderv2.types.StyleType;
import de.lessvoid.nifty.loaderv2.types.XmlBaseType;
import de.lessvoid.nifty.loaderv2.types.helper.CollectionLogger;
import de.lessvoid.nifty.loaderv2.types.helper.ElementRendererCreator;
import de.lessvoid.nifty.loaderv2.types.resolver.style.StyleResolver;
import de.lessvoid.nifty.loaderv2.types.resolver.style.StyleResolverControlDefinintion;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.StringHelper;
import de.lessvoid.xml.tools.ClassHelper;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ElementType
extends XmlBaseType {
    @Nullable
    protected String tagName;
    @Nullable
    protected ElementRendererCreator elementRendererCreator;
    @Nonnull
    protected InteractType interact = new InteractType();
    @Nonnull
    protected EffectsType effects = new EffectsType();
    @Nonnull
    protected final List<ElementType> elements = new ArrayList<ElementType>(0);
    @Nonnull
    protected Deque<Object> controllers = new LinkedList<Object>();
    @Nullable
    protected Controller controller;
    private boolean prepared;

    public ElementType() {
    }

    public ElementType(@Nonnull ElementType src) {
        super(src);
        this.tagName = src.tagName;
        this.elementRendererCreator = src.elementRendererCreator;
        this.interact = new InteractType(src.interact);
        this.effects = new EffectsType(src.effects);
        this.copyElements(src);
    }

    public ElementType(@Nonnull Attributes attributes) {
        super(attributes);
    }

    void mergeFromElementType(@Nonnull ElementType src) {
        this.tagName = src.tagName;
        this.elementRendererCreator = src.elementRendererCreator;
        this.mergeFromAttributes(src.getAttributes());
        this.interact.mergeFromInteractType(src.getInteract());
        this.effects.mergeFromEffectsType(src.getEffects());
        this.copyElements(src);
    }

    void copyElements(@Nonnull ElementType src) {
        this.elements.clear();
        for (ElementType element : src.elements) {
            this.elements.add(element.copy());
        }
    }

    @Nonnull
    public ElementType copy() {
        return new ElementType(this);
    }

    void setElementRendererCreator(@Nullable ElementRendererCreator elementRendererCreatorParam) {
        this.elementRendererCreator = elementRendererCreatorParam;
    }

    void setTagName(@Nullable String tagNameParam) {
        this.tagName = tagNameParam;
    }

    protected void makeFlat() {
        for (ElementType element : this.elements) {
            element.makeFlat();
        }
    }

    public boolean hasElements() {
        return !this.elements.isEmpty();
    }

    public ElementType getFirstElement() {
        return this.elements.iterator().next();
    }

    public void addElementType(@Nonnull ElementType type) {
        this.elements.add(type);
    }

    public void addPanel(@Nonnull ElementType panel) {
        this.elements.add(panel);
    }

    public void addImage(@Nonnull ElementType image) {
        this.elements.add(image);
    }

    public void addLabel(@Nonnull ElementType label) {
        this.elements.add(label);
    }

    public void addText(@Nonnull ElementType text) {
        this.elements.add(text);
    }

    public void addControl(@Nonnull ElementType text) {
        this.elements.add(text);
    }

    public void setInteract(@Nonnull InteractType interactParam) {
        this.interact = interactParam;
    }

    public void setEffect(@Nonnull EffectsType effectsParam) {
        this.effects = effectsParam;
    }

    @Override
    @Nonnull
    public String output(int offset) {
        String result = StringHelper.whitespace(offset) + this.tagName + " [element] " + super.output(offset);
        result = result + "\n" + this.interact.output(offset + 1);
        result = result + "\n" + this.effects.output(offset + 1);
        result = result + "\n" + CollectionLogger.out(offset + 1, this.elements, "elements");
        return result;
    }

    @Nonnull
    public Element create(@Nonnull Element parent, @Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull LayoutPart layoutPart) {
        return this.create(parent, nifty, screen, layoutPart, parent.getChildrenCount());
    }

    @Nonnull
    public Element create(@Nonnull Element parent, @Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull LayoutPart layoutPart, int index) {
        Element element = this.internalCreateElement(parent, nifty, screen, layoutPart, this.getAttributes(), index);
        this.applyStandard(nifty, screen, element);
        return element;
    }

    @Nonnull
    private Element internalCreateElement(@Nonnull Element parent, @Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull LayoutPart layoutPart, @Nonnull Attributes attrib, int index) {
        ElementRenderer[] renderer = null;
        if (this.elementRendererCreator != null) {
            renderer = this.elementRendererCreator.createElementRenderer(nifty);
        }
        if (renderer == null) {
            renderer = new ElementRenderer[]{};
        }
        Element element = new Element(nifty, this, attrib.get("id"), parent, layoutPart, screen.getFocusHandler(), false, nifty.getTimeProvider(), renderer);
        parent.insertChild(element, index);
        return element;
    }

    private void applyStandard(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element) {
        this.applyAttributes(screen, element, this.getAttributes(), nifty.getRenderEngine());
        this.applyEffects(nifty, screen, element);
        this.applyInteract(nifty, screen, element);
        this.applyChildren(element, screen, nifty);
        this.enforceChildLayout(this.getAttributes(), this.elements.size());
        this.applyPostAttributes(element, this.getAttributes(), nifty.getRenderEngine());
        if (this.controller != null) {
            NiftyInputControl niftyInputControl = this.createNiftyInputControl(this.getAttributes(), this.controller);
            element.attachInputControl(niftyInputControl);
        }
    }

    private void enforceChildLayout(@Nonnull Attributes attributes, int childCount) {
        if (!attributes.isSet("childLayout") && childCount > 0) {
            throw new RuntimeException("missing childLayout attribute for an element with [" + childCount + "] child elements. Attributes of error element [" + attributes.toString() + "]");
        }
    }

    @Nonnull
    List<Object> getControllersWithScreenController(@Nonnull Screen screen) {
        LinkedList<Object> withScreenController = new LinkedList<Object>(this.controllers);
        withScreenController.add(screen.getScreenController());
        return withScreenController;
    }

    @Nullable
    private NiftyInputControl createNiftyInputControl(@Nonnull Attributes controlDefinitionAttributes, @Nonnull Controller controller) {
        String inputMappingClass = controlDefinitionAttributes.get("inputMapping");
        NiftyInputMapping inputMapping = null;
        if (inputMappingClass != null) {
            inputMapping = ClassHelper.getInstance(inputMappingClass, NiftyInputMapping.class);
        }
        if (inputMapping == null) {
            inputMapping = NiftyDefaults.getDefaultInputMapping();
        }
        return new NiftyInputControl(controller, inputMapping);
    }

    public void applyAttributes(@Nonnull Screen screen, @Nonnull Element element, @Nullable Attributes work, @Nonnull NiftyRenderEngine renderEngine) {
        if (work == null) {
            return;
        }
        element.initializeFromAttributes(screen, work, renderEngine);
    }

    public void applyPostAttributes(@Nonnull Element element, @Nullable Attributes work, @Nonnull NiftyRenderEngine renderEngine) {
        if (work == null) {
            return;
        }
        element.initializeFromPostAttributes(work);
    }

    public void applyEffects(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element) {
        this.effects.materialize(nifty, element, screen, this.getControllersWithScreenController(screen));
    }

    public void applyInteract(Nifty nifty, @Nonnull Screen screen, @Nonnull Element element) {
        this.interact.materialize(nifty, element, this.getControllersWithScreenController(screen).toArray());
    }

    protected void applyChildren(@Nonnull Element parent, @Nonnull Screen screen, @Nonnull Nifty nifty) {
        for (ElementType elementType : this.elements) {
            elementType.create(parent, nifty, screen, new LayoutPart());
        }
    }

    public void refreshAttributes(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull ControlAttributes attributes) {
        Attributes attrib = new Attributes(this.getAttributes());
        attributes.refreshAttributes(attrib);
        this.applyAttributes(screen, element, attrib, nifty.getRenderEngine());
        this.applyPostAttributes(element, attrib, nifty.getRenderEngine());
        attributes.refreshEffects(this.effects);
        element.getParent().layoutElements();
    }

    @Nonnull
    public InteractType getInteract() {
        return this.interact;
    }

    @Nonnull
    public EffectsType getEffects() {
        return this.effects;
    }

    @Nonnull
    public Collection<ElementType> getElements() {
        return this.elements;
    }

    public void prepare(@Nonnull Nifty nifty, @Nullable Screen screen, @Nonnull ElementType rootElementType) {
        this.prepared = true;
        this.translateSpecialValues(nifty, screen);
        this.makeFlat();
        this.applyControls(nifty);
        this.applyStyles(nifty.getDefaultStyleResolver());
        this.resolveParameters(rootElementType.getAttributes());
        this.makeFlatControls();
        this.translateSpecialValues(nifty, screen);
        this.resolveControllers(nifty, new LinkedList<Object>());
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public void translateSpecialValues(@Nonnull Nifty nifty, @Nullable Screen screen) {
        super.translateSpecialValues(nifty, screen);
        this.interact.translateSpecialValues(nifty, screen);
        this.effects.translateSpecialValues(nifty, screen);
        for (ElementType e : this.elements) {
            e.translateSpecialValues(nifty, screen);
        }
    }

    void resolveParameters(@Nonnull Attributes parentAttributes) {
        this.getAttributes().resolveParameters(parentAttributes);
        Attributes newParent = new Attributes(parentAttributes);
        newParent.merge(this.getAttributes());
        this.interact.resolveParameters(newParent);
        this.effects.resolveParameters(newParent);
        for (ElementType elementType : this.elements) {
            elementType.resolveParameters(newParent);
        }
    }

    void applyControls(@Nonnull Nifty nifty) {
        this.internalApplyControl(nifty);
        for (int i = 0; i < this.elements.size(); ++i) {
            this.elements.get(i).applyControls(nifty);
        }
    }

    void internalApplyControl(@Nonnull Nifty nifty) {
    }

    void makeFlatControls() {
        for (ElementType elementType : this.elements) {
            elementType.makeFlatControls();
        }
        this.makeFlatControlsInternal();
    }

    void makeFlatControlsInternal() {
    }

    public void applyStyles(@Nonnull StyleResolver styleResolver) {
        StyleResolver childStyleResolver = this.applyStyleInternal(styleResolver);
        for (ElementType elementType : this.elements) {
            elementType.applyStyles(childStyleResolver);
        }
    }

    @Nonnull
    StyleResolver applyStyleInternal(@Nonnull StyleResolver styleResolver) {
        String style = this.getAttributes().get("style");
        if (style != null) {
            StyleType styleType = styleResolver.resolve(style);
            if (styleType != null) {
                styleType.applyTo(this, styleResolver);
            }
            if (!style.startsWith("#")) {
                return new StyleResolverControlDefinintion(styleResolver, style);
            }
        }
        return styleResolver;
    }

    public void attachController(@Nullable Controller controller) {
        this.controller = controller;
    }

    void resolveControllers(@Nonnull Nifty nifty, @Nonnull Collection<Object> controllerParam) {
        this.controllers = new LinkedList<Object>(controllerParam);
        if (this.controller == null) {
            this.controller = nifty.getControllerFactory().create(this.getAttributes().get("controller"));
        }
        if (this.controller != null) {
            this.controllers.addFirst(this.controller);
        }
        for (ElementType elementType : this.elements) {
            elementType.resolveControllers(nifty, this.controllers);
        }
    }

    public void removeWithTag(@Nonnull String styleId) {
        this.getAttributes().removeWithTag(styleId);
        this.effects.removeWithTag(styleId);
        this.interact.getAttributes().removeWithTag(styleId);
    }

    public void connectParentControls(@Nonnull Element parent) {
        NiftyInputControl control = parent.getAttachedInputControl();
        if (control != null) {
            Controller controller = control.getController();
            this.controllers.addLast(controller);
        }
        if (parent.hasParent()) {
            this.connectParentControls(parent.getParent());
        }
    }
}

