/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.loaderv2.types;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.loaderv2.types.ControlDefinitionType;
import de.lessvoid.nifty.loaderv2.types.ElementType;
import de.lessvoid.nifty.loaderv2.types.helper.NullElementRendererCreator;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ControlType
extends ElementType {
    private static final Logger log = Logger.getLogger(ControlType.class.getName());
    @Nonnull
    private static final Pattern ID_SPLIT = Pattern.compile("(?<=.)(?=#)");

    public ControlType() {
    }

    public ControlType(@Nonnull ControlType src) {
        super(src);
    }

    public ControlType(@Nonnull Attributes attributes) {
        super(attributes);
    }

    @Override
    @Nonnull
    public ElementType copy() {
        return new ControlType(this);
    }

    @Override
    protected void makeFlat() {
        super.makeFlat();
        this.setTagName("<control>");
        this.setElementRendererCreator(new NullElementRendererCreator());
    }

    @Nullable
    private String getType() {
        String type = this.getAttributes().get("type");
        if (type != null) {
            return type;
        }
        return this.getAttributes().get("name");
    }

    @Override
    void internalApplyControl(@Nonnull Nifty nifty) {
        ControlDefinitionType controlDefinition = nifty.resolveControlDefinition(this.getType());
        if (controlDefinition == null) {
            log.warning("controlDefinition [" + this.getType() + "] missing.");
            return;
        }
        ArrayList<ElementType> childCopy = new ArrayList<ElementType>();
        childCopy.addAll(this.elements);
        this.mergeFromElementType(controlDefinition);
        String childRootId = this.getAttributes().get("childRootId");
        if (childRootId != null && !this.addChildrenToChildRoot(this, childRootId, childCopy)) {
            log.warning("childRootId [" + childRootId + "] could not be found in any childs of [" + this + "]");
        }
    }

    @Override
    void makeFlatControlsInternal() {
        if (!this.elements.isEmpty()) {
            this.mergeFromElementType((ElementType)this.elements.get(0));
        }
        String id = this.getAttributes().get("id");
        this.resolveIds(this, id, id);
    }

    private void resolveIds(@Nonnull ElementType parent, @Nullable String parentId, @Nullable String grantParentId) {
        String usedParent = parentId == null ? grantParentId : parentId;
        for (ElementType element : parent.elements) {
            String id = element.getAttributes().get("id");
            if (usedParent != null && id != null && id.startsWith("#")) {
                id = usedParent + ControlType.getRealChildrenId(usedParent, id);
                element.getAttributes().set("id", id);
            }
            this.resolveIds(element, id, grantParentId);
        }
    }

    @Nonnull
    static String getRealChildrenId(@Nonnull CharSequence parent, @Nonnull String child) {
        int lastSharpIndex = child.lastIndexOf(35);
        if (lastSharpIndex <= 0) {
            return child;
        }
        String[] elementIdParts = ID_SPLIT.split(child);
        String[] parentIdParts = ID_SPLIT.split(parent);
        int currentIndex = -1;
        while (currentIndex < parentIdParts.length) {
            if ((currentIndex = ControlType.findInArray(parentIdParts, currentIndex + 1, elementIdParts[0])) == -1) {
                return child;
            }
            if (!ControlType.isOverlapping(parentIdParts, currentIndex, elementIdParts)) continue;
            int remaining = parentIdParts.length - currentIndex;
            StringBuilder idBuilder = new StringBuilder();
            for (int i = remaining; i < elementIdParts.length; ++i) {
                idBuilder.append(elementIdParts[i]);
            }
            return idBuilder.toString();
        }
        return child;
    }

    private static boolean isOverlapping(@Nonnull String[] parentId, int startIndex, @Nonnull String[] childId) {
        int remaining = parentId.length - startIndex;
        if (remaining >= childId.length) {
            return false;
        }
        for (int i = startIndex; i < parentId.length; ++i) {
            if (parentId[i].equals(childId[i - startIndex])) continue;
            return false;
        }
        return true;
    }

    private static int findInArray(@Nonnull String[] haystack, int startIndex, @Nonnull String needle) {
        for (int i = startIndex; i < haystack.length; ++i) {
            if (!haystack[i].equals(needle)) continue;
            return i;
        }
        return -1;
    }

    private boolean addChildrenToChildRoot(@Nonnull ElementType elementType, @Nonnull String childRootId, @Nonnull Collection<ElementType> children) {
        if (children.isEmpty()) {
            return true;
        }
        for (ElementType element : elementType.elements) {
            if (childRootId.equals(element.getAttributes().get("id"))) {
                element.elements.clear();
                element.elements.addAll(children);
                return true;
            }
            if (!this.addChildrenToChildRoot(element, childRootId, children)) continue;
            return true;
        }
        return false;
    }
}

