/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.layout.manager;

import de.lessvoid.nifty.layout.Box;
import de.lessvoid.nifty.layout.BoxConstraints;
import de.lessvoid.nifty.layout.LayoutPart;
import de.lessvoid.nifty.layout.manager.LayoutManager;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AbsolutePositionLayout
implements LayoutManager {
    @Nonnull
    private static final DefaultPostProcess defaultPostProcess = new DefaultPostProcess();
    @Nonnull
    private final PostProcess post;

    public AbsolutePositionLayout() {
        this.post = defaultPostProcess;
    }

    public AbsolutePositionLayout(@Nonnull PostProcess post) {
        this.post = post;
    }

    @Override
    public void layoutElements(@Nullable LayoutPart rootElement, @Nullable List<LayoutPart> elements) {
        if (rootElement == null || elements == null || elements.size() == 0) {
            return;
        }
        int rootBoxX = this.getRootBoxX(rootElement);
        int rootBoxY = this.getRootBoxY(rootElement);
        int rootBoxWidth = this.getRootBoxWidth(rootElement);
        int rootBoxHeight = this.getRootBoxHeight(rootElement);
        for (int i = 0; i < elements.size(); ++i) {
            LayoutPart p = elements.get(i);
            Box box = p.getBox();
            BoxConstraints cons = p.getBoxConstraints();
            if (cons.getX().hasValue()) {
                box.setX(rootBoxX + cons.getX().getValueAsInt(rootBoxWidth));
            } else {
                box.setX(0);
            }
            if (cons.getY().hasValue()) {
                box.setY(rootBoxY + cons.getY().getValueAsInt(rootBoxHeight));
            } else {
                box.setY(0);
            }
            if (cons.getWidth().hasHeightSuffix()) {
                if (cons.getHeight().hasValue()) {
                    box.setHeight(cons.getHeight().getValueAsInt(rootBoxHeight));
                }
                box.setWidth(cons.getWidth().getValueAsInt(box.getHeight()));
            } else if (cons.getHeight().hasWidthSuffix()) {
                if (cons.getWidth().hasValue()) {
                    box.setWidth(cons.getWidth().getValueAsInt(rootBoxWidth));
                }
                box.setHeight(cons.getHeight().getValueAsInt(box.getWidth()));
            } else {
                if (cons.getWidth().hasValue()) {
                    box.setWidth(cons.getWidth().getValueAsInt(rootBoxWidth));
                } else {
                    box.setWidth(0);
                }
                if (cons.getHeight().hasValue()) {
                    box.setHeight(cons.getHeight().getValueAsInt(rootBoxHeight));
                } else {
                    box.setHeight(0);
                }
            }
            this.post.process(rootBoxX, rootBoxY, rootBoxWidth, rootBoxHeight, box);
        }
    }

    @Override
    @Nonnull
    public final SizeValue calculateConstraintWidth(@Nonnull LayoutPart root, @Nonnull List<LayoutPart> children) {
        return SizeValue.def();
    }

    @Override
    @Nonnull
    public final SizeValue calculateConstraintHeight(@Nonnull LayoutPart root, @Nonnull List<LayoutPart> children) {
        return SizeValue.def();
    }

    private int getRootBoxX(@Nonnull LayoutPart root) {
        return root.getBox().getX() + root.getBoxConstraints().getPaddingLeft().getValueAsInt(root.getBox().getWidth());
    }

    private int getRootBoxY(@Nonnull LayoutPart root) {
        return root.getBox().getY() + root.getBoxConstraints().getPaddingTop().getValueAsInt(root.getBox().getHeight());
    }

    private int getRootBoxWidth(@Nonnull LayoutPart root) {
        return root.getBox().getWidth() - root.getBoxConstraints().getPaddingLeft().getValueAsInt(root.getBox().getWidth()) - root.getBoxConstraints().getPaddingRight().getValueAsInt(root.getBox().getWidth());
    }

    private int getRootBoxHeight(@Nonnull LayoutPart root) {
        return root.getBox().getHeight() - root.getBoxConstraints().getPaddingTop().getValueAsInt(root.getBox().getHeight()) - root.getBoxConstraints().getPaddingBottom().getValueAsInt(root.getBox().getHeight());
    }

    public static class KeepInsidePostProcess
    implements PostProcess {
        @Override
        public void process(int rootBoxX, int rootBoxY, int rootBoxWidth, int rootBoxHeight, @Nonnull Box box) {
            if (box.getWidth() > rootBoxWidth) {
                box.setWidth(rootBoxWidth);
            }
            if (box.getHeight() > rootBoxHeight) {
                box.setHeight(rootBoxHeight);
            }
            if (box.getX() < rootBoxX) {
                box.setX(rootBoxX);
            }
            if (box.getY() < rootBoxY) {
                box.setY(rootBoxY);
            }
            if (box.getX() + box.getWidth() > rootBoxX + rootBoxWidth) {
                box.setX(rootBoxX + rootBoxWidth - box.getWidth());
            }
            if (box.getY() + box.getHeight() > rootBoxY + rootBoxHeight) {
                box.setY(rootBoxY + rootBoxHeight - box.getHeight());
            }
        }
    }

    public static class DefaultPostProcess
    implements PostProcess {
        @Override
        public void process(int rootBoxX, int rootBoxY, int rootBoxWidth, int rootBoxHeight, @Nonnull Box box) {
        }
    }

    public static interface PostProcess {
        public void process(int var1, int var2, int var3, int var4, @Nonnull Box var5);
    }
}

