/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.elements.tools;

import de.lessvoid.nifty.spi.render.RenderFont;
import javax.annotation.Nonnull;

public class FontHelper {
    public static int getVisibleCharactersFromStart(@Nonnull RenderFont font, @Nonnull CharSequence text, int width, float size) {
        int widthRemaining = width;
        for (int i = 0; i < text.length(); ++i) {
            char nextCharacter;
            char currentCharacter = text.charAt(i);
            int w = font.getCharacterAdvance(currentCharacter, nextCharacter = FontHelper.getNextCharacter(text, i), size);
            if (w == -1 || (widthRemaining -= w) >= 0) continue;
            return i;
        }
        return text.length();
    }

    public static int getVisibleCharactersFromEnd(@Nonnull RenderFont font, @Nonnull CharSequence text, int width, float size) {
        int widthRemaining = width;
        for (int i = text.length() - 1; i >= 0; --i) {
            char currentCharacter = text.charAt(i);
            char prevCharacter = FontHelper.getPrevCharacter(text, i);
            int w = font.getCharacterAdvance(prevCharacter, currentCharacter, size);
            if (w == -1 || (widthRemaining -= w) >= 0) continue;
            return i;
        }
        return 0;
    }

    public static int getCharacterIndexFromPixelPosition(@Nonnull RenderFont font, @Nonnull CharSequence text, int pixel, float size) {
        if (pixel < 0) {
            return -1;
        }
        int current = 0;
        for (int i = 0; i < text.length(); ++i) {
            char nextCharacter;
            char currentCharacter = text.charAt(i);
            int w = font.getCharacterAdvance(currentCharacter, nextCharacter = FontHelper.getNextCharacter(text, i), size);
            if (w == -1) continue;
            if (pixel >= current && pixel <= current + w) {
                return i;
            }
            current += w;
        }
        return text.length();
    }

    public static char getNextCharacter(@Nonnull CharSequence text, int i) {
        char nextc = '\u0000';
        if (i < text.length() - 1) {
            nextc = text.charAt(i + 1);
        }
        return nextc;
    }

    public static char getPrevCharacter(@Nonnull CharSequence text, int i) {
        char prevc = '\u0000';
        if (i > 0) {
            prevc = text.charAt(i - 1);
        }
        return prevc;
    }
}

