/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.elements.render;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyLocaleChangedEvent;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.ElementRenderer;
import de.lessvoid.nifty.elements.tools.FontHelper;
import de.lessvoid.nifty.elements.tools.TextBreak;
import de.lessvoid.nifty.layout.align.HorizontalAlign;
import de.lessvoid.nifty.layout.align.VerticalAlign;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bushe.swing.event.EventSubscriber;

public class TextRenderer
implements ElementRenderer,
EventSubscriber<NiftyLocaleChangedEvent> {
    @Nonnull
    public static final Color DEFAULT_COLOR = Color.WHITE;
    @Nullable
    private RenderFont font;
    @Nonnull
    private String originalText;
    @Nullable
    private String[] textLines;
    private int maxWidth;
    private int xOffsetHack = 0;
    private int selectionStart = -1;
    private int selectionEnd = -1;
    @Nonnull
    private Color textSelectionColor = Color.BLACK;
    @Nonnull
    private VerticalAlign textVAlign = VerticalAlign.center;
    @Nonnull
    private HorizontalAlign textHAlign = HorizontalAlign.center;
    @Nonnull
    private Color color = DEFAULT_COLOR;
    private boolean lineWrapping = false;
    @Nonnull
    private SizeValue textLineHeight = SizeValue.def();
    @Nonnull
    private SizeValue textMinHeight = SizeValue.def();
    @Nonnull
    private final Nifty nifty;
    private boolean isCalculatedLineWrapping = false;
    @Nonnull
    private SizeValue originalConstraintWidth = SizeValue.def();
    @Nonnull
    private SizeValue originalConstraintHeight = SizeValue.def();
    @Nullable
    private Element hasBeenLayoutedElement;
    private String originalTextBeforeSpecialValues;

    public TextRenderer(@Nonnull Nifty nifty) {
        this.nifty = nifty;
        this.nifty.getEventService().subscribe(NiftyLocaleChangedEvent.class, (EventSubscriber)this);
        this.originalText = "";
    }

    public TextRenderer(@Nonnull Nifty nifty, @Nonnull RenderFont newFont, @Nullable String newText) {
        this.nifty = nifty;
        this.nifty.getEventService().subscribe(NiftyLocaleChangedEvent.class, (EventSubscriber)this);
        this.init(newFont, newText);
    }

    public void setText(@Nullable String newText) {
        this.initText(newText, true);
    }

    private void init(@Nonnull RenderFont newFont, @Nullable String newText) {
        this.font = newFont;
        this.initText(newText, false);
    }

    private void initText(@Nullable String text, boolean changeExistingText) {
        this.originalTextBeforeSpecialValues = text;
        String newText = this.nifty.specialValuesReplace(text);
        if (this.lineWrapping && this.isCalculatedLineWrapping) {
            this.isCalculatedLineWrapping = false;
        }
        this.originalText = newText;
        this.textLines = newText.split("\n", -1);
        if (changeExistingText && this.hasBeenLayoutedElement != null) {
            this.hasBeenLayoutedElement.getParent().layoutElements();
        }
        this.maxWidth = 0;
        if (this.font != null) {
            for (int i = 0; i < this.textLines.length; ++i) {
                String line = this.textLines[i];
                int lineWidth = this.font.getWidth(line);
                if (lineWidth <= this.maxWidth) continue;
                this.maxWidth = lineWidth;
            }
        }
    }

    @Override
    public void render(@Nonnull Element w, @Nonnull NiftyRenderEngine r) {
        if (this.textLines == null) {
            return;
        }
        this.renderLines(w, r, this.textLines);
    }

    private void renderLines(@Nonnull Element w, @Nonnull NiftyRenderEngine r, String ... lines) {
        RenderFont font = this.ensureFont(r);
        if (font == null) {
            return;
        }
        boolean stateSaved = this.prepareRenderEngine(r, font);
        int y = TextRenderer.getStartYWithVerticalAlign(lines.length * font.getHeight(), w.getHeight(), this.textVAlign);
        for (String line : lines) {
            int yy = w.getY() + y;
            if (Math.abs(this.xOffsetHack) > 0) {
                int fittingOffset = FontHelper.getVisibleCharactersFromStart(font, line, Math.abs(this.xOffsetHack), 1.0f);
                String cut = line.substring(0, fittingOffset);
                String substring = line.substring(fittingOffset, line.length());
                int xx = w.getX() + this.xOffsetHack + font.getWidth(cut);
                this.renderLine(xx, yy, substring, r, this.selectionStart - fittingOffset, this.selectionEnd - fittingOffset);
            } else {
                int xx = w.getX() + TextRenderer.getStartXWithHorizontalAlign(font.getWidth(line), w.getWidth(), this.textHAlign);
                this.renderLine(xx, yy, line, r, this.selectionStart, this.selectionEnd);
            }
            y += font.getHeight();
        }
        this.restoreRenderEngine(r, stateSaved);
    }

    private boolean prepareRenderEngine(@Nonnull NiftyRenderEngine r, RenderFont font) {
        if (!r.isColorChanged()) {
            if (r.isColorAlphaChanged()) {
                r.setColorIgnoreAlpha(this.color);
            } else {
                r.setColor(this.color);
            }
        }
        boolean stateSaved = false;
        if (r.getFont() == null) {
            r.saveStates();
            r.setFont(font);
            stateSaved = true;
        }
        return stateSaved;
    }

    private void restoreRenderEngine(@Nonnull NiftyRenderEngine r, boolean stateSaved) {
        if (stateSaved) {
            r.restoreStates();
        }
    }

    @Nullable
    private RenderFont ensureFont(@Nonnull NiftyRenderEngine r) {
        if (this.font == null) {
            return r.getFont();
        }
        return this.font;
    }

    protected static int getStartYWithVerticalAlign(int textHeight, int elementHeight, VerticalAlign verticalAlign) {
        if (VerticalAlign.top == verticalAlign) {
            return 0;
        }
        if (VerticalAlign.center == verticalAlign) {
            return (elementHeight - textHeight) / 2;
        }
        if (VerticalAlign.bottom == verticalAlign) {
            return elementHeight - textHeight;
        }
        return 0;
    }

    protected static int getStartXWithHorizontalAlign(int textWidth, int elementWidth, HorizontalAlign horizontalAlign) {
        if (HorizontalAlign.left == horizontalAlign) {
            return 0;
        }
        if (HorizontalAlign.center == horizontalAlign) {
            return (elementWidth - textWidth) / 2;
        }
        if (HorizontalAlign.right == horizontalAlign) {
            return elementWidth - textWidth;
        }
        return 0;
    }

    private void renderLine(int xx, int yy, @Nonnull String line, @Nonnull NiftyRenderEngine r, int selStart, int selEnd) {
        r.renderText(line, xx, yy, selStart, selEnd, this.textSelectionColor);
    }

    public int getTextWidth() {
        return this.maxWidth;
    }

    public int getTextHeight() {
        RenderFont font = this.ensureFont(this.nifty.getRenderEngine());
        if (font == null || this.textLines == null) {
            return 0;
        }
        int calculatedHeight = font.getHeight() * this.textLines.length;
        if (this.textLineHeight.hasValue()) {
            calculatedHeight = this.textLineHeight.getValueAsInt(1.0f) * this.textLines.length;
        }
        if (this.textMinHeight.hasValue() && calculatedHeight < this.textMinHeight.getValueAsInt(1.0f)) {
            return this.textMinHeight.getValueAsInt(1.0f);
        }
        return calculatedHeight;
    }

    public void setxOffsetHack(int newXoffsetHack) {
        this.xOffsetHack = newXoffsetHack;
    }

    @Nullable
    public RenderFont getFont() {
        return this.font;
    }

    public void setSelection(int selectionStartParam, int selectionEndParam) {
        this.selectionStart = selectionStartParam;
        this.selectionEnd = selectionEndParam;
    }

    public void setFont(@Nullable RenderFont fontParam) {
        this.font = fontParam;
    }

    public void setTextSelectionColor(@Nonnull Color textSelectionColorParam) {
        this.textSelectionColor = textSelectionColorParam;
    }

    public void setTextVAlign(@Nonnull VerticalAlign newTextVAlign) {
        this.textVAlign = newTextVAlign;
    }

    public void setTextHAlign(@Nonnull HorizontalAlign newTextHAlign) {
        this.textHAlign = newTextHAlign;
    }

    public void setColor(@Nonnull Color newColor) {
        this.color = newColor;
    }

    @Nonnull
    public String getOriginalText() {
        return this.originalText;
    }

    @Nonnull
    public String getWrappedText() {
        StringBuilder result = new StringBuilder();
        if (this.textLines != null && this.textLines.length > 0) {
            result.append(this.textLines[0]);
            for (int i = 1; i < this.textLines.length; ++i) {
                result.append('\n').append(this.textLines[i]);
            }
        }
        return result.toString();
    }

    public void setTextLineHeight(@Nonnull SizeValue textLineHeight) {
        this.textLineHeight = textLineHeight;
    }

    public void setTextMinHeight(@Nonnull SizeValue textMinHeight) {
        this.textMinHeight = textMinHeight;
    }

    @Nonnull
    private String[] wrapText(int width, @Nonnull NiftyRenderEngine r, String ... textLines) {
        RenderFont font = this.ensureFont(r);
        if (font == null) {
            return textLines;
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : textLines) {
            int lineLengthInPixel = font.getWidth(line);
            if (lineLengthInPixel > width) {
                lines.addAll(new TextBreak(line, width, font).split());
                continue;
            }
            lines.add(line);
        }
        return lines.toArray(new String[lines.size()]);
    }

    public void setWidthConstraint(@Nonnull Element element, @Nonnull SizeValue elementConstraintWidth, int parentWidth, @Nonnull NiftyRenderEngine renderEngine) {
        if (parentWidth == 0 || !this.lineWrapping || this.isCalculatedLineWrapping) {
            return;
        }
        int valueAsInt = element.getWidth();
        if (valueAsInt == 0) {
            valueAsInt = elementConstraintWidth.getValueAsInt(parentWidth);
        }
        if (valueAsInt <= 0) {
            return;
        }
        this.hasBeenLayoutedElement = element;
        this.textLines = this.wrapText(valueAsInt, renderEngine, this.originalText.split("\n", -1));
        this.maxWidth = valueAsInt;
        this.isCalculatedLineWrapping = true;
        this.originalConstraintWidth = element.getConstraintWidth();
        this.originalConstraintHeight = element.getConstraintHeight();
        element.setConstraintWidth(elementConstraintWidth.hasWildcard() ? SizeValue.wildcard(this.getTextWidth()) : SizeValue.px(this.getTextWidth()));
        element.setConstraintHeight(SizeValue.px(this.getTextHeight()));
    }

    public void setLineWrapping(boolean lineWrapping) {
        this.lineWrapping = lineWrapping;
    }

    public boolean isLineWrapping() {
        return this.lineWrapping;
    }

    @Nonnull
    public VerticalAlign getTextVAlign() {
        return this.textVAlign;
    }

    @Nonnull
    public HorizontalAlign getTextHAlign() {
        return this.textHAlign;
    }

    @Nonnull
    public Color getColor() {
        return this.color;
    }

    public void resetLayout(@Nonnull Element element) {
        if (this.isCalculatedLineWrapping) {
            this.isCalculatedLineWrapping = false;
            element.setConstraintWidth(this.originalConstraintWidth);
            element.setConstraintHeight(this.originalConstraintHeight);
        }
    }

    @Nonnull
    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    @Override
    public void onEvent(NiftyLocaleChangedEvent event) {
        this.setText(this.originalTextBeforeSpecialValues);
    }
}

