/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.elements;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.events.NiftyMouseEvent;
import de.lessvoid.nifty.elements.events.NiftyMouseMovedEvent;
import de.lessvoid.nifty.elements.events.NiftyMouseWheelEvent;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import javax.annotation.Nonnull;

public class ElementInteractionMoveHandler {
    @Nonnull
    private final Nifty nifty;
    @Nonnull
    private final Element element;
    private int lastMouseX;
    private int lastMouseY;
    private boolean lastButton0Down;
    private boolean lastButton1Down;
    private boolean lastButton2Down;

    public ElementInteractionMoveHandler(@Nonnull Nifty nifty, @Nonnull Element element) {
        this.nifty = nifty;
        this.element = element;
        this.lastMouseX = 0;
        this.lastMouseY = 0;
        this.lastButton0Down = false;
        this.lastButton1Down = false;
        this.lastButton2Down = false;
    }

    public boolean process(boolean canHandleInteraction, boolean mouseInside, boolean hasMouseAccess, @Nonnull NiftyMouseInputEvent mouseEvent) {
        if (canHandleInteraction && mouseInside) {
            boolean moved = this.handleMoveEvent(mouseEvent);
            boolean wheel = this.handleWheelEvent(mouseEvent);
            if (moved || wheel) {
                this.handleGeneralEvent(mouseEvent);
                return true;
            }
            boolean generateEvent = false;
            if (mouseEvent.isButton0Down() != this.lastButton0Down) {
                this.lastButton0Down = mouseEvent.isButton0Down();
                generateEvent = true;
            }
            if (mouseEvent.isButton1Down() != this.lastButton1Down) {
                this.lastButton1Down = mouseEvent.isButton1Down();
                generateEvent = true;
            }
            if (mouseEvent.isButton2Down() != this.lastButton2Down) {
                this.lastButton2Down = mouseEvent.isButton2Down();
                generateEvent = true;
            }
            if (generateEvent) {
                this.handleGeneralEvent(mouseEvent);
                return true;
            }
        }
        return false;
    }

    private boolean handleMoveEvent(@Nonnull NiftyMouseInputEvent mouseEvent) {
        String id = this.element.getId();
        if (id != null && (mouseEvent.getMouseX() != this.lastMouseX || mouseEvent.getMouseY() != this.lastMouseY)) {
            this.lastMouseX = mouseEvent.getMouseX();
            this.lastMouseY = mouseEvent.getMouseY();
            this.nifty.publishEvent(id, new NiftyMouseMovedEvent(this.element, mouseEvent));
            return true;
        }
        return false;
    }

    private boolean handleWheelEvent(@Nonnull NiftyMouseInputEvent mouseEvent) {
        String id = this.element.getId();
        if (id != null && mouseEvent.getMouseWheel() != 0) {
            this.nifty.publishEvent(id, new NiftyMouseWheelEvent(this.element, mouseEvent));
            return true;
        }
        return false;
    }

    private void handleGeneralEvent(@Nonnull NiftyMouseInputEvent mouseEvent) {
        String id = this.element.getId();
        if (id != null) {
            this.nifty.publishEvent(id, new NiftyMouseEvent(this.element, mouseEvent));
        }
    }
}

