/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Shake
implements EffectImpl {
    private float distance;
    private boolean global;

    @Override
    public void activate(@Nonnull Nifty nifty, @Nonnull Element element, @Nonnull EffectProperties parameter) {
        this.distance = Float.parseFloat(parameter.getProperty("distance", "10.0"));
        this.global = "true".equals(parameter.getProperty("global", "true").toLowerCase());
    }

    @Override
    public void execute(@Nonnull Element element, float normalizedTime, @Nullable Falloff falloff, @Nonnull NiftyRenderEngine r) {
        if (normalizedTime > 0.0f) {
            float d = this.distance;
            float x = -d + (float)Math.random() * 2.0f * d;
            float y = -d + (float)Math.random() * 2.0f * d;
            if (normalizedTime >= 0.99f) {
                x = 0.0f;
                y = 0.0f;
            }
            if (this.global) {
                r.setGlobalPosition(x, y);
            } else {
                r.moveTo(x, y);
            }
        }
    }

    @Override
    public void deactivate() {
    }
}

