/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyIdCreator;
import de.lessvoid.nifty.builder.ControlBuilder;
import de.lessvoid.nifty.builder.ElementBuilder;
import de.lessvoid.nifty.builder.LayerBuilder;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Hint
implements EffectImpl {
    @Nonnull
    private static final Logger log = Logger.getLogger(Hint.class.getName());
    @Nonnull
    private static final String HINT_LAYER_ID = "niftyHintLayer";
    @Nullable
    private Nifty nifty;
    @Nullable
    private Screen screen;
    @Nullable
    private Element hintLayer;
    @Nullable
    private Element hintPanel;
    private int hintDelay;
    @Nullable
    private String offsetX;
    @Nullable
    private String offsetY;

    @Override
    public void activate(@Nonnull Nifty nifty, @Nonnull Element element, @Nonnull EffectProperties parameter) {
        this.nifty = nifty;
        this.screen = nifty.getCurrentScreen();
        if (this.screen == null) {
            log.severe("Can't activate hint effect without a screen that is currently active.");
            return;
        }
        String hintControl = parameter.getProperty("hintControl", "nifty-default-hint");
        String hintStyle = parameter.getProperty("hintStyle", null);
        String hintText = parameter.getProperty("hintText", "hint: add a 'hintText' attribute to the hint effect :)");
        this.hintDelay = Integer.valueOf(parameter.getProperty("hintDelay", "0"));
        this.offsetX = parameter.getProperty("offsetX", "0");
        this.offsetY = parameter.getProperty("offsetY", "0");
        Element hintLayer = this.getHintLayer();
        hintLayer.setVisible(false);
        ControlBuilder builder = new ControlBuilder(NiftyIdCreator.generate(), hintControl);
        builder.parameter("hintText", hintText);
        if (hintStyle != null) {
            builder.style(hintStyle);
        }
        this.hintPanel = builder.build(nifty, this.screen, hintLayer);
    }

    @Nonnull
    private Element getHintLayer() {
        if (this.hintLayer != null) {
            return this.hintLayer;
        }
        if (this.screen == null || this.nifty == null) {
            throw new IllegalStateException("Can't create or retrieve hint layer while there is no active screen.");
        }
        this.hintLayer = this.screen.findElementById(HINT_LAYER_ID);
        if (this.hintLayer != null) {
            return this.hintLayer;
        }
        LayerBuilder builder = new LayerBuilder(HINT_LAYER_ID);
        builder.childLayout(ElementBuilder.ChildLayoutType.Absolute);
        builder.visible(false);
        this.hintLayer = builder.build(this.nifty, this.screen, this.screen.getRootElement());
        this.hintLayer.setRenderOrder(Integer.MAX_VALUE);
        return this.hintLayer;
    }

    @Override
    public void execute(@Nonnull Element element, float normalizedTime, @Nullable Falloff falloff, @Nonnull NiftyRenderEngine r) {
        if (this.nifty == null || this.screen == null || this.hintLayer == null || this.hintPanel == null) {
            log.severe("Can't execute effect. Activation not done or failed.");
            return;
        }
        if ((double)normalizedTime > 0.0 && !this.hintLayer.isVisible() && this.nifty.getNiftyMouse().getNoMouseMovementTime() > (long)this.hintDelay) {
            this.hintPanel.setConstraintX(SizeValue.px(this.getPosX(element, this.hintPanel, r.getWidth())));
            this.hintPanel.setConstraintY(SizeValue.px(this.getPosY(element, this.hintPanel, r.getHeight())));
            List<Element> hints = this.hintLayer.getChildren();
            for (int i = 0; i < hints.size() - 1; ++i) {
                this.nifty.removeElement(this.screen, hints.get(i));
            }
            this.hintLayer.layoutElements();
            this.hintLayer.show();
        }
    }

    @Override
    public void deactivate() {
        if (this.hintPanel != null) {
            if (this.hintPanel.isVisible()) {
                this.hintPanel.startEffect(EffectEventId.onCustom, new EndNotify(){

                    @Override
                    public void perform() {
                        Hint.this.removePanel();
                    }
                });
            } else {
                this.removePanel();
            }
        }
    }

    private void removePanel() {
        if (this.hintPanel != null && this.hintLayer != null) {
            this.hintPanel.markForRemoval(new EndNotify(){

                @Override
                public void perform() {
                    if (Hint.this.hintLayer.getChildrenCount() <= 1) {
                        Hint.this.hintLayer.hide();
                    }
                }
            });
        }
    }

    private int getPosX(@Nonnull Element element, @Nonnull Element hintPanel, int screenWidth) {
        int pos = "center".equals(this.offsetX) ? element.getX() + element.getWidth() / 2 - hintPanel.getWidth() / 2 : ("left".equals(this.offsetX) ? element.getX() : ("right".equals(this.offsetX) ? element.getX() + element.getWidth() - hintPanel.getWidth() : Integer.valueOf(this.offsetX)));
        if (pos < 0) {
            pos = 0;
        }
        if (pos + hintPanel.getWidth() > screenWidth) {
            pos = screenWidth - hintPanel.getWidth();
        }
        return pos;
    }

    private int getPosY(@Nonnull Element element, @Nonnull Element hintPanel, int screenHeight) {
        int pos = "center".equals(this.offsetY) ? element.getY() + element.getHeight() / 2 - hintPanel.getHeight() / 2 : ("top".equals(this.offsetY) ? element.getY() : ("bottom".equals(this.offsetY) ? element.getY() + element.getHeight() - hintPanel.getHeight() : Integer.valueOf(this.offsetY)));
        if (pos < 0) {
            pos = 0;
        }
        if (pos + hintPanel.getHeight() > screenHeight) {
            pos = screenHeight - hintPanel.getHeight();
        }
        return pos;
    }
}

