/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyMouse;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FollowMouse
implements EffectImpl {
    @Nonnull
    private static final Logger log = Logger.getLogger(FollowMouse.class.getName());
    @Nullable
    private Nifty nifty;
    private int offsetX;
    private int offsetY;

    @Override
    public void activate(@Nonnull Nifty nifty, @Nonnull Element element, @Nonnull EffectProperties parameter) {
        this.nifty = nifty;
        this.offsetX = Integer.valueOf(parameter.getProperty("offsetX", "20"));
        this.offsetY = Integer.valueOf(parameter.getProperty("offsetY", "20"));
    }

    @Override
    public void execute(@Nonnull Element element, float normalizedTime, @Nullable Falloff falloff, @Nonnull NiftyRenderEngine r) {
        if (this.nifty == null) {
            log.warning("FadeMusic effect is executed before it was activated.");
            return;
        }
        NiftyMouse niftyMouse = this.nifty.getNiftyMouse();
        int newPosX = this.borderCheck(niftyMouse.getX() + this.offsetX, element.getWidth(), r.getWidth());
        element.setConstraintX(SizeValue.px(newPosX));
        int newPosY = this.borderCheck(niftyMouse.getY() + this.offsetY, element.getHeight(), r.getHeight());
        element.setConstraintY(SizeValue.px(newPosY));
        element.getParent().layoutElements();
    }

    private int borderCheck(int pos, int size, int max) {
        if (pos + size > max) {
            return max - size;
        }
        return pos;
    }

    @Override
    public void deactivate() {
    }
}

