/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.spi.sound.SoundHandle;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FadeMusic
implements EffectImpl {
    @Nonnull
    private static final Logger log = Logger.getLogger(FadeMusic.class.getName());
    @Nullable
    private Nifty nifty;
    private float fromVolume;
    private float toVolume;
    @Nullable
    private SoundHandle music;

    @Override
    public void activate(@Nonnull Nifty niftyParam, @Nonnull Element element, @Nonnull EffectProperties parameter) {
        this.nifty = niftyParam;
        this.music = this.nifty.getSoundSystem().getMusic(parameter.getProperty("sound"));
        if (this.music == null) {
            log.warning("Failed to get music for effect.");
        } else {
            this.fromVolume = new SizeValue(parameter.getProperty("from", "0%")).getValue(1.0f);
            this.toVolume = new SizeValue(parameter.getProperty("to", "100%")).getValue(1.0f);
        }
    }

    @Override
    public void execute(@Nonnull Element element, float normalizedTime, @Nullable Falloff falloff, @Nonnull NiftyRenderEngine r) {
        if (this.nifty == null) {
            log.warning("FadeMusic effect is executed before it was activated.");
            return;
        }
        if (this.music != null) {
            float volume = normalizedTime * (this.toVolume - this.fromVolume) + this.fromVolume;
            this.music.setVolume(volume);
            this.nifty.getSoundSystem().setMusicVolume(volume);
        }
    }

    @Override
    public void deactivate() {
    }
}

