/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.ImageRenderer;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.render.image.ImageMode;
import de.lessvoid.nifty.render.image.ImageModeFactory;
import de.lessvoid.nifty.render.image.ImageModeHelper;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChangeImage
implements EffectImpl {
    @Nonnull
    private static final Logger log = Logger.getLogger(ChangeImage.class.getName());
    @Nonnull
    private Element element;
    @Nullable
    private NiftyImage activeImage;
    @Nullable
    private NiftyImage inactiveImage;

    @Override
    public void activate(@Nonnull Nifty nifty, @Nonnull Element element, @Nonnull EffectProperties parameter) {
        this.element = element;
        this.activeImage = this.loadImage("active", nifty, parameter);
        this.inactiveImage = this.loadImage("inactive", nifty, parameter);
    }

    @Override
    public void execute(@Nonnull Element element, float normalizedTime, @Nullable Falloff falloff, @Nonnull NiftyRenderEngine r) {
        this.changeElementImage(this.activeImage);
    }

    @Override
    public void deactivate() {
        this.changeElementImage(this.inactiveImage);
        if (this.activeImage != null) {
            this.activeImage.dispose();
        }
        if (this.inactiveImage != null) {
            this.inactiveImage.dispose();
        }
    }

    @Nullable
    private NiftyImage loadImage(@Nonnull String name, @Nonnull Nifty nifty, @Nonnull EffectProperties parameter) {
        NiftyImage image = this.createImage(name, nifty, parameter);
        if (image == null) {
            return null;
        }
        this.setImageMode(image, name, parameter);
        return image;
    }

    @Nullable
    private NiftyImage createImage(@Nonnull String name, @Nonnull Nifty nifty, @Nonnull EffectProperties parameter) {
        return nifty.createImage(parameter.getProperty(name), false);
    }

    private void setImageMode(@Nonnull NiftyImage image, @Nonnull String name, @Nonnull EffectProperties parameter) {
        String areaProviderProperty = this.getAreaProviderProperty(name, parameter);
        String renderStrategyProperty = this.getRenderStrategyProperty(name, parameter);
        if (areaProviderProperty != null || renderStrategyProperty != null) {
            image.setImageMode(this.createImageMode(areaProviderProperty, renderStrategyProperty));
        }
    }

    @Nullable
    private String getAreaProviderProperty(@Nonnull String name, @Nonnull EffectProperties parameter) {
        return ImageModeHelper.getAreaProviderProperty(this.getImageModeProperty(name, parameter));
    }

    @Nullable
    private String getRenderStrategyProperty(@Nonnull String name, @Nonnull EffectProperties parameter) {
        return ImageModeHelper.getRenderStrategyProperty(this.getImageModeProperty(name, parameter));
    }

    @Nullable
    private String getImageModeProperty(@Nonnull String name, @Nonnull EffectProperties parameter) {
        String imageModeProperty = null;
        if ("active".equals(name)) {
            imageModeProperty = parameter.getProperty("imageModeActive", null);
        } else if ("inactive".equals(name)) {
            imageModeProperty = parameter.getProperty("imageModeInactive", null);
        }
        if (imageModeProperty == null) {
            imageModeProperty = parameter.getProperty("imageMode", null);
        }
        return imageModeProperty;
    }

    @Nonnull
    private ImageMode createImageMode(@Nullable String areaProviderProperty, @Nullable String renderStrategyProperty) {
        return ImageModeFactory.getSharedInstance().createImageMode(areaProviderProperty, renderStrategyProperty);
    }

    private void changeElementImage(@Nullable NiftyImage image) {
        ImageRenderer imageRenderer = this.element.getRenderer(ImageRenderer.class);
        if (imageRenderer == null) {
            log.warning("this effect can only be applied to images!");
            return;
        }
        imageRenderer.setImage(image);
    }
}

