/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects;

import de.lessvoid.nifty.effects.Effect;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class ActiveEffects {
    @Nonnull
    private final List<Effect> all = new ArrayList<Effect>();
    @Nonnull
    private final List<Effect> post = new ArrayList<Effect>();
    @Nonnull
    private final List<Effect> pre = new ArrayList<Effect>();
    @Nonnull
    private final List<Effect> overlay = new ArrayList<Effect>();

    public void clear() {
        this.all.clear();
        this.post.clear();
        this.pre.clear();
        this.overlay.clear();
    }

    public void add(@Nonnull Effect e) {
        this.all.add(e);
        if (e.isOverlay()) {
            this.overlay.add(e);
        } else if (e.isPost()) {
            this.post.add(e);
        } else {
            this.pre.add(e);
        }
    }

    public void remove(Effect e) {
        this.all.remove(e);
        this.post.remove(e);
        this.pre.remove(e);
        this.overlay.remove(e);
    }

    public boolean isEmpty() {
        return this.all.isEmpty();
    }

    public boolean contains(Effect e) {
        return this.all.contains(e);
    }

    public int size() {
        return this.all.size();
    }

    public boolean containsActiveEffects() {
        for (int i = 0; i < this.all.size(); ++i) {
            Effect e = this.all.get(i);
            if (!e.isActive()) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public List<Effect> getActive() {
        return this.all;
    }

    @Nonnull
    public List<Effect> getActivePost() {
        return this.post;
    }

    @Nonnull
    public List<Effect> getActivePre() {
        return this.pre;
    }

    @Nonnull
    public List<Effect> getActiveOverlay() {
        return this.overlay;
    }
}

