/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.dynamic.attributes;

import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectAttributes;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectOnHoverAttributes;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.loaderv2.types.EffectsType;
import de.lessvoid.nifty.tools.EnumStorage;
import de.lessvoid.nifty.tools.factories.CollectionFactory;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Collection;
import javax.annotation.Nonnull;

public class ControlEffectsAttributes {
    @Nonnull
    private final Attributes attributes;
    @Nonnull
    private final EnumStorage<EffectEventId, Collection<ControlEffectAttributes>> effectAttributes;

    public ControlEffectsAttributes() {
        this.attributes = new Attributes();
        this.effectAttributes = new EnumStorage(EffectEventId.class, CollectionFactory.getArrayListInstance());
    }

    public ControlEffectsAttributes(@Nonnull EffectsType source) {
        this.attributes = new Attributes(source.getAttributes());
        this.effectAttributes = new EnumStorage(EffectEventId.class, CollectionFactory.getArrayListInstance());
        for (EffectEventId id : EffectEventId.values()) {
            if (!source.hasEffectTypes(id)) continue;
            source.convertCopy(id, this.effectAttributes.get(id));
        }
    }

    @Nonnull
    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttribute(@Nonnull String name, @Nonnull String value) {
        this.attributes.set(name, value);
    }

    public void setOverlay(@Nonnull String overlay) {
        this.attributes.set("overlay", overlay);
    }

    public void addEffectAttribute(@Nonnull EffectEventId id, @Nonnull ControlEffectAttributes attribute) {
        this.effectAttributes.get(id).add(attribute);
    }

    public void addOnStartScreen(@Nonnull ControlEffectAttributes effectParam) {
        this.addEffectAttribute(EffectEventId.onStartScreen, effectParam);
    }

    public void addOnEndScreen(@Nonnull ControlEffectAttributes effectParam) {
        this.addEffectAttribute(EffectEventId.onEndScreen, effectParam);
    }

    public void addOnHover(@Nonnull ControlEffectOnHoverAttributes effectParam) {
        this.addEffectAttribute(EffectEventId.onHover, effectParam);
    }

    public void addOnStartHover(@Nonnull ControlEffectOnHoverAttributes effectParam) {
        this.addEffectAttribute(EffectEventId.onStartHover, effectParam);
    }

    public void addOnEndHover(@Nonnull ControlEffectOnHoverAttributes effectParam) {
        this.addEffectAttribute(EffectEventId.onEndHover, effectParam);
    }

    public void addOnClick(@Nonnull ControlEffectAttributes effectParam) {
        this.addEffectAttribute(EffectEventId.onClick, effectParam);
    }

    public void addOnFocus(@Nonnull ControlEffectAttributes effectParam) {
        this.addEffectAttribute(EffectEventId.onFocus, effectParam);
    }

    public void addOnLostFocus(@Nonnull ControlEffectAttributes effectParam) {
        this.addEffectAttribute(EffectEventId.onLostFocus, effectParam);
    }

    public void addOnGetFocus(@Nonnull ControlEffectAttributes effectParam) {
        this.addEffectAttribute(EffectEventId.onGetFocus, effectParam);
    }

    public void addOnActive(@Nonnull ControlEffectAttributes effectParam) {
        this.addEffectAttribute(EffectEventId.onActive, effectParam);
    }

    public void addOnShow(@Nonnull ControlEffectAttributes effectParam) {
        this.addEffectAttribute(EffectEventId.onShow, effectParam);
    }

    public void addOnHide(@Nonnull ControlEffectAttributes effectParam) {
        this.addEffectAttribute(EffectEventId.onHide, effectParam);
    }

    public void addOnCustom(@Nonnull ControlEffectAttributes effectParam) {
        this.addEffectAttribute(EffectEventId.onCustom, effectParam);
    }

    @Nonnull
    public EffectsType create() {
        EffectsType effectsType = new EffectsType(this.attributes);
        for (EffectEventId id : EffectEventId.values()) {
            if (!this.effectAttributes.isSet(id)) continue;
            for (ControlEffectAttributes effectParam : this.effectAttributes.get(id)) {
                effectsType.addEventEffect(id, effectParam.create());
            }
        }
        return effectsType;
    }

    public void refreshEffectsType(@Nonnull EffectsType effectsType) {
        effectsType.getAttributes().refreshFromAttributes(this.getAttributes());
    }
}

