/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls;

import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.FocusGainedEvent;
import de.lessvoid.nifty.controls.FocusLostEvent;
import de.lessvoid.nifty.controls.NiftyControl;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractController
implements Controller,
NiftyControl {
    private static final Logger log = Logger.getLogger(AbstractController.class.getName());
    @Nullable
    private Element element;
    private boolean bound = false;

    protected void bind(@Nonnull Element element) {
        this.element = element;
    }

    @Override
    public void init(@Nonnull Parameters parameter) {
        this.bound = true;
    }

    @Override
    @Nullable
    public Element getElement() {
        if (this.element == null) {
            log.warning("Requested element from controller before binding was performed.");
        }
        return this.element;
    }

    @Override
    public void enable() {
        this.setEnabled(true);
    }

    @Override
    public void disable() {
        this.setEnabled(false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        Element element = this.getElement();
        if (element != null) {
            if (enabled) {
                element.enable();
            } else {
                element.disable();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        Element element = this.getElement();
        return element != null && element.isEnabled();
    }

    @Override
    @Nullable
    public String getId() {
        Element element = this.getElement();
        return element != null ? element.getId() : null;
    }

    @Override
    public void setId(@Nullable String id) {
        Element element = this.getElement();
        if (element != null) {
            element.setId(id);
        }
    }

    @Override
    public int getWidth() {
        Element element = this.getElement();
        return element != null ? element.getWidth() : 0;
    }

    @Override
    public void setWidth(@Nonnull SizeValue width) {
        Element element = this.getElement();
        if (element != null) {
            element.setConstraintWidth(width);
        }
    }

    @Override
    public int getHeight() {
        Element element = this.getElement();
        return element != null ? element.getHeight() : 0;
    }

    @Override
    public void setHeight(@Nonnull SizeValue height) {
        Element element = this.getElement();
        if (element != null) {
            element.setConstraintHeight(height);
        }
    }

    @Override
    public String getStyle() {
        Element element = this.getElement();
        return element != null ? element.getStyle() : null;
    }

    @Override
    public void setStyle(@Nonnull String style) {
        Element element = this.getElement();
        if (element != null) {
            element.setStyle(element.getNifty().specialValuesReplace(style));
        }
    }

    @Override
    public void setFocus() {
        Element element = this.getElement();
        if (element != null) {
            element.setFocus();
        }
    }

    @Override
    public void setFocusable(boolean focusable) {
        Element element = this.getElement();
        if (element != null) {
            element.setFocusable(focusable);
        }
    }

    @Override
    public void onFocus(boolean getFocus) {
        String id;
        Element element = this.getElement();
        if (element != null && (id = element.getId()) != null) {
            if (getFocus) {
                element.getNifty().publishEvent(id, new FocusGainedEvent(this, this));
            } else {
                element.getNifty().publishEvent(id, new FocusLostEvent(this, this));
            }
        }
    }

    @Override
    public boolean hasFocus() {
        Element element = this.getElement();
        if (element == null) {
            return false;
        }
        return element == element.getFocusHandler().getKeyboardFocusElement();
    }

    @Override
    public void layoutCallback() {
    }

    @Override
    public boolean isBound() {
        return this.bound;
    }

    @Override
    public void onEndScreen() {
    }
}

