/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.builder;

import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectAttributes;
import de.lessvoid.nifty.loaderv2.types.EffectValueType;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class EffectBuilder {
    private static final Logger logger = Logger.getLogger(EffectBuilder.class.getName());
    @Nonnull
    protected final ControlEffectAttributes attributes;

    public EffectBuilder(@Nonnull ControlEffectAttributes attributes, @Nonnull String effectName) {
        this.attributes = attributes;
        attributes.setName(effectName);
    }

    public EffectBuilder(@Nonnull String effectName) {
        this(new ControlEffectAttributes(), effectName);
    }

    @Nonnull
    public EffectBuilder inherit(boolean inherit) {
        this.attributes.setInherit(String.valueOf(inherit));
        return this;
    }

    @Nonnull
    public EffectBuilder inherit() {
        this.attributes.setInherit("true");
        return this;
    }

    @Nonnull
    public EffectBuilder post(boolean post) {
        this.attributes.setPost(String.valueOf(post));
        return this;
    }

    @Nonnull
    public EffectBuilder overlay(boolean overlay) {
        this.attributes.setOverlay(String.valueOf(overlay));
        return this;
    }

    @Nonnull
    public EffectBuilder alternateEnable(@Nonnull String alternateEnable) {
        this.attributes.setAlternateEnable(alternateEnable);
        return this;
    }

    @Nonnull
    public EffectBuilder alternateDisable(@Nonnull String alternateDisable) {
        this.attributes.setAlternateDisable(alternateDisable);
        return this;
    }

    @Nonnull
    public EffectBuilder customKey(@Nonnull String customKey) {
        this.attributes.setCustomKey(customKey);
        return this;
    }

    @Nonnull
    public EffectBuilder neverStopRendering(boolean neverStopRendering) {
        this.attributes.setNeverStopRendering(String.valueOf(neverStopRendering));
        return this;
    }

    @Nonnull
    public EffectBuilder effectParameter(@Nonnull String key, @Nonnull String value) {
        this.attributes.setAttribute(key, value);
        return this;
    }

    @Nonnull
    public EffectBuilder startDelay(int ms) {
        this.attributes.setStartDelay(String.valueOf(ms));
        return this;
    }

    @Nonnull
    public EffectBuilder length(int ms) {
        this.attributes.setLength(String.valueOf(ms));
        return this;
    }

    @Nonnull
    public EffectBuilder oneShot(boolean oneShot) {
        this.attributes.setOneShot(String.valueOf(oneShot));
        return this;
    }

    @Nonnull
    public EffectBuilder timeType(@Nonnull String timeType) {
        this.attributes.setTimeType(timeType);
        return this;
    }

    @Nonnull
    public EffectBuilder onStartEffectCallback(@Nonnull String callback) {
        this.attributes.setOnStartEffectCallback(callback);
        return this;
    }

    @Nonnull
    public EffectBuilder onEndEffectCallback(@Nonnull String callback) {
        this.attributes.setOnEndEffectCallback(callback);
        return this;
    }

    @Nonnull
    public ControlEffectAttributes getAttributes() {
        return this.attributes;
    }

    @Nonnull
    public EffectBuilder effectValue(String ... values) {
        if (values == null || values.length % 2 != 0) {
            logger.warning("effect values must be given in pairs, example: effectValue(\"color\", \"#f00f\")");
            return this;
        }
        EffectValueType effectValue = new EffectValueType();
        for (int i = 0; i < values.length / 2; ++i) {
            String key = values[i * 2];
            String value = values[i * 2 + 1];
            effectValue.getAttributes().set(key, value);
        }
        this.attributes.addEffectValues(effectValue);
        return this;
    }
}

