/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty;

import de.lessvoid.nifty.spi.time.TimeProvider;
import de.lessvoid.nifty.spi.time.impl.AccurateTimeProvider;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class NiftyStopwatch {
    @Nonnull
    private static final Logger log = Logger.getLogger(NiftyStopwatch.class.getName());
    @Nonnull
    private static final Level usedLogLevel = Level.FINE;
    @Nonnull
    private static final Queue<Long> stack = Collections.asLifoQueue(new LinkedList());
    @Nonnull
    private static TimeProvider timeProvider = new AccurateTimeProvider();

    private NiftyStopwatch() {
    }

    public static void start() {
        stack.offer(NiftyStopwatch.now());
    }

    public static void stop(@Nonnull String message) {
        long length = NiftyStopwatch.stop();
        if (log.isLoggable(usedLogLevel)) {
            StringBuilder b = new StringBuilder();
            b.append("[").append(String.format("%04d", length)).append("] ");
            for (int i = 0; i < stack.size(); ++i) {
                b.append(".");
            }
            b.append(' ').append(message);
            log.log(usedLogLevel, b.toString());
        }
    }

    public static long stop() {
        return NiftyStopwatch.now() - stack.poll();
    }

    private static long now() {
        return timeProvider.getMsTime();
    }
}

