/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.healthimage;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.controls.SliderChangedEvent;
import de.lessvoid.nifty.elements.render.ImageRenderer;
import de.lessvoid.nifty.examples.NiftyExample;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.render.image.ImageModeFactory;
import de.lessvoid.nifty.render.image.ImageModeHelper;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import javax.annotation.Nonnull;

public class HealthImageScreen
implements ScreenController,
NiftyExample {
    private Nifty nifty;
    private NiftyImage healthImage;

    public void bind(@Nonnull Nifty newNifty, @Nonnull Screen newScreen) {
        this.nifty = newNifty;
        this.healthImage = ((ImageRenderer)newScreen.findElementById("health").getRenderer(ImageRenderer.class)).getImage();
    }

    public void onStartScreen() {
    }

    public void onEndScreen() {
    }

    @Override
    @Nonnull
    public String getStartScreen() {
        return "start";
    }

    @Override
    @Nonnull
    public String getMainXML() {
        return "healthimage/healthimage.xml";
    }

    @Override
    @Nonnull
    public String getTitle() {
        return "Nifty Health Image Example";
    }

    @Override
    public void prepareStart(@Nonnull Nifty nifty) {
    }

    @NiftyEventSubscriber(id="value")
    public void valueChanged(String id, SliderChangedEvent event) {
        int value = (int)event.getValue();
        String parameter = "subImageDirect:0," + (150 - value) + ",150," + value;
        String areaProviderProperty = ImageModeHelper.getAreaProviderProperty((String)parameter);
        String renderStrategyProperty = ImageModeHelper.getRenderStrategyProperty((String)parameter);
        this.healthImage.setImageMode(ImageModeFactory.getSharedInstance().createImageMode(areaProviderProperty, renderStrategyProperty));
    }
}

