/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.defaultcontrols.tabs;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.builder.ControlBuilder;
import de.lessvoid.nifty.controls.CheckBox;
import de.lessvoid.nifty.controls.CheckBoxStateChangedEvent;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.TabGroup;
import de.lessvoid.nifty.controls.checkbox.builder.CheckboxBuilder;
import de.lessvoid.nifty.controls.label.builder.LabelBuilder;
import de.lessvoid.nifty.controls.tabs.builder.TabBuilder;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.events.NiftyMousePrimaryClickedEvent;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import javax.annotation.Nonnull;

public class TabsControlDialogController
implements Controller {
    private Screen screen;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters parameter) {
        this.screen = screen;
        TabGroup tabs = (TabGroup)screen.findNiftyControl("tabs", TabGroup.class);
        tabs.addTab(new TabBuilder("tab_1", "Tab 1"){
            {
                this.childLayoutVertical();
                this.height("100%");
                this.width("100%");
                this.control((ControlBuilder)new LabelBuilder("tab1_label", "Tab 1"){
                    {
                        this.height("50%");
                        this.width("100%");
                    }
                });
                this.control((ControlBuilder)new LabelBuilder("tab1_label_checkboxstate", "Checkbox state: ---"){
                    {
                        this.height("50%");
                        this.width("100%");
                        this.visibleToMouse();
                    }
                });
            }
        });
        tabs.addTab(new TabBuilder("tab_2", "Tab 2"){
            {
                this.childLayoutCenter();
                this.control((ControlBuilder)new CheckboxBuilder("tab_2_checkbox"){});
                this.height("100%");
                this.width("100%");
            }
        });
    }

    public void init(@Nonnull Parameters parameter) {
    }

    public void onStartScreen() {
        this.displayCheckBoxState((CheckBox)this.screen.findNiftyControl("tab_2_checkbox", CheckBox.class));
    }

    public void onFocus(boolean getFocus) {
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return false;
    }

    public void onEndScreen() {
    }

    @NiftyEventSubscriber(id="tab1_label_checkboxstate")
    public void onLabelClick(String id, NiftyMousePrimaryClickedEvent label) {
        CheckBox checkBox = (CheckBox)this.screen.findNiftyControl("tab_2_checkbox", CheckBox.class);
        checkBox.toggle();
        this.displayCheckBoxState(checkBox);
    }

    @NiftyEventSubscriber(id="tab_2_checkbox")
    public void checkBoxStateChange(String id, @Nonnull CheckBoxStateChangedEvent stateChanged) {
        this.displayCheckBoxState(stateChanged.getCheckBox());
    }

    private void displayCheckBoxState(@Nonnull CheckBox checkBox) {
        ((TextRenderer)this.screen.findElementById("tab1_label_checkboxstate").getRenderer(TextRenderer.class)).setText("Checkbox state (on Tab 2)\nisChecked(): " + checkBox.isChecked() + "\n\n(click me!)");
    }
}

