/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.defaultcontrols.eventconsume;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.NiftyInputConsumerNotify;
import de.lessvoid.nifty.controls.ButtonClickedEvent;
import de.lessvoid.nifty.controls.CheckBox;
import de.lessvoid.nifty.controls.CheckBoxStateChangedEvent;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.DropDown;
import de.lessvoid.nifty.controls.DropDownSelectionChangedEvent;
import de.lessvoid.nifty.controls.Label;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.keyboard.KeyboardInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EventConsumeDialogController
implements Controller {
    private Screen screen;
    @Nullable
    private Label mouseXText;
    @Nullable
    private Label mouseYText;
    @Nullable
    private Label mouseWheelText;
    @Nullable
    private Label mouseButtonText;
    @Nullable
    private Label mouseDownText;
    @Nullable
    private Label mouseProcessedText;
    @Nullable
    private DropDown<ElementInfo> eventConsumeElementDropDown;
    @Nullable
    private CheckBox eventConsumeIgnoreMouseEventsCheckBox;
    @Nullable
    private CheckBox eventConsumeIgnoreKeyboardEventsCheckBox;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, final @Nonnull Element element, @Nonnull Parameters parameter) {
        this.screen = screen;
        this.mouseXText = (Label)screen.findNiftyControl("mouseXText", Label.class);
        this.mouseYText = (Label)screen.findNiftyControl("mouseYText", Label.class);
        this.mouseWheelText = (Label)screen.findNiftyControl("mouseWheelText", Label.class);
        this.mouseButtonText = (Label)screen.findNiftyControl("mouseButtonText", Label.class);
        this.mouseDownText = (Label)screen.findNiftyControl("mouseDownText", Label.class);
        this.mouseProcessedText = (Label)screen.findNiftyControl("mouseProcessedText", Label.class);
        this.eventConsumeElementDropDown = (DropDown)screen.findNiftyControl("eventConsumeElementDropDown", DropDown.class);
        this.eventConsumeIgnoreMouseEventsCheckBox = (CheckBox)screen.findNiftyControl("eventConsumeIgnoreMouseEventsCheckBox", CheckBox.class);
        this.eventConsumeIgnoreKeyboardEventsCheckBox = (CheckBox)screen.findNiftyControl("eventConsumeIgnoreKeyboardEventsCheckBox", CheckBox.class);
        nifty.setNiftyInputConsumerNotify(new NiftyInputConsumerNotify(){

            public void processedMouseEvent(int mouseX, int mouseY, int mouseWheel, int button, boolean buttonDown, boolean processed) {
                if (!element.isVisible()) {
                    return;
                }
                EventConsumeDialogController.this.mouseXText.setText(String.valueOf(mouseX));
                EventConsumeDialogController.this.mouseYText.setText(String.valueOf(mouseY));
                EventConsumeDialogController.this.mouseWheelText.setText(String.valueOf(mouseWheel));
                EventConsumeDialogController.this.mouseButtonText.setText(String.valueOf(button));
                EventConsumeDialogController.this.mouseDownText.setText(String.valueOf(buttonDown));
                EventConsumeDialogController.this.mouseProcessedText.setText(String.valueOf(processed));
                if (processed) {
                    EventConsumeDialogController.this.mouseProcessedText.setColor(new Color("#5f5f"));
                } else {
                    EventConsumeDialogController.this.mouseProcessedText.setColor(new Color("#f55f"));
                }
            }

            public void processKeyboardEvent(KeyboardInputEvent keyEvent, boolean processed) {
            }
        });
    }

    public void init(@Nonnull Parameters parameter) {
        this.eventConsumeElementDropDown.addItem((Object)new ElementInfo(this.screen.findElementById("eventConsumeLeftPanel"), "Green Panel"));
        this.eventConsumeElementDropDown.addItem((Object)new ElementInfo(this.screen.findElementById("eventConsumeLeftButton"), "Test Left Button"));
        this.eventConsumeElementDropDown.addItem((Object)new ElementInfo(this.screen.findElementById("eventConsumeRightPanel"), "Red Panel"));
        this.eventConsumeElementDropDown.addItem((Object)new ElementInfo(this.screen.findElementById("eventConsumeRightButton"), "Test Right Button"));
    }

    public void onStartScreen() {
    }

    public void onFocus(boolean getFocus) {
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return false;
    }

    public void onEndScreen() {
    }

    @NiftyEventSubscriber(id="eventConsumeElementDropDown")
    public void eventConsumeElementDropDownChanged(String id, @Nonnull DropDownSelectionChangedEvent<ElementInfo> e) {
        this.eventConsumeIgnoreMouseEventsCheckBox.setChecked(((ElementInfo)e.getSelection()).getElement().isIgnoreMouseEvents());
        this.eventConsumeIgnoreKeyboardEventsCheckBox.setChecked(((ElementInfo)e.getSelection()).getElement().isIgnoreKeyboardEvents());
    }

    @NiftyEventSubscriber(id="eventConsumeIgnoreMouseEventsCheckBox")
    public void eventConsumeIgnoreMouseEventsCheckBoxToggle(String id, @Nonnull CheckBoxStateChangedEvent e) {
        ((ElementInfo)this.eventConsumeElementDropDown.getSelection()).getElement().setIgnoreMouseEvents(e.isChecked());
    }

    @NiftyEventSubscriber(id="eventConsumeIgnoreKeyboardEventsCheckBox")
    public void eventConsumeIgnoreKeyboardEventsCheckBoxToggle(String id, @Nonnull CheckBoxStateChangedEvent e) {
        ((ElementInfo)this.eventConsumeElementDropDown.getSelection()).getElement().setIgnoreKeyboardEvents(e.isChecked());
    }

    @NiftyEventSubscriber(pattern="eventConsume.*Button")
    public void onButtonClick(String id, @Nonnull ButtonClickedEvent e) {
        ((Label)this.screen.findNiftyControl("eventConsumeButtonOut", Label.class)).setText(e.getButton().getText() + " pressed");
    }

    private static class ElementInfo {
        private final Element element;
        private final String caption;

        public ElementInfo(Element element, String caption) {
            this.element = element;
            this.caption = caption;
        }

        public Element getElement() {
            return this.element;
        }

        public String toString() {
            return this.caption;
        }
    }
}

