/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.defaultcontrols.dragndrop;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.builder.ControlBuilder;
import de.lessvoid.nifty.builder.ControlDefinitionBuilder;
import de.lessvoid.nifty.builder.EffectBuilder;
import de.lessvoid.nifty.builder.ImageBuilder;
import de.lessvoid.nifty.builder.PanelBuilder;
import de.lessvoid.nifty.builder.TextBuilder;
import de.lessvoid.nifty.controls.button.builder.ButtonBuilder;
import de.lessvoid.nifty.controls.dragndrop.builder.DraggableBuilder;
import de.lessvoid.nifty.controls.dragndrop.builder.DroppableBuilder;
import de.lessvoid.nifty.controls.label.builder.LabelBuilder;
import de.lessvoid.nifty.examples.defaultcontrols.common.CommonBuilders;
import de.lessvoid.nifty.examples.defaultcontrols.dragndrop.DragAndDropDialogController;
import javax.annotation.Nonnull;

public class DragAndDropDialogDefinition {
    @Nonnull
    public static final String NAME = "dragAndDropDialog";
    @Nonnull
    private static final CommonBuilders builders = new CommonBuilders();

    public static void register(@Nonnull Nifty nifty) {
        new ControlDefinitionBuilder(NAME){
            {
                this.controller(new DragAndDropDialogController());
                this.control(new ControlBuilder("dialogPanel"){
                    {
                        this.control((ControlBuilder)new LabelBuilder("dragAndDropDescription", "Drop the Key on the Chest to open it."){
                            {
                                this.width("100%");
                                this.textHAlignCenter();
                            }
                        });
                        this.panel(new PanelBuilder(){
                            {
                                this.childLayoutHorizontal();
                                this.control((ControlBuilder)new DroppableBuilder("chest"){
                                    {
                                        this.width("101px");
                                        this.height("171px");
                                        this.panel(new PanelBuilder(){
                                            {
                                                this.childLayoutOverlay();
                                                this.image(new ImageBuilder("chest-image"){
                                                    {
                                                        this.filename("defaultcontrols/dragndrop/Chest Open.png");
                                                    }
                                                });
                                                this.image(new ImageBuilder("chest-open"){
                                                    {
                                                        this.filename("defaultcontrols/dragndrop/Chest Lid.png");
                                                        this.onCustomEffect(new EffectBuilder("move"){
                                                            {
                                                                this.effectParameter("mode", "toOffset");
                                                                this.effectParameter("offsetY", "-100");
                                                                this.length(250);
                                                                this.customKey("switchOpen");
                                                                this.neverStopRendering(true);
                                                            }
                                                        });
                                                        this.onCustomEffect(new EffectBuilder("fade"){
                                                            {
                                                                this.effectParameter("start", "#f");
                                                                this.effectParameter("end", "#0");
                                                                this.length(250);
                                                                this.customKey("switchOpen");
                                                                this.neverStopRendering(true);
                                                            }
                                                        });
                                                    }
                                                });
                                            }
                                        });
                                    }
                                });
                                this.panel(new PanelBuilder(){
                                    {
                                        this.width("*");
                                    }
                                });
                                this.control((ControlBuilder)new DroppableBuilder("key-initial"){
                                    {
                                        this.width("101px");
                                        this.height("171px");
                                        this.onActiveEffect(new EffectBuilder("border"){
                                            {
                                                this.effectParameter("color", "#0003");
                                            }
                                        });
                                        this.control((ControlBuilder)new DraggableBuilder("key"){
                                            {
                                                this.childLayoutCenter();
                                                this.image(new ImageBuilder(){
                                                    {
                                                        this.filename("defaultcontrols/dragndrop/Key.png");
                                                    }
                                                });
                                            }
                                        });
                                    }
                                });
                            }
                        });
                        this.panel(new PanelBuilder(){
                            {
                                this.width("100%");
                                this.childLayoutVertical();
                                this.text(new TextBuilder(){
                                    {
                                        this.style("base-font-link");
                                        this.text("\"Danc's Miraculously Flexible Game Prototyping Tiles\"");
                                        this.set("action", "openLink(http://www.lostgarden.com/2007/05/dancs-miraculously-flexible-game.html)");
                                        this.textHAlignRight();
                                        this.alignRight();
                                    }
                                });
                            }
                        });
                        this.panel(new PanelBuilder(){
                            {
                                this.width("100%");
                                this.childLayoutVertical();
                                this.text(new TextBuilder(){
                                    {
                                        this.style("base-font");
                                        this.text("art by Daniel Cook (Lostgarden.com)");
                                        this.textHAlignRight();
                                        this.alignRight();
                                    }
                                });
                            }
                        });
                        this.panel(builders.vspacer());
                        this.panel(builders.vspacer());
                        this.panel(new PanelBuilder(){
                            {
                                this.width("100%");
                                this.childLayoutVertical();
                                this.control((ControlBuilder)new ButtonBuilder("resetButton", "Reset"){
                                    {
                                        this.alignCenter();
                                    }
                                });
                            }
                        });
                    }
                });
            }
        }.registerControlDefintion(nifty);
    }
}

