/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.defaultcontrols;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.builder.ControlBuilder;
import de.lessvoid.nifty.builder.EffectBuilder;
import de.lessvoid.nifty.builder.HoverEffectBuilder;
import de.lessvoid.nifty.builder.ImageBuilder;
import de.lessvoid.nifty.builder.LayerBuilder;
import de.lessvoid.nifty.builder.PanelBuilder;
import de.lessvoid.nifty.builder.PopupBuilder;
import de.lessvoid.nifty.builder.ScreenBuilder;
import de.lessvoid.nifty.builder.StyleBuilder;
import de.lessvoid.nifty.builder.TextBuilder;
import de.lessvoid.nifty.controls.button.builder.ButtonBuilder;
import de.lessvoid.nifty.controls.console.builder.ConsoleBuilder;
import de.lessvoid.nifty.controls.dropdown.builder.DropDownBuilder;
import de.lessvoid.nifty.controls.label.builder.LabelBuilder;
import de.lessvoid.nifty.controls.slider.builder.SliderBuilder;
import de.lessvoid.nifty.examples.NiftyExample;
import de.lessvoid.nifty.examples.defaultcontrols.ControlsDemoScreenController;
import de.lessvoid.nifty.examples.defaultcontrols.chatcontrol.ChatControlDialogDefinition;
import de.lessvoid.nifty.examples.defaultcontrols.common.CommonBuilders;
import de.lessvoid.nifty.examples.defaultcontrols.common.DialogPanelControlDefinition;
import de.lessvoid.nifty.examples.defaultcontrols.common.MenuButtonControlDefinition;
import de.lessvoid.nifty.examples.defaultcontrols.dragndrop.DragAndDropDialogDefinition;
import de.lessvoid.nifty.examples.defaultcontrols.dropdown.DropDownDialogControlDefinition;
import de.lessvoid.nifty.examples.defaultcontrols.eventconsume.EventConsumeDialogDefinition;
import de.lessvoid.nifty.examples.defaultcontrols.listbox.ListBoxDialogControlDefinition;
import de.lessvoid.nifty.examples.defaultcontrols.messagebox.MessageBoxDialogDefinition;
import de.lessvoid.nifty.examples.defaultcontrols.scrollpanel.ScrollPanelDialogControlDefinition;
import de.lessvoid.nifty.examples.defaultcontrols.sliderandscrollbar.SliderAndScrollbarDialogControlDefinition;
import de.lessvoid.nifty.examples.defaultcontrols.tabs.TabsControlDialogDefinition;
import de.lessvoid.nifty.examples.defaultcontrols.textfield.TextFieldDialogControlDefinition;
import de.lessvoid.nifty.examples.defaultcontrols.treebox.TreeBoxControlDialogDefinition;
import de.lessvoid.nifty.examples.resolution.ResolutionControl;
import de.lessvoid.nifty.screen.DefaultScreenController;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import de.lessvoid.nifty.tools.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ControlsDemo<T>
implements NiftyExample {
    @Nonnull
    private static final CommonBuilders builders = new CommonBuilders();
    private final ResolutionControl<T> resolutionControl;

    public ControlsDemo(ResolutionControl<T> resControl) {
        this.resolutionControl = resControl;
    }

    @Nonnull
    private static Screen createIntroScreen(@Nonnull Nifty nifty) {
        return new ScreenBuilder("start"){
            {
                this.controller((ScreenController)new DefaultScreenController(){

                    public void onStartScreen() {
                        this.nifty.gotoScreen("demo");
                    }
                });
                this.layer(new LayerBuilder("layer"){
                    {
                        this.childLayoutCenter();
                        this.onStartScreenEffect(new EffectBuilder("fade"){
                            {
                                this.length(3000);
                                this.effectParameter("start", "#0");
                                this.effectParameter("end", "#f");
                            }
                        });
                        this.onStartScreenEffect(new EffectBuilder("playSound"){
                            {
                                this.startDelay(1400);
                                this.effectParameter("sound", "intro");
                            }
                        });
                        this.onActiveEffect(new EffectBuilder("gradient"){
                            {
                                this.effectValue(new String[]{"offset", "0%", "color", "#66666fff"});
                                this.effectValue(new String[]{"offset", "85%", "color", "#000f"});
                                this.effectValue(new String[]{"offset", "100%", "color", "#44444fff"});
                            }
                        });
                        this.panel(new PanelBuilder(){
                            {
                                this.alignCenter();
                                this.valignCenter();
                                this.childLayoutHorizontal();
                                this.width("856px");
                                this.panel(new PanelBuilder(){
                                    {
                                        this.width("300px");
                                        this.height("256px");
                                        this.childLayoutCenter();
                                        this.text(new TextBuilder(){
                                            {
                                                this.text("Nifty 1.4 Core");
                                                this.style("base-font");
                                                this.alignCenter();
                                                this.valignCenter();
                                                this.onStartScreenEffect(new EffectBuilder("fade"){
                                                    {
                                                        this.length(1000);
                                                        this.effectValue(new String[]{"time", "1700", "value", "0.0"});
                                                        this.effectValue(new String[]{"time", "2000", "value", "1.0"});
                                                        this.effectValue(new String[]{"time", "2600", "value", "1.0"});
                                                        this.effectValue(new String[]{"time", "3200", "value", "0.0"});
                                                        this.post(false);
                                                        this.neverStopRendering(true);
                                                    }
                                                });
                                            }
                                        });
                                    }
                                });
                                this.panel(new PanelBuilder(){
                                    {
                                        this.alignCenter();
                                        this.valignCenter();
                                        this.childLayoutOverlay();
                                        this.width("256px");
                                        this.height("256px");
                                        this.onStartScreenEffect(new EffectBuilder("shake"){
                                            {
                                                this.length(250);
                                                this.startDelay(1300);
                                                this.inherit();
                                                this.effectParameter("global", "false");
                                                this.effectParameter("distance", "10.");
                                            }
                                        });
                                        this.onStartScreenEffect(new EffectBuilder("imageSize"){
                                            {
                                                this.length(600);
                                                this.startDelay(3000);
                                                this.effectParameter("startSize", "1.0");
                                                this.effectParameter("endSize", "2.0");
                                                this.inherit();
                                                this.neverStopRendering(true);
                                            }
                                        });
                                        this.onStartScreenEffect(new EffectBuilder("fade"){
                                            {
                                                this.length(600);
                                                this.startDelay(3000);
                                                this.effectParameter("start", "#f");
                                                this.effectParameter("end", "#0");
                                                this.inherit();
                                                this.neverStopRendering(true);
                                            }
                                        });
                                        this.image(new ImageBuilder(){
                                            {
                                                this.filename("defaultcontrols/yin.png");
                                                this.onStartScreenEffect(new EffectBuilder("move"){
                                                    {
                                                        this.length(1000);
                                                        this.startDelay(300);
                                                        this.timeType("exp");
                                                        this.effectParameter("factor", "6.f");
                                                        this.effectParameter("mode", "in");
                                                        this.effectParameter("direction", "left");
                                                    }
                                                });
                                            }
                                        });
                                        this.image(new ImageBuilder(){
                                            {
                                                this.filename("defaultcontrols/yang.png");
                                                this.onStartScreenEffect(new EffectBuilder("move"){
                                                    {
                                                        this.length(1000);
                                                        this.startDelay(300);
                                                        this.timeType("exp");
                                                        this.effectParameter("factor", "6.f");
                                                        this.effectParameter("mode", "in");
                                                        this.effectParameter("direction", "right");
                                                    }
                                                });
                                            }
                                        });
                                    }
                                });
                                this.panel(new PanelBuilder(){
                                    {
                                        this.width("300px");
                                        this.height("256px");
                                        this.childLayoutCenter();
                                        this.text(new TextBuilder(){
                                            {
                                                this.text("Nifty 1.4 Standard Controls");
                                                this.style("base-font");
                                                this.alignCenter();
                                                this.valignCenter();
                                                this.onStartScreenEffect(new EffectBuilder("fade"){
                                                    {
                                                        this.length(1000);
                                                        this.effectValue(new String[]{"time", "1700", "value", "0.0"});
                                                        this.effectValue(new String[]{"time", "2000", "value", "1.0"});
                                                        this.effectValue(new String[]{"time", "2600", "value", "1.0"});
                                                        this.effectValue(new String[]{"time", "3200", "value", "0.0"});
                                                        this.post(false);
                                                        this.neverStopRendering(true);
                                                    }
                                                });
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                });
                this.layer(new LayerBuilder(){
                    {
                        this.backgroundColor("#ddff");
                        this.onStartScreenEffect(new EffectBuilder("fade"){
                            {
                                this.length(1000);
                                this.startDelay(3000);
                                this.effectParameter("start", "#0");
                                this.effectParameter("end", "#f");
                            }
                        });
                    }
                });
            }
        }.build(nifty);
    }

    @Nonnull
    private static <T> Screen createDemoScreen(@Nonnull Nifty nifty, final ResolutionControl<T> resControl) {
        final CommonBuilders common = new CommonBuilders();
        return new ScreenBuilder("demo"){
            {
                super(arg0);
                this.controller(new ControlsDemoScreenController(resControl, "menuButtonListBox", "dialogListBox", "menuButtonDropDown", "dialogDropDown", "menuButtonTextField", "dialogTextField", "menuButtonSlider", "dialogSliderAndScrollbar", "menuButtonScrollPanel", "dialogScrollPanel", "menuButtonDragAndDrop", "dialogDragAndDrop", "menuButtonChatControl", "dialogChatControl", "menuButtonMessageBox", "dialogMessageBox", "menuButtonTabsControl", "dialogTabsControl", "menuButtonTreeBoxControl", "dialogTreeBoxControl", "menuButtonEventConsumeControl", "dialogEventConsumeControl"));
                this.inputMapping("de.lessvoid.nifty.input.mapping.DefaultInputMapping");
                this.layer(new LayerBuilder("layer"){
                    {
                        this.backgroundImage("defaultcontrols/background-new.png");
                        this.childLayoutVertical();
                        this.panel(new PanelBuilder("navigation-1"){
                            {
                                this.width("100%");
                                this.height("43px");
                                this.backgroundColor("#5588");
                                this.childLayoutHorizontal();
                                this.paddingLeft("20px");
                                this.paddingRight("20px");
                                this.paddingTop("10px");
                                this.paddingBottom("10px");
                                this.control(MenuButtonControlDefinition.getControlBuilder("menuButtonListBox", "ListBox", "ListBox demonstration\n\nThis example shows adding and removing items from a ListBox\nas well as the different selection modes that are available."));
                                this.panel(builders.hspacer("10px"));
                                this.control(MenuButtonControlDefinition.getControlBuilder("menuButtonDropDown", "DropDown", "DropDown and RadioButton demonstration\n\nThis shows how to dynamically add items to the\nDropDown control as well as the change event."));
                                this.panel(builders.hspacer("10px"));
                                this.control(MenuButtonControlDefinition.getControlBuilder("menuButtonTextField", "TextField", "TextField demonstration\n\nThis example demonstrates the Textfield example using the password\nmode and the input length restriction. It also demonstrates\nall of the new events the Textfield publishes on the Eventbus."));
                                this.panel(builders.hspacer("10px"));
                                this.control(MenuButtonControlDefinition.getControlBuilder("menuButtonSlider", "Slider & Scrollbars", "Sliders and Scrollbars demonstration\n\nThis creates sliders to change a RGBA value and it\ndisplays a scrollbar that can be customized."));
                                this.panel(builders.hspacer("10px"));
                                this.control(MenuButtonControlDefinition.getControlBuilder("menuButtonScrollPanel", "ScrollPanel", "ScrollPanel demonstration\n\nThis simply shows an image and uses the ScrollPanel\nto scroll around its area. You can directly input\nthe x/y position you want the ScrollPanel to scroll to."));
                                this.panel(builders.hspacer("10px"));
                                this.control(MenuButtonControlDefinition.getControlBuilder("menuButtonDragAndDrop", "Drag and Drop", "Drag and Drop demonstration\n\nDrag and Drop has been extended with Nifty 1.3"));
                                this.panel(builders.hspacer("10px"));
                                this.control(MenuButtonControlDefinition.getControlBuilder("menuButtonCredits", "?", "Credits\n\nCredits and Thanks!", "25px"));
                            }
                        });
                        this.panel(new PanelBuilder("navigation-2"){
                            {
                                this.width("100%");
                                this.height("33px");
                                this.backgroundColor("#5588");
                                this.childLayoutHorizontal();
                                this.paddingLeft("20px");
                                this.paddingRight("20px");
                                this.paddingTop("0px");
                                this.paddingBottom("10px");
                                this.control(MenuButtonControlDefinition.getControlBuilderUser("menuButtonChatControl", "ChatControl", "Chat Control demonstration\n\nThis control was contributed by Nifty User ractoc. It demonstrates\nhow you can combine Nifty standard controls to build more\ncomplex stuff. In this case we've just included his work as\nanother standard control to Nifty! :)"));
                                this.panel(builders.hspacer("10px"));
                                this.control(MenuButtonControlDefinition.getControlBuilderUser("menuButtonMessageBox", "MessageBox", "MessageBox demonstration\n\nThis control was contributed by Nifty User ractoc. It demonstrates\nhow you can combine Nifty standard controls to build more\ncomplex stuff. In this case we've just included his work as\nanother standard control to Nifty! :)"));
                                this.panel(builders.hspacer("10px"));
                                this.control(MenuButtonControlDefinition.getControlBuilderUser("menuButtonTabsControl", "TabGroupControl", "TabGroup Control demonstration\n\nThis control was contributed by Nifty User ractoc. It demonstrates\nhow you can combine Nifty standard controls to build more\ncomplex stuff. In this case we've just included his work as\nanother standard control to Nifty! :)"));
                                this.panel(builders.hspacer("10px"));
                                this.control(MenuButtonControlDefinition.getControlBuilderUser("menuButtonTreeBoxControl", "TreeBoxControl", "TreeBox Control demonstration\n\nThis control was contributed by Nifty User ractoc. It demonstrates\nhow you can combine Nifty standard controls to build more\ncomplex stuff. In this case we've just included his work as\nanother standard control to Nifty! :)"));
                                this.panel(builders.hspacer("10px"));
                                this.control(MenuButtonControlDefinition.getControlBuilderSpecial("menuButtonEventConsumeControl", "Event Consuming", "Nifty Event Consuming demonstration\n\nThis demonstrates how Nifty consumes events and how you caninfluence\nthe event processing to block certain elements from\nreceiving events."));
                            }
                        });
                        this.panel(new PanelBuilder("dialogParent"){
                            {
                                this.childLayoutOverlay();
                                this.width("100%");
                                this.alignCenter();
                                this.valignCenter();
                                this.control(new ControlBuilder("dialogListBox", "listBoxDialogControl"));
                                this.control(new ControlBuilder("dialogDropDown", "dropDownDialogControl"));
                                this.control(new ControlBuilder("dialogTextField", "textFieldDialogControl"));
                                this.control(new ControlBuilder("dialogSliderAndScrollbar", "sliderAndScrollbarDialogControl"));
                                this.control(new ControlBuilder("dialogScrollPanel", "dialogScrollPanel"));
                                this.control(new ControlBuilder("dialogDragAndDrop", "dragAndDropDialog"));
                                this.control(new ControlBuilder("dialogChatControl", "chatControlDialogControl"));
                                this.control(new ControlBuilder("dialogMessageBox", "messageBoxDialogControl"));
                                this.control(new ControlBuilder("dialogTabsControl", "tabsControlDialogControl"));
                                this.control(new ControlBuilder("dialogTreeBoxControl", "treeboxControlDialogControl"));
                                this.control(new ControlBuilder("dialogEventConsumeControl", "eventConsumeDialogControl"));
                            }
                        });
                    }
                });
                this.layer(new LayerBuilder(){
                    {
                        this.childLayoutVertical();
                        this.panel(new PanelBuilder(){
                            {
                                this.height("*");
                            }
                        });
                        this.panel(new PanelBuilder(){
                            {
                                this.childLayoutCenter();
                                this.height("50px");
                                this.width("100%");
                                this.backgroundColor("#5588");
                                this.panel(new PanelBuilder(){
                                    {
                                        this.paddingLeft("25px");
                                        this.paddingRight("25px");
                                        this.height("50%");
                                        this.width("100%");
                                        this.alignCenter();
                                        this.valignCenter();
                                        this.childLayoutHorizontal();
                                        this.control((ControlBuilder)new LabelBuilder(){
                                            {
                                                this.label("Screen Resolution:");
                                            }
                                        });
                                        this.panel(common.hspacer("7px"));
                                        this.control((ControlBuilder)new DropDownBuilder("resolutions"){
                                            {
                                                this.width("200px");
                                            }
                                        });
                                        this.panel(common.hspacer("20px"));
                                        this.control((ControlBuilder)new LabelBuilder(){
                                            {
                                                this.label("Scale Resolution:");
                                            }
                                        });
                                        this.panel(common.hspacer("7px"));
                                        this.control((ControlBuilder)new SliderBuilder(false){
                                            {
                                                this.id("scale-resolution");
                                                this.min(0.5f);
                                                this.max(1.5f);
                                                this.initial(1.0f);
                                                this.stepSize(0.01f);
                                                this.buttonStepSize(0.01f);
                                            }
                                        });
                                        this.panel(common.hspacer("*"));
                                        this.control((ControlBuilder)new ButtonBuilder("resetScreenButton", "Restart Screen"){});
                                    }
                                });
                            }
                        });
                    }
                });
                this.layer(new LayerBuilder("whiteOverlay"){
                    {
                        this.onCustomEffect(new EffectBuilder("renderQuad"){
                            {
                                this.customKey("onResolutionStart");
                                this.length(350);
                                this.neverStopRendering(false);
                            }
                        });
                        this.onStartScreenEffect(new EffectBuilder("renderQuad"){
                            {
                                this.length(300);
                                this.effectParameter("startColor", "#ddff");
                                this.effectParameter("endColor", "#0000");
                            }
                        });
                        this.onEndScreenEffect(new EffectBuilder("renderQuad"){
                            {
                                this.length(300);
                                this.effectParameter("startColor", "#0000");
                                this.effectParameter("endColor", "#ddff");
                            }
                        });
                    }
                });
            }
        }.build(nifty);
    }

    private static void registerMenuButtonHintStyle(@Nonnull Nifty nifty) {
        new StyleBuilder(){
            {
                this.id("special-hint");
                this.base("nifty-panel-bright");
                this.childLayoutCenter();
                this.onShowEffect(new EffectBuilder("fade"){
                    {
                        this.length(150);
                        this.effectParameter("start", "#0");
                        this.effectParameter("end", "#d");
                        this.inherit();
                        this.neverStopRendering(true);
                    }
                });
                this.onShowEffect(new EffectBuilder("move"){
                    {
                        this.length(150);
                        this.inherit();
                        this.neverStopRendering(true);
                        this.effectParameter("mode", "fromOffset");
                        this.effectParameter("offsetY", "-15");
                    }
                });
                this.onCustomEffect(new EffectBuilder("fade"){
                    {
                        this.length(150);
                        this.effectParameter("start", "#d");
                        this.effectParameter("end", "#0");
                        this.inherit();
                        this.neverStopRendering(true);
                    }
                });
                this.onCustomEffect(new EffectBuilder("move"){
                    {
                        this.length(150);
                        this.inherit();
                        this.neverStopRendering(true);
                        this.effectParameter("mode", "toOffset");
                        this.effectParameter("offsetY", "-15");
                    }
                });
            }
        }.build(nifty);
        new StyleBuilder(){
            {
                this.id("special-hint#hint-text");
                this.base("base-font");
                this.alignLeft();
                this.valignCenter();
                this.textHAlignLeft();
                this.color(new Color("#000f"));
            }
        }.build(nifty);
    }

    private static void registerStyles(@Nonnull Nifty nifty) {
        new StyleBuilder(){
            {
                this.id("base-font-link");
                this.base("base-font");
                this.color("#8fff");
                this.interactOnRelease("$action");
                this.onHoverEffect(new HoverEffectBuilder("changeMouseCursor"){
                    {
                        this.effectParameter("id", "hand");
                    }
                });
            }
        }.build(nifty);
        new StyleBuilder(){
            {
                this.id("creditsImage");
                this.alignCenter();
            }
        }.build(nifty);
        new StyleBuilder(){
            {
                this.id("creditsCaption");
                this.font("defaultcontrols/verdana-48-regular.fnt");
                this.width("100%");
                this.textHAlignCenter();
            }
        }.build(nifty);
        new StyleBuilder(){
            {
                this.id("creditsCenter");
                this.base("base-font");
                this.width("100%");
                this.textHAlignCenter();
            }
        }.build(nifty);
    }

    private static void registerConsolePopup(@Nonnull Nifty nifty) {
        new PopupBuilder("consolePopup"){
            {
                this.childLayoutAbsolute();
                this.panel(new PanelBuilder(){
                    {
                        this.childLayoutCenter();
                        this.width("100%");
                        this.height("100%");
                        this.alignCenter();
                        this.valignCenter();
                        this.control((ControlBuilder)new ConsoleBuilder("console"){
                            {
                                this.width("80%");
                                this.lines(25);
                                this.alignCenter();
                                this.valignCenter();
                                this.onStartScreenEffect(new EffectBuilder("move"){
                                    {
                                        this.length(150);
                                        this.inherit();
                                        this.neverStopRendering(true);
                                        this.effectParameter("mode", "in");
                                        this.effectParameter("direction", "top");
                                    }
                                });
                                this.onEndScreenEffect(new EffectBuilder("move"){
                                    {
                                        this.length(150);
                                        this.inherit();
                                        this.neverStopRendering(true);
                                        this.effectParameter("mode", "out");
                                        this.effectParameter("direction", "top");
                                    }
                                });
                            }
                        });
                    }
                });
            }
        }.registerPopup(nifty);
    }

    private static void registerCreditsPopup(@Nonnull Nifty nifty) {
        final CommonBuilders common = new CommonBuilders();
        new PopupBuilder("creditsPopup"){
            {
                super(arg0);
                this.childLayoutCenter();
                this.panel(new PanelBuilder(){
                    {
                        this.width("80%");
                        this.height("80%");
                        this.alignCenter();
                        this.valignCenter();
                        this.onStartScreenEffect(new EffectBuilder("move"){
                            {
                                this.length(400);
                                this.inherit();
                                this.effectParameter("mode", "in");
                                this.effectParameter("direction", "top");
                            }
                        });
                        this.onEndScreenEffect(new EffectBuilder("move"){
                            {
                                this.length(400);
                                this.inherit();
                                this.neverStopRendering(true);
                                this.effectParameter("mode", "out");
                                this.effectParameter("direction", "top");
                            }
                        });
                        this.onEndScreenEffect(new EffectBuilder("fadeSound"){
                            {
                                this.effectParameter("sound", "credits");
                            }
                        });
                        this.onActiveEffect(new EffectBuilder("gradient"){
                            {
                                this.effectValue(new String[]{"offset", "0%", "color", "#00bffecc"});
                                this.effectValue(new String[]{"offset", "75%", "color", "#00213cff"});
                                this.effectValue(new String[]{"offset", "100%", "color", "#880000cc"});
                            }
                        });
                        this.onActiveEffect(new EffectBuilder("playSound"){
                            {
                                this.effectParameter("sound", "credits");
                            }
                        });
                        this.padding("10px");
                        this.childLayoutVertical();
                        this.panel(new PanelBuilder(){
                            {
                                this.width("100%");
                                this.height("*");
                                this.childLayoutOverlay();
                                this.childClip(true);
                                this.panel(new PanelBuilder(){
                                    {
                                        this.width("100%");
                                        this.childLayoutVertical();
                                        this.onActiveEffect(new EffectBuilder("autoScroll"){
                                            {
                                                this.length(100000);
                                                this.effectParameter("start", "0");
                                                this.effectParameter("end", "-3200");
                                                this.inherit(true);
                                            }
                                        });
                                        this.panel(common.vspacer("800px"));
                                        this.text(new TextBuilder(){
                                            {
                                                this.text("Nifty 1.3");
                                                this.style("creditsCaption");
                                            }
                                        });
                                        this.text(new TextBuilder(){
                                            {
                                                this.text("Standard Controls Demonstration using JavaBuilder pattern");
                                                this.style("creditsCenter");
                                            }
                                        });
                                        this.panel(common.vspacer("30px"));
                                        this.text(new TextBuilder(){
                                            {
                                                this.text("\"Look ma, No XML!\" :)");
                                                this.style("creditsCenter");
                                            }
                                        });
                                        this.panel(common.vspacer("70px"));
                                        this.panel(new PanelBuilder(){
                                            {
                                                this.width("100%");
                                                this.height("256px");
                                                this.childLayoutCenter();
                                                this.panel(new PanelBuilder(){
                                                    {
                                                        this.alignCenter();
                                                        this.valignCenter();
                                                        this.childLayoutHorizontal();
                                                        this.width("656px");
                                                        this.panel(new PanelBuilder(){
                                                            {
                                                                this.width("200px");
                                                                this.height("256px");
                                                                this.childLayoutCenter();
                                                                this.text(new TextBuilder(){
                                                                    {
                                                                        this.text("Nifty 1.3 Core");
                                                                        this.style("base-font");
                                                                        this.alignCenter();
                                                                        this.valignCenter();
                                                                    }
                                                                });
                                                            }
                                                        });
                                                        this.panel(new PanelBuilder(){
                                                            {
                                                                this.width("256px");
                                                                this.height("256px");
                                                                this.alignCenter();
                                                                this.valignCenter();
                                                                this.childLayoutOverlay();
                                                                this.image(new ImageBuilder(){
                                                                    {
                                                                        this.filename("defaultcontrols/yin.png");
                                                                    }
                                                                });
                                                                this.image(new ImageBuilder(){
                                                                    {
                                                                        this.filename("defaultcontrols/yang.png");
                                                                    }
                                                                });
                                                            }
                                                        });
                                                        this.panel(new PanelBuilder(){
                                                            {
                                                                this.width("200px");
                                                                this.height("256px");
                                                                this.childLayoutCenter();
                                                                this.text(new TextBuilder(){
                                                                    {
                                                                        this.text("Nifty 1.3 Standard Controls");
                                                                        this.style("base-font");
                                                                        this.alignCenter();
                                                                        this.valignCenter();
                                                                    }
                                                                });
                                                            }
                                                        });
                                                    }
                                                });
                                            }
                                        });
                                        this.panel(common.vspacer("70px"));
                                        this.text(new TextBuilder(){
                                            {
                                                this.text("written and performed\nby void");
                                                this.style("creditsCenter");
                                            }
                                        });
                                        this.panel(common.vspacer("100px"));
                                        this.text(new TextBuilder(){
                                            {
                                                this.text("Sound Credits");
                                                this.style("creditsCaption");
                                            }
                                        });
                                        this.text(new TextBuilder(){
                                            {
                                                this.text("This demonstration uses creative commons licenced sound samples\nand music from the following sources");
                                                this.style("creditsCenter");
                                            }
                                        });
                                        this.panel(common.vspacer("30px"));
                                        this.image(new ImageBuilder(){
                                            {
                                                this.style("creditsImage");
                                                this.filename("defaultcontrols/freesound.png");
                                            }
                                        });
                                        this.panel(common.vspacer("25px"));
                                        this.text(new TextBuilder(){
                                            {
                                                this.text("19546__tobi123__Gong_mf2.wav");
                                                this.style("creditsCenter");
                                            }
                                        });
                                        this.panel(common.vspacer("50px"));
                                        this.image(new ImageBuilder(){
                                            {
                                                this.style("creditsImage");
                                                this.filename("defaultcontrols/cc-mixter-logo.png");
                                                this.set("action", "openLink(http://ccmixter.org/)");
                                            }
                                        });
                                        this.panel(common.vspacer("25px"));
                                        this.text(new TextBuilder(){
                                            {
                                                this.text("\"Almost Given Up\" by Loveshadow");
                                                this.style("creditsCenter");
                                            }
                                        });
                                        this.panel(common.vspacer("100px"));
                                        this.text(new TextBuilder(){
                                            {
                                                this.text("Additional Credits");
                                                this.style("creditsCaption");
                                            }
                                        });
                                        this.text(new TextBuilder(){
                                            {
                                                this.text("ueber awesome Yin/Yang graphic by Dori\n(http://www.nadori.de)\n\nThanks! :)");
                                                this.style("creditsCenter");
                                            }
                                        });
                                        this.panel(common.vspacer("100px"));
                                        this.text(new TextBuilder(){
                                            {
                                                this.text("Special thanks go to");
                                                this.style("creditsCaption");
                                            }
                                        });
                                        this.text(new TextBuilder(){
                                            {
                                                this.text("The following people helped creating Nifty with valuable feedback,\nfixing bugs or sending patches.\n(in no particular order)\n\nchaz0x0\nTumaini\narielsan\ngaba1978\nractoc\nbonechilla\nmdeletrain\nmulov\ngouessej\n");
                                                this.style("creditsCenter");
                                            }
                                        });
                                        this.panel(common.vspacer("75px"));
                                        this.text(new TextBuilder(){
                                            {
                                                this.text("Greetings and kudos go out to");
                                                this.style("creditsCaption");
                                            }
                                        });
                                        this.text(new TextBuilder(){
                                            {
                                                this.text("Ariel Coppes and Ruben Garat of Gemserk\n(http://blog.gemserk.com/)\n\n\nErlend, Kirill, Normen, Skye and Ruth of jMonkeyEngine\n(http://www.jmonkeyengine.com/home/)\n\n\nBrian Matzon, Elias Naur, Caspian Rychlik-Prince for lwjgl\n(http://www.lwjgl.org/\n\n\nKappaOne, MatthiasM, aho, Dragonene, darkprophet, appel, woogley, Riven, NoobFukaire\nfor valuable input and discussions at #lwjgl IRC on the freenode network\n\n\n... and Kevin Glass\n(http://slick.cokeandcode.com/)\n\n\n\n\n\n\n\nAs well as everybody that has not yet given up on Nifty =)\n\nAnd again sorry to all of you that I've forgotten. You rock too!\n\n\n");
                                                this.style("creditsCenter");
                                            }
                                        });
                                        this.panel(common.vspacer("350px"));
                                        this.image(new ImageBuilder(){
                                            {
                                                this.style("creditsImage");
                                                this.filename("defaultcontrols/nifty-logo.png");
                                            }
                                        });
                                    }
                                });
                            }
                        });
                        this.panel(new PanelBuilder(){
                            {
                                this.width("100%");
                                this.paddingTop("10px");
                                this.childLayoutCenter();
                                this.control((ControlBuilder)new ButtonBuilder("creditsBack"){
                                    {
                                        this.label("Back");
                                        this.alignRight();
                                        this.valignCenter();
                                    }
                                });
                            }
                        });
                    }
                });
            }
        }.registerPopup(nifty);
    }

    @Override
    @Nonnull
    public String getStartScreen() {
        return "start";
    }

    @Override
    @Nullable
    public String getMainXML() {
        return null;
    }

    @Override
    @Nonnull
    public String getTitle() {
        return "Nifty Controls Demonstration";
    }

    @Override
    public void prepareStart(@Nonnull Nifty nifty) {
        nifty.loadStyleFile("nifty-default-styles.xml");
        nifty.loadControlFile("nifty-default-controls.xml");
        nifty.registerSound("intro", "defaultcontrols/sound/19546__tobi123__Gong_mf2.wav");
        nifty.registerMusic("credits", "defaultcontrols/sound/Loveshadow_-_Almost_Given_Up.ogg");
        nifty.registerMouseCursor("hand", "defaultcontrols/mouse-cursor-hand.png", 5, 4);
        nifty.enableAutoScaling(1024, 768);
        ControlsDemo.registerMenuButtonHintStyle(nifty);
        ControlsDemo.registerStyles(nifty);
        ControlsDemo.registerConsolePopup(nifty);
        ControlsDemo.registerCreditsPopup(nifty);
        MenuButtonControlDefinition.register(nifty);
        DialogPanelControlDefinition.register(nifty);
        ListBoxDialogControlDefinition.register(nifty);
        DropDownDialogControlDefinition.register(nifty);
        ScrollPanelDialogControlDefinition.register(nifty);
        MessageBoxDialogDefinition.register(nifty);
        ChatControlDialogDefinition.register(nifty);
        TabsControlDialogDefinition.register(nifty);
        TreeBoxControlDialogDefinition.register(nifty);
        TextFieldDialogControlDefinition.register(nifty);
        SliderAndScrollbarDialogControlDefinition.register(nifty);
        DragAndDropDialogDefinition.register(nifty);
        EventConsumeDialogDefinition.register(nifty);
        ControlsDemo.createIntroScreen(nifty);
        ControlsDemo.createDemoScreen(nifty, this.resolutionControl);
    }
}

