/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.textfield;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.TextField;
import de.lessvoid.nifty.controls.TextFieldChangedEvent;
import de.lessvoid.nifty.controls.textfield.InputCharFilterWrapper;
import de.lessvoid.nifty.controls.textfield.InputCharSequenceFilterWrapper;
import de.lessvoid.nifty.controls.textfield.TextFieldLogic;
import de.lessvoid.nifty.controls.textfield.TextFieldView;
import de.lessvoid.nifty.controls.textfield.filter.delete.TextFieldDeleteFilter;
import de.lessvoid.nifty.controls.textfield.filter.input.FilterAcceptDigits;
import de.lessvoid.nifty.controls.textfield.filter.input.FilterAcceptFloat;
import de.lessvoid.nifty.controls.textfield.filter.input.FilterAcceptLetters;
import de.lessvoid.nifty.controls.textfield.filter.input.FilterAcceptLowerCase;
import de.lessvoid.nifty.controls.textfield.filter.input.FilterAcceptNegativeDigits;
import de.lessvoid.nifty.controls.textfield.filter.input.FilterAcceptRegex;
import de.lessvoid.nifty.controls.textfield.filter.input.FilterAcceptUpperCase;
import de.lessvoid.nifty.controls.textfield.filter.input.TextFieldInputCharFilter;
import de.lessvoid.nifty.controls.textfield.filter.input.TextFieldInputCharSequenceFilter;
import de.lessvoid.nifty.controls.textfield.filter.input.TextFieldInputFilter;
import de.lessvoid.nifty.controls.textfield.format.FormatPassword;
import de.lessvoid.nifty.controls.textfield.format.TextFieldDisplayFormat;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.elements.tools.FontHelper;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyStandardInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Deprecated
public class TextFieldControl
extends AbstractController
implements TextField,
TextFieldView {
    @Nonnull
    private static final Logger log = Logger.getLogger(TextFieldControl.class.getName());
    @Nullable
    private Nifty nifty;
    @Nullable
    private Screen screen;
    @Nullable
    private Element textElement;
    @Nullable
    private Element fieldElement;
    @Nullable
    private Element cursorElement;
    @Nullable
    private TextFieldLogic textField;
    private int firstVisibleCharacterIndex;
    private int lastVisibleCharacterIndex;
    private int fieldWidth;
    private int fromClickCursorPos;
    private int toClickCursorPos;
    @Nullable
    private FocusHandler focusHandler;

    public void bind(@Nonnull Nifty niftyParam, @Nonnull Screen screenParam, @Nonnull Element newElement, @Nonnull Parameters properties) {
        this.bind(newElement);
        this.nifty = niftyParam;
        this.screen = screenParam;
        this.fromClickCursorPos = -1;
        this.toClickCursorPos = -1;
        String initText = properties.get("text");
        if (initText == null || initText.isEmpty()) {
            this.textField = new TextFieldLogic(this.nifty.getClipboard(), this);
            this.textField.toFirstPosition();
        } else {
            this.textField = new TextFieldLogic(initText, this.nifty.getClipboard(), this);
        }
        this.textElement = newElement.findElementById("#text");
        this.fieldElement = newElement.findElementById("#field");
        this.cursorElement = newElement.findElementById("#cursor");
        if (this.textElement == null) {
            log.warning("Locating the text element of the text field failed. Looked for: #text");
        }
        if (this.fieldElement == null) {
            log.warning("Locating the field element of the text field failed. Looked for: #field");
        }
        if (this.cursorElement == null) {
            log.warning("Locating the cursor element of the text field failed. Looked for: #cursor");
        }
        if (properties.isSet("passwordChar")) {
            this.textField.setFormat(new FormatPassword(properties.get("passwordChar").charAt(0)));
        }
        this.setMaxLength(properties.getAsInteger("maxLength", -1));
        this.activateFilter(properties.getWithDefault("filter", "all"));
    }

    private void activateFilter(@Nonnull String filter) {
        if ("all".equals(filter)) {
            this.disableInputFilter();
        } else if ("digits".equals(filter)) {
            this.enableInputFilter(new FilterAcceptDigits());
        } else if ("negative digits".equals(filter)) {
            this.enableInputFilter(new FilterAcceptNegativeDigits());
        } else if ("float".equals(filter)) {
            this.enableInputFilter(new FilterAcceptFloat());
        } else if ("letters".equals(filter)) {
            this.enableInputFilter(new FilterAcceptLetters());
        } else if ("upper case".equals(filter)) {
            this.enableInputFilter(new FilterAcceptUpperCase());
        } else if ("lower case".equals(filter)) {
            this.enableInputFilter(new FilterAcceptLowerCase());
        } else {
            this.enableInputFilter(new FilterAcceptRegex(filter));
        }
    }

    public void init(@Nonnull Parameters parameter) {
        super.init(parameter);
        if (this.screen == null) {
            log.severe("Screen instance not set. Binding failed or did not run yet.");
            return;
        }
        this.focusHandler = this.screen.getFocusHandler();
        if (this.textField == null) {
            log.severe("Field logic not available. Binding failed or did not run yet.");
            return;
        }
        this.layoutCallback();
        CharSequence displayedText = this.textField.getDisplayedText();
        this.firstVisibleCharacterIndex = 0;
        this.lastVisibleCharacterIndex = displayedText.length();
        if (this.textElement != null) {
            TextRenderer textRenderer = (TextRenderer)this.textElement.getRenderer(TextRenderer.class);
            if (textRenderer == null) {
                log.warning("Text element does not contain a text renderer");
            } else {
                RenderFont font = textRenderer.getFont();
                if (font == null) {
                    log.warning("No font applied to text element.");
                } else {
                    this.lastVisibleCharacterIndex = FontHelper.getVisibleCharactersFromStart((RenderFont)font, (CharSequence)displayedText, (int)this.fieldWidth, (float)1.0f);
                }
            }
        }
        this.updateCursor();
    }

    public void onStartScreen() {
    }

    public void layoutCallback() {
        this.fieldWidth = this.fieldElement != null && this.cursorElement != null ? this.fieldElement.getWidth() - this.cursorElement.getWidth() : 0;
    }

    @Nonnull
    private CharSequence getVisibleText() {
        if (this.textField == null) {
            return "";
        }
        if (this.lastVisibleCharacterIndex == -1) {
            CharSequence text = this.textField.getDisplayedText();
            return text.subSequence(this.firstVisibleCharacterIndex, text.length());
        }
        return this.textField.getDisplayedText().subSequence(this.firstVisibleCharacterIndex, this.lastVisibleCharacterIndex);
    }

    public void onClick(int mouseX, int mouseY) {
        CharSequence visibleString = this.getVisibleText();
        int indexFromPixel = this.getCursorPosFromMouse(mouseX, visibleString);
        if (indexFromPixel != -1) {
            this.fromClickCursorPos = this.firstVisibleCharacterIndex + indexFromPixel;
        }
        if (this.textField != null) {
            this.textField.resetSelection();
            this.textField.setCursorPosition(this.fromClickCursorPos);
        }
        this.updateCursor();
    }

    public void onClickMouseMove(int mouseX, int mouseY) {
        CharSequence visibleString = this.getVisibleText();
        int indexFromPixel = this.getCursorPosFromMouse(mouseX, visibleString);
        if (indexFromPixel != -1) {
            this.toClickCursorPos = this.firstVisibleCharacterIndex + indexFromPixel;
        }
        if (this.textField != null) {
            this.textField.setCursorPosition(this.fromClickCursorPos);
            this.textField.startSelecting();
            this.textField.setCursorPosition(this.toClickCursorPos);
            this.textField.endSelecting();
        }
        this.updateCursor();
    }

    private int getCursorPosFromMouse(int mouseX, @Nonnull CharSequence visibleString) {
        if (this.textElement == null || this.fieldElement == null) {
            return 0;
        }
        TextRenderer textRenderer = (TextRenderer)this.textElement.getRenderer(TextRenderer.class);
        if (textRenderer == null) {
            return 0;
        }
        RenderFont font = textRenderer.getFont();
        if (font == null) {
            return 0;
        }
        return FontHelper.getCharacterIndexFromPixelPosition((RenderFont)font, (CharSequence)visibleString, (int)(mouseX - this.fieldElement.getX()), (float)1.0f);
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        if (inputEvent instanceof NiftyStandardInputEvent) {
            NiftyStandardInputEvent standardInputEvent = (NiftyStandardInputEvent)inputEvent;
            if (this.textField != null) {
                switch (standardInputEvent) {
                    case MoveCursorLeft: {
                        this.textField.cursorLeft();
                        break;
                    }
                    case MoveCursorRight: {
                        this.textField.cursorRight();
                        break;
                    }
                    case Delete: {
                        this.textField.delete();
                        break;
                    }
                    case Backspace: {
                        this.textField.backspace();
                        break;
                    }
                    case MoveCursorToLastPosition: {
                        this.textField.toLastPosition();
                        break;
                    }
                    case MoveCursorToFirstPosition: {
                        this.textField.toFirstPosition();
                        break;
                    }
                    case SelectionStart: {
                        this.textField.startSelecting();
                        break;
                    }
                    case SelectionEnd: {
                        this.textField.endSelecting();
                        break;
                    }
                    case Cut: {
                        this.textField.cut();
                        break;
                    }
                    case Copy: {
                        this.textField.copy();
                        break;
                    }
                    case Paste: {
                        this.textField.put();
                        break;
                    }
                    case SelectAll: {
                        this.textField.selectAll();
                        break;
                    }
                    case Character: {
                        this.textField.insert(standardInputEvent.getCharacter());
                        break;
                    }
                    case NextInputElement: {
                        if (this.focusHandler == null || this.fieldElement == null) break;
                        this.focusHandler.getNext(this.fieldElement).setFocus();
                        break;
                    }
                    case PrevInputElement: {
                        if (this.focusHandler == null || this.fieldElement == null) break;
                        this.focusHandler.getPrev(this.fieldElement).setFocus();
                        break;
                    }
                    default: {
                        this.updateCursor();
                        return false;
                    }
                }
            }
        }
        this.updateCursor();
        return true;
    }

    private void updateCursor() {
        int d;
        if (this.cursorElement == null || this.textElement == null || this.textField == null) {
            return;
        }
        TextRenderer textRenderer = (TextRenderer)this.textElement.getRenderer(TextRenderer.class);
        if (textRenderer == null) {
            return;
        }
        String text = this.textField.getDisplayedText().toString();
        this.checkBounds(text, textRenderer);
        this.calcLastVisibleIndex(textRenderer);
        textRenderer.setText(text);
        textRenderer.setSelection(this.textField.getSelectionStart(), this.textField.getSelectionEnd());
        int cursorPos = this.textField.getCursorPosition();
        this.calcFirstVisibleIndex(cursorPos);
        this.calcLastVisibleIndex(textRenderer);
        RenderFont font = textRenderer.getFont();
        if (font != null) {
            String substring2 = text.substring(0, this.firstVisibleCharacterIndex);
            d = font.getWidth(substring2);
        } else {
            d = 0;
        }
        textRenderer.setxOffsetHack(-d);
        String substring = text.substring(0, cursorPos);
        int textWidth = textRenderer.getFont().getWidth(substring);
        int cursorPixelPos = textWidth - d;
        Element element = this.getElement();
        if (element == null) {
            return;
        }
        this.cursorElement.setConstraintX(SizeValue.px((int)cursorPixelPos));
        this.cursorElement.setConstraintY(SizeValue.px((int)((this.getElement().getHeight() - this.cursorElement.getHeight()) / 2)));
        this.cursorElement.startEffect(EffectEventId.onActive, null);
        element.getParent().layoutElements();
    }

    private void calcFirstVisibleIndex(int cursorPos) {
        if (cursorPos > this.lastVisibleCharacterIndex) {
            int cursorPosDelta = cursorPos - this.lastVisibleCharacterIndex;
            this.firstVisibleCharacterIndex += cursorPosDelta;
        } else if (cursorPos < this.firstVisibleCharacterIndex) {
            int cursorPosDelta = this.firstVisibleCharacterIndex - cursorPos;
            this.firstVisibleCharacterIndex -= cursorPosDelta;
        }
    }

    private void checkBounds(@Nonnull CharSequence text, @Nonnull TextRenderer textRenderer) {
        int textLen = text.length();
        if (this.firstVisibleCharacterIndex > textLen) {
            this.lastVisibleCharacterIndex = textLen;
            RenderFont font = textRenderer.getFont();
            this.firstVisibleCharacterIndex = font == null ? 0 : FontHelper.getVisibleCharactersFromEnd((RenderFont)font, (CharSequence)text, (int)this.fieldWidth, (float)1.0f);
        }
    }

    private void calcLastVisibleIndex(@Nonnull TextRenderer textRenderer) {
        if (this.textField == null) {
            return;
        }
        CharSequence currentText = this.textField.getDisplayedText();
        RenderFont font = textRenderer.getFont();
        int textLength = currentText.length();
        if (font == null) {
            this.lastVisibleCharacterIndex = textLength;
        } else if (this.firstVisibleCharacterIndex < textLength) {
            CharSequence textToCheck = currentText.subSequence(this.firstVisibleCharacterIndex, textLength);
            int lengthFitting = FontHelper.getVisibleCharactersFromStart((RenderFont)font, (CharSequence)textToCheck, (int)this.fieldWidth, (float)1.0f);
            this.lastVisibleCharacterIndex = lengthFitting + this.firstVisibleCharacterIndex;
        } else {
            this.lastVisibleCharacterIndex = this.firstVisibleCharacterIndex;
        }
    }

    public void onFocus(boolean getFocus) {
        if (this.cursorElement != null) {
            super.onFocus(getFocus);
            if (getFocus) {
                this.cursorElement.startEffect(EffectEventId.onCustom);
            } else {
                this.cursorElement.stopEffect(EffectEventId.onCustom);
            }
            this.updateCursor();
        }
    }

    @Override
    @Nonnull
    public String getText() {
        return this.getRealText();
    }

    @Override
    @Nonnull
    public String getRealText() {
        if (this.textField == null) {
            return "";
        }
        return this.textField.getRealText().toString();
    }

    @Override
    @Nonnull
    public String getDisplayedText() {
        if (this.textField == null) {
            return "";
        }
        return this.textField.getDisplayedText().toString();
    }

    @Override
    public void setText(@Nonnull CharSequence text) {
        CharSequence realText;
        if (this.nifty == null) {
            log.warning("Nifty instance is not set, binding did not run yet. Special value replacing skipped.");
            realText = text;
        } else {
            realText = this.nifty.specialValuesReplace(text.toString());
        }
        if (this.textField != null) {
            this.textField.setText(realText);
        }
        this.updateCursor();
    }

    @Override
    public void setMaxLength(int maxLength) {
        if (this.textField != null) {
            this.textField.setMaxLength(maxLength);
        }
        this.updateCursor();
    }

    @Override
    public void setCursorPosition(int position) {
        if (this.textField != null) {
            this.textField.setCursorPosition(position);
        }
        this.updateCursor();
    }

    @Override
    public void enableInputFilter(@Nullable TextFieldInputFilter filter) {
        if (this.textField != null) {
            this.textField.setInputFilterSingle(filter);
            this.textField.setInputFilterSequence(filter);
        }
    }

    @Override
    public void enableInputFilter(@Nullable TextFieldInputCharFilter filter) {
        if (filter == null) {
            this.enableInputFilter(null);
        } else if (this.textField != null) {
            this.textField.setInputFilterSingle(filter);
            this.textField.setInputFilterSequence(new InputCharFilterWrapper(filter));
        }
    }

    @Override
    public void enableInputFilter(@Nullable TextFieldInputCharSequenceFilter filter) {
        if (filter == null) {
            this.enableInputFilter(null);
        } else if (this.textField != null) {
            this.textField.setInputFilterSingle(new InputCharSequenceFilterWrapper(filter));
            this.textField.setInputFilterSequence(filter);
        }
    }

    @Override
    public void disableInputFilter() {
        this.enableInputFilter(null);
    }

    @Override
    public void enableDeleteFilter(@Nullable TextFieldDeleteFilter filter) {
        if (this.textField != null) {
            this.textField.setDeleteFilter(filter);
        }
    }

    @Override
    public void disableDeleteFilter() {
        this.enableDeleteFilter(null);
    }

    @Override
    public void setFormat(@Nullable TextFieldDisplayFormat format) {
        if (this.textField != null) {
            this.textField.setFormat(format);
        }
    }

    @Override
    public void textChangeEvent(@Nonnull String newText) {
        if (this.nifty == null) {
            log.warning("Binding not done yet. Can't publish events without reference to Nifty.");
        } else {
            String id;
            Element element = this.getElement();
            if (element != null && (id = this.getElement().getId()) != null) {
                this.nifty.publishEvent(id, (NiftyEvent)new TextFieldChangedEvent(this, newText));
            }
        }
    }

    @Override
    public void enablePasswordChar(char passwordChar) {
        this.setFormat(new FormatPassword(passwordChar));
        this.updateCursor();
    }

    @Override
    public void disablePasswordChar() {
        this.setFormat(null);
        this.updateCursor();
    }

    @Override
    public boolean isPasswordCharEnabled() {
        return (this.textField != null ? this.textField.getFormat() : null) instanceof FormatPassword;
    }
}

