/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.tabs;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.Button;
import de.lessvoid.nifty.controls.ButtonClickedEvent;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.Tab;
import de.lessvoid.nifty.controls.TabGroup;
import de.lessvoid.nifty.controls.TabSelectedEvent;
import de.lessvoid.nifty.controls.tabs.TabGroupMember;
import de.lessvoid.nifty.controls.tabs.builder.TabBuilder;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.events.ElementShowEvent;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.loaderv2.types.ElementType;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bushe.swing.event.EventTopicSubscriber;

@Deprecated
public class TabGroupControl
extends AbstractController
implements TabGroup {
    private static final int BUTTON_LEFT_MARGIN = -16;
    private static final Logger log = Logger.getLogger(TabGroupControl.class.getName());
    @Nonnull
    private static final EventTopicSubscriber<ElementShowEvent> showEventSubscriber = new TabGroupShowEventSubscriber();
    @Nonnull
    private final EventTopicSubscriber<ButtonClickedEvent> buttonClickedSubscriber = new ButtonClickEventSubscriber(this);
    @Nullable
    private Element tabButtonPanel;
    @Nullable
    private Element contentPanel;
    @Nullable
    private Nifty nifty;
    @Nullable
    private Screen screen;
    @Nullable
    private ElementType buttonTemplate;
    private int selectedIndex = -1;
    private boolean templateRemoved;

    @Override
    public void addTab(@Nonnull Element tab) {
        Tab tabControl = (Tab)tab.getNiftyControl(Tab.class);
        if (tabControl == null) {
            throw new IllegalArgumentException("Element to add is not a tab.");
        }
        this.addTab(tabControl);
    }

    @Override
    public void addTab(@Nonnull TabBuilder tabBuilder) {
        if (this.nifty == null || this.screen == null || this.contentPanel == null) {
            throw new IllegalStateException("Element is not bound yet. Can't add tabs.");
        }
        Element tab = tabBuilder.build(this.nifty, this.screen, this.contentPanel);
        Tab tabControl = (Tab)tab.getNiftyControl(Tab.class);
        if (tabControl == null) {
            throw new IllegalStateException("Tab builder did not create a tab... WTF?!");
        }
        this.addTab(tabControl);
    }

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters parameter) {
        this.bind(element);
        this.nifty = nifty;
        this.screen = screen;
        this.tabButtonPanel = element.findElementById("#tab-button-panel");
        this.contentPanel = element.findElementById("#tab-content-panel");
        if (this.tabButtonPanel == null) {
            log.severe("Panel for the tabs not found. Tab group will not work properly. Looked for: #tab-button-panel");
        } else {
            Element buttonElement = this.tabButtonPanel.findElementById("#button-template");
            if (buttonElement == null) {
                log.severe("No template for tab button found. Tab group will be unable to display tabs. Looked for: #button-template");
            } else {
                this.buttonTemplate = buttonElement.getElementType().copy();
                buttonElement.markForRemoval(new EndNotify(){

                    public void perform() {
                        TabGroupControl.this.templateRemoved = true;
                    }
                });
            }
        }
        if (this.contentPanel == null) {
            log.severe("Content panel not found. Tab group will be unable to display tab content. Looked for: #tab-content-pane");
        }
    }

    @Override
    @Nullable
    public Tab getSelectedTab() {
        if (this.selectedIndex == -1 || this.contentPanel == null) {
            return null;
        }
        return (Tab)((Element)this.contentPanel.getChildren().get(this.selectedIndex)).getNiftyControl(Tab.class);
    }

    @Override
    public int getSelectedTabIndex() {
        return this.selectedIndex;
    }

    public void init(@Nonnull Parameters parameter) {
        super.init(parameter);
        if (this.contentPanel != null) {
            for (Element element : this.contentPanel.getChildren()) {
                Tab tabControl = (Tab)element.getNiftyControl(Tab.class);
                if (tabControl == null) {
                    log.warning("Element without tab control detected. Removing: " + element.getId());
                    element.markForRemoval();
                    continue;
                }
                this.initTab(tabControl);
                this.selectedIndex = 0;
            }
        }
        this.checkVisibility();
    }

    private void initTab(@Nonnull Tab tab) {
        Button btnControl;
        String buttonId;
        int tabIndex = this.indexOf(tab);
        Element button = this.getButton(tabIndex);
        if (button == null) {
            if (this.buttonTemplate == null || this.nifty == null || this.screen == null || this.tabButtonPanel == null) {
                log.severe("Tab can't be initialized. Binding not done yet or binding failed.");
                return;
            }
            ElementType newButtonTemplate = this.buttonTemplate.copy();
            newButtonTemplate.getAttributes().set("id", this.buildTabButtonName(tabIndex));
            button = this.nifty.createElementFromType(this.screen, this.tabButtonPanel, newButtonTemplate);
        }
        if ((buttonId = button.getId()) != null) {
            this.nifty.subscribe(this.screen, buttonId, ButtonClickedEvent.class, this.buttonClickedSubscriber);
        }
        if (!button.isVisible()) {
            button.show();
        }
        if ((btnControl = (Button)button.getNiftyControl(Button.class)) == null) {
            log.warning("Can't set label of tab selection element that is not a button.");
        } else {
            btnControl.setText(tab.getCaption());
        }
        if (tab instanceof TabGroupMember) {
            ((TabGroupMember)((Object)tab)).setParentTabGroup(this);
        }
    }

    @Nonnull
    private String buildTabButtonName(int index) {
        String tabButtonId = "#tabButton-" + index;
        if (this.tabButtonPanel != null) {
            tabButtonId = this.tabButtonPanel.getId() + tabButtonId;
        }
        return tabButtonId;
    }

    @Override
    public void addTab(@Nonnull Tab tab) {
        Element tabElement = tab.getElement();
        if (tabElement != null) {
            Element tabParentElement = tabElement.getParent();
            if (this.contentPanel != null && !tabParentElement.equals(this.contentPanel)) {
                tabElement.markForMove(this.contentPanel, (EndNotify)new TabAddMoveEndNotify(this, tab));
                return;
            }
        }
        this.initTab(tab);
        this.checkVisibility();
    }

    @Override
    public int indexOf(@Nonnull Tab tab) {
        if (this.contentPanel == null) {
            return -1;
        }
        int length = this.getTabCount();
        List elementList = this.contentPanel.getChildren();
        int result = -1;
        for (int i = 0; i < length; ++i) {
            if (!tab.equals(((Element)elementList.get(i)).getNiftyControl(Tab.class))) continue;
            result = i;
            break;
        }
        return result;
    }

    @Override
    public int getTabCount() {
        return this.contentPanel != null ? this.contentPanel.getChildren().size() : 0;
    }

    @Nullable
    private Element getButton(int index) {
        if (this.tabButtonPanel == null) {
            return null;
        }
        int realIndex = index;
        List buttonList = this.tabButtonPanel.getChildren();
        if (buttonList.isEmpty()) {
            return null;
        }
        if (!this.templateRemoved) {
            ++realIndex;
        }
        if (realIndex >= buttonList.size()) {
            return null;
        }
        return (Element)this.tabButtonPanel.getChildren().get(realIndex);
    }

    @Override
    @Nullable
    public Tab getTabAtIndex(int index) {
        if (this.contentPanel == null) {
            return null;
        }
        return (Tab)((Element)this.contentPanel.getChildren().get(index)).getNiftyControl(Tab.class);
    }

    private void checkVisibility() {
        if (this.contentPanel == null) {
            return;
        }
        int length = this.getTabCount();
        List tabList = this.contentPanel.getChildren();
        for (int i = 0; i < length; ++i) {
            Element tab = (Element)tabList.get(i);
            Element button = this.getButton(i);
            if (button == null) {
                log.warning("Something is wrong with the tabs. Tab button not there anymore.");
                continue;
            }
            if (i == this.selectedIndex) {
                if (!tab.isVisible()) {
                    tab.show();
                }
                if (!"nifty-tab-button-active".equals(button.getStyle())) {
                    button.setStyle("nifty-tab-button-active");
                    this.addMargin(i, button);
                }
                button.setRenderOrder(100000);
                continue;
            }
            if (tab.isVisible()) {
                tab.hide();
            }
            if (!"nifty-tab-button".equals(button.getStyle())) {
                button.setStyle("nifty-tab-button");
                this.addMargin(i, button);
            }
            button.setRenderOrder(0);
        }
        Element element = this.getElement();
        if (element != null) {
            element.layoutElements();
        }
    }

    private void addMargin(int i, @Nonnull Element button) {
        if (i > 0) {
            button.setMarginLeft(SizeValue.px((int)-16));
        } else {
            button.setMarginLeft(SizeValue.px((int)0));
        }
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return true;
    }

    @Override
    public boolean isTabInGroup(@Nonnull Tab tab) {
        return this.indexOf(tab) > -1;
    }

    public void onStartScreen() {
        String id;
        if (this.nifty == null || this.screen == null) {
            log.severe("Starting screen failed. Seems the binding is not done yet.");
        }
        if ((id = this.getId()) != null) {
            this.nifty.subscribe(this.screen, id, ElementShowEvent.class, showEventSubscriber);
        }
    }

    @Override
    public void removeTab(int index) {
        this.removeTab(index, null);
    }

    @Override
    public void removeTab(@Nonnull Tab tab) {
        this.removeTab(tab, null);
    }

    @Override
    public void removeTab(@Nonnull Element tab) {
        this.removeTab(tab, null);
    }

    @Override
    public void removeTab(int index, @Nullable EndNotify notify) {
        if (this.nifty == null) {
            throw new IllegalStateException("Can't remove tab as long as binding is not done.");
        }
        if (index < 0 || index >= this.getTabCount()) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index);
        }
        EndNotify triggeredNotification = notify;
        if (this.selectedIndex == index) {
            this.selectedIndex = Math.max(0, Math.min(this.selectedIndex, this.getTabCount() - 1));
            triggeredNotification = new CheckVisibilityEndNotify(this, triggeredNotification);
        }
        if (this.tabButtonPanel != null) {
            Element button = this.templateRemoved ? (Element)this.tabButtonPanel.getChildren().get(index) : (Element)this.tabButtonPanel.getChildren().get(index + 1);
            this.nifty.unsubscribe(button.getId(), this.buttonClickedSubscriber);
            button.markForRemoval();
        }
        if (this.contentPanel != null) {
            ((Element)this.contentPanel.getChildren().get(index)).markForRemoval(triggeredNotification);
        }
    }

    @Override
    public void removeTab(@Nonnull Tab tab, @Nullable EndNotify notify) {
        int index = this.indexOf(tab);
        if (index == -1) {
            throw new IllegalArgumentException("The tab to remove is not part of this tab group.");
        }
        this.removeTab(index, notify);
    }

    @Override
    public void removeTab(@Nonnull Element tab, @Nullable EndNotify notify) {
        Tab tabControl = (Tab)tab.getNiftyControl(Tab.class);
        if (tabControl == null) {
            throw new IllegalArgumentException("Element to add is not a tab.");
        }
        this.removeTab(tabControl, notify);
    }

    @Override
    public void setSelectedTab(@Nonnull Tab tab) {
        int index = this.indexOf(tab);
        if (index == -1) {
            throw new IllegalArgumentException("The tab to remove is not part of this tab group.");
        }
        this.setSelectedTabIndex(index);
    }

    @Override
    public void setSelectedTabIndex(int index) {
        String id;
        if (index < 0 || index >= this.getTabCount()) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index);
        }
        this.selectedIndex = index;
        this.checkVisibility();
        if (this.nifty != null && (id = this.getId()) != null) {
            Tab tab = this.getTabAtIndex(index);
            if (tab == null) {
                log.severe("Tab with valid index returned null. This looks like a internal error.");
            } else {
                this.nifty.publishEvent(id, (NiftyEvent)new TabSelectedEvent(this, tab, index));
            }
        }
    }

    @Override
    public void setTabCaption(int index, @Nonnull String caption) {
        Element buttonElement;
        if (index < 0 || index >= this.getTabCount()) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index);
        }
        if (this.contentPanel != null) {
            Tab tabControl = (Tab)((Element)this.contentPanel.getChildren().get(index)).getNiftyControl(Tab.class);
            if (tabControl == null) {
                log.severe("Tab control seems to be corrupted. Expected tab control not located.");
            } else {
                tabControl.setCaption(caption);
            }
        }
        if ((buttonElement = this.getButton(index)) == null) {
            log.severe("Tab control seems corrupted. Expected button element not located.");
        } else {
            Button button = (Button)buttonElement.getNiftyControl(Button.class);
            if (button == null) {
                log.severe("Tab button does not seem to contain a button control.");
            } else {
                button.setText(caption);
            }
        }
    }

    @Override
    public void setTabCaption(@Nonnull Tab tab, @Nonnull String caption) {
        int index = this.indexOf(tab);
        if (index == -1) {
            throw new IllegalArgumentException("The tab to remove is not part of this tab group.");
        }
        this.setTabCaption(index, caption);
    }

    private void processButtonClick(@Nonnull Element clickedButton) {
        if (this.tabButtonPanel == null) {
            return;
        }
        List buttons = this.tabButtonPanel.getChildren();
        if (buttons.isEmpty()) {
            return;
        }
        int indexOffset = 0;
        if (!this.templateRemoved) {
            indexOffset = -1;
        }
        this.setSelectedTabIndex(buttons.indexOf(clickedButton) + indexOffset);
    }

    private static final class TabAddMoveEndNotify
    implements EndNotify {
        @Nonnull
        private final TabGroupControl parentControl;
        @Nonnull
        private final Tab tabToAdd;

        private TabAddMoveEndNotify(@Nonnull TabGroupControl control, @Nonnull Tab tab) {
            this.parentControl = control;
            this.tabToAdd = tab;
        }

        public void perform() {
            this.parentControl.addTab(this.tabToAdd);
        }
    }

    private static final class CheckVisibilityEndNotify
    implements EndNotify {
        @Nonnull
        private final TabGroupControl parentControl;
        @Nullable
        private final EndNotify next;

        private CheckVisibilityEndNotify(@Nonnull TabGroupControl control, @Nullable EndNotify nextNotify) {
            this.parentControl = control;
            this.next = nextNotify;
        }

        public void perform() {
            this.parentControl.checkVisibility();
            if (this.next != null) {
                this.next.perform();
            }
        }
    }

    private static final class ButtonClickEventSubscriber
    implements EventTopicSubscriber<ButtonClickedEvent> {
        private final TabGroupControl parentControl;

        private ButtonClickEventSubscriber(TabGroupControl parent) {
            this.parentControl = parent;
        }

        public void onEvent(String topic, @Nonnull ButtonClickedEvent data) {
            Element element = data.getButton().getElement();
            if (element != null) {
                this.parentControl.processButtonClick(element);
            }
        }
    }

    private static final class TabGroupShowEventSubscriber
    implements EventTopicSubscriber<ElementShowEvent> {
        private TabGroupShowEventSubscriber() {
        }

        public void onEvent(@Nonnull String topic, @Nonnull ElementShowEvent data) {
            TabGroupControl control = (TabGroupControl)data.getElement().getControl(TabGroupControl.class);
            if (control != null) {
                control.checkVisibility();
            }
        }
    }
}

