/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.scrollbar;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Scrollbar;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.screen.Screen;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UpdateScrollpanelPositionToDisplayElement
implements EffectImpl {
    @Nonnull
    private final Logger log = Logger.getLogger(UpdateScrollpanelPositionToDisplayElement.class.getName());
    @Nullable
    private Element targetElement;

    public void activate(@Nonnull Nifty nifty, @Nonnull Element elementParameter, @Nonnull EffectProperties parameter) {
        String target = parameter.getProperty("target");
        if (target != null) {
            Screen screen = nifty.getCurrentScreen();
            if (screen == null) {
                this.log.severe("Can't activate the effect while there is no screen selected as current.");
            } else {
                this.targetElement = screen.findElementById(target);
            }
        }
    }

    public void execute(@Nonnull Element element, float normalizedTime, @Nullable Falloff falloff, @Nonnull NiftyRenderEngine r) {
        if (this.targetElement != null) {
            Scrollbar verticalScrollbar = (Scrollbar)this.targetElement.findNiftyControl("#nifty-internal-vertical-scrollbar", Scrollbar.class);
            if (verticalScrollbar == null) {
                this.log.warning("Failed to locate required internal scrollbar.");
                return;
            }
            int minY = (int)verticalScrollbar.getValue();
            int maxY = (int)verticalScrollbar.getValue() + (int)verticalScrollbar.getWorldPageSize();
            int currentMinY = element.getY() - this.targetElement.getY() + (int)verticalScrollbar.getValue();
            int currentMaxY = element.getY() - this.targetElement.getY() + element.getHeight() + (int)verticalScrollbar.getValue();
            int delta = -1;
            if (currentMinY >= maxY || currentMinY <= maxY && currentMaxY >= maxY) {
                delta = currentMaxY - maxY;
                verticalScrollbar.setValue(minY + delta);
            } else if (currentMaxY <= minY || currentMinY <= minY && currentMaxY >= minY) {
                delta = minY - currentMinY;
                verticalScrollbar.setValue(minY - delta);
            }
            this.log.fine(minY + ":" + maxY + " - " + currentMinY + ":" + currentMaxY + " - " + delta);
        }
    }

    public void deactivate() {
    }
}

