/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.scrollbar;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.NextPrevHelper;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.Scrollbar;
import de.lessvoid.nifty.controls.ScrollbarChangedEvent;
import de.lessvoid.nifty.controls.scrollbar.ScrollbarImpl;
import de.lessvoid.nifty.controls.scrollbar.ScrollbarView;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import de.lessvoid.nifty.input.NiftyStandardInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Deprecated
public class ScrollbarControl
extends AbstractController
implements Scrollbar {
    @Nonnull
    private static final Logger log = Logger.getLogger(ScrollbarControl.class.getName());
    @Nonnull
    private final ScrollbarImpl scrollbarImpl = new ScrollbarImpl();
    @Nullable
    private ScrollbarView scrollbarView;
    @Nullable
    private NextPrevHelper nextPrevHelper;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters parameter) {
        this.bind(element);
        Element elementBackground = element.findElementById("#background");
        Element elementPosition = element.findElementById("#position");
        this.nextPrevHelper = new NextPrevHelper(element, screen.getFocusHandler());
        if (elementBackground == null) {
            log.severe("Background of scrollbar control not located. Scrollbar will not work properly. Looked for: #background");
        }
        if (elementPosition == null) {
            log.severe("Position element of scrollbar control not located. Scrollbar will not work properly. Looked for: #position");
        } else if (elementBackground != null) {
            this.scrollbarView = "verticalScrollbar".equals(parameter.get("name")) ? new ScrollbarViewVertical(nifty, this, elementBackground, elementPosition, elementPosition.getConstraintHeight().getValueAsInt(1.0f)) : new ScrollbarViewHorizontal(nifty, this, elementBackground, elementPosition, elementPosition.getConstraintHeight().getValueAsInt(1.0f));
        }
        if (this.scrollbarView != null) {
            float worldMax = parameter.getAsFloat("worldMax", 100.0f);
            float worldPageSize = parameter.getAsFloat("worldPageSize", 100.0f);
            float initial = parameter.getAsFloat("initial", 0.0f);
            float buttonStepSize = parameter.getAsFloat("buttonStepSize", 1.0f);
            float pageStepSize = parameter.getAsFloat("pageStepSize", 25.0f);
            this.scrollbarImpl.bindToView(this.scrollbarView, initial, worldMax, worldPageSize, buttonStepSize, pageStepSize);
        }
    }

    public void onStartScreen() {
    }

    public void layoutCallback() {
        this.scrollbarImpl.updateView();
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        if (this.nextPrevHelper != null && this.nextPrevHelper.handleNextPrev(inputEvent)) {
            return true;
        }
        if (inputEvent == NiftyStandardInputEvent.MoveCursorUp || inputEvent == NiftyStandardInputEvent.MoveCursorLeft) {
            this.scrollbarImpl.stepDown();
            return true;
        }
        if (inputEvent == NiftyStandardInputEvent.MoveCursorDown || inputEvent == NiftyStandardInputEvent.MoveCursorRight) {
            this.scrollbarImpl.stepUp();
            return true;
        }
        return false;
    }

    public void upClick() {
        this.scrollbarImpl.stepDown();
    }

    public void downClick() {
        this.scrollbarImpl.stepUp();
    }

    public void click(int mouseX, int mouseY) {
        if (this.scrollbarView != null) {
            this.scrollbarImpl.interactionClick(this.scrollbarView.filter(mouseX, mouseY));
        }
    }

    public void mouseMoveStart(int mouseX, int mouseY) {
        if (this.scrollbarView != null) {
            this.scrollbarImpl.interactionClick(this.scrollbarView.filter(mouseX, mouseY));
        }
    }

    public void mouseMove(int mouseX, int mouseY) {
        if (this.scrollbarView != null) {
            this.scrollbarImpl.interactionMove(this.scrollbarView.filter(mouseX, mouseY));
        }
    }

    public boolean consumeRelease() {
        return true;
    }

    public boolean mouseWheel(@Nonnull Element element, @Nonnull NiftyMouseInputEvent inputEvent) {
        int mouseWheel = inputEvent.getMouseWheel();
        float currentValue = this.scrollbarImpl.getValue();
        if (mouseWheel < 0) {
            this.scrollbarImpl.setValue(currentValue - this.scrollbarImpl.getButtonStepSize() * (float)mouseWheel);
        } else if (mouseWheel > 0) {
            this.scrollbarImpl.setValue(currentValue - this.scrollbarImpl.getButtonStepSize() * (float)mouseWheel);
        }
        return true;
    }

    @Override
    public void setup(float value, float worldMax, float worldPageSize, float buttonStepSize, float pageStepSize) {
        this.scrollbarImpl.setup(value, worldMax, worldPageSize, buttonStepSize, pageStepSize);
    }

    @Override
    public void setValue(float value) {
        this.scrollbarImpl.setValue(value);
    }

    @Override
    public float getValue() {
        return this.scrollbarImpl.getValue();
    }

    @Override
    public void setWorldMax(float worldMax) {
        this.scrollbarImpl.setWorldMax(worldMax);
    }

    @Override
    public float getWorldMax() {
        return this.scrollbarImpl.getWorldMax();
    }

    @Override
    public void setWorldPageSize(float worldPageSize) {
        this.scrollbarImpl.setWorldPageSize(worldPageSize);
    }

    @Override
    public float getWorldPageSize() {
        return this.scrollbarImpl.getWorldPageSize();
    }

    @Override
    public void setButtonStepSize(float stepSize) {
        this.scrollbarImpl.setButtonStepSize(stepSize);
    }

    @Override
    public float getButtonStepSize() {
        return this.scrollbarImpl.getButtonStepSize();
    }

    @Override
    public void setPageStepSize(float stepSize) {
        this.scrollbarImpl.setPageStepSize(stepSize);
    }

    @Override
    public float getPageStepSize() {
        return this.scrollbarImpl.getPageStepSize();
    }

    private static class ScrollbarViewHorizontal
    implements ScrollbarView {
        @Nonnull
        private final Nifty nifty;
        @Nonnull
        private final ScrollbarControl scrollbar;
        @Nonnull
        private final Element elementBackground;
        @Nonnull
        private final Element elementPosition;
        private int minHandleSize;

        public ScrollbarViewHorizontal(@Nonnull Nifty nifty, @Nonnull ScrollbarControl scrollbar, @Nonnull Element elementBackground, @Nonnull Element elementPosition, int minHandleSize) {
            this.nifty = nifty;
            this.scrollbar = scrollbar;
            this.elementBackground = elementBackground;
            this.elementPosition = elementPosition;
            this.minHandleSize = minHandleSize;
        }

        @Override
        public int getAreaSize() {
            return this.elementBackground.getWidth();
        }

        @Override
        public int getMinHandleSize() {
            return this.minHandleSize;
        }

        @Override
        public void setHandle(int pos, int size) {
            Element scrollbarElement = this.scrollbar.getElement();
            if (scrollbarElement == null) {
                return;
            }
            if (this.elementBackground.getWidth() < this.minHandleSize) {
                if (scrollbarElement.isVisible()) {
                    this.elementPosition.hide();
                }
            } else {
                if (scrollbarElement.isVisible()) {
                    this.elementPosition.show();
                }
                this.elementPosition.setConstraintX(SizeValue.px((int)pos));
                this.elementPosition.setConstraintWidth(SizeValue.px((int)size));
                this.elementBackground.layoutElements();
            }
        }

        @Override
        public void valueChanged(float value) {
            String id = this.scrollbar.getId();
            if (id != null) {
                this.nifty.publishEvent(id, (NiftyEvent)new ScrollbarChangedEvent(this.scrollbar, value));
            }
        }

        @Override
        public int filter(int pixelX, int pixelY) {
            return pixelX - this.elementBackground.getX();
        }
    }

    private static class ScrollbarViewVertical
    implements ScrollbarView {
        @Nonnull
        private final Nifty nifty;
        @Nonnull
        private final ScrollbarControl scrollbar;
        @Nonnull
        private final Element elementBackground;
        @Nonnull
        private final Element elementPosition;
        private int minHandleSize;

        public ScrollbarViewVertical(@Nonnull Nifty nifty, @Nonnull ScrollbarControl scrollbar, @Nonnull Element elementBackground, @Nonnull Element elementPosition, int minHandleSize) {
            this.nifty = nifty;
            this.scrollbar = scrollbar;
            this.elementBackground = elementBackground;
            this.elementPosition = elementPosition;
            this.minHandleSize = minHandleSize;
        }

        @Override
        public int getAreaSize() {
            return this.elementBackground.getHeight();
        }

        @Override
        public int getMinHandleSize() {
            return this.minHandleSize;
        }

        @Override
        public void setHandle(int pos, int size) {
            Element scrollbarElement = this.scrollbar.getElement();
            if (scrollbarElement == null) {
                return;
            }
            if (this.getAreaSize() < this.minHandleSize) {
                if (this.elementPosition.isVisible()) {
                    this.elementPosition.hide();
                }
            } else {
                if (!this.elementPosition.isVisible()) {
                    this.elementPosition.show();
                }
                this.elementPosition.setConstraintY(SizeValue.px((int)pos));
                this.elementPosition.setConstraintHeight(SizeValue.px((int)size));
                this.elementBackground.layoutElements();
            }
        }

        @Override
        public void valueChanged(float value) {
            String id = this.scrollbar.getId();
            if (id != null) {
                this.nifty.publishEvent(id, (NiftyEvent)new ScrollbarChangedEvent(this.scrollbar, value));
            }
        }

        @Override
        public int filter(int pixelX, int pixelY) {
            return pixelY - this.elementBackground.getY();
        }
    }
}

