/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.radiobutton;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.RadioButton;
import de.lessvoid.nifty.controls.RadioButtonGroup;
import de.lessvoid.nifty.controls.RadioButtonStateChangedEvent;
import de.lessvoid.nifty.controls.radiobutton.RadioButtonGroupControl;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyStandardInputEvent;
import de.lessvoid.nifty.screen.Screen;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Deprecated
public class RadioButtonControl
extends AbstractController
implements RadioButton {
    @Nonnull
    private static final Logger log = Logger.getLogger(RadioButtonControl.class.getName());
    private boolean active;
    @Nullable
    private RadioButtonGroupControl radioGroup;
    @Nullable
    private Nifty nifty;
    @Nullable
    private Screen screen;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters parameter) {
        this.bind(element);
        this.nifty = nifty;
        this.screen = screen;
        this.linkToRadioGroup(parameter.get("group"));
    }

    public void onStartScreen() {
        if (this.active) {
            this.publishStateChangedEvent();
        }
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        if (inputEvent == NiftyStandardInputEvent.Activate) {
            this.onClick();
            return true;
        }
        if (this.screen == null) {
            return false;
        }
        Element element = this.getElement();
        if (element != null) {
            if (inputEvent == NiftyStandardInputEvent.NextInputElement) {
                this.screen.getFocusHandler().getNext(element).setFocus();
                return true;
            }
            if (inputEvent == NiftyStandardInputEvent.PrevInputElement) {
                this.screen.getFocusHandler().getPrev(element).setFocus();
                return true;
            }
        }
        return false;
    }

    @Override
    public void setGroup(@Nullable String groupId) {
        this.linkToRadioGroup(groupId);
    }

    @Override
    @Nullable
    public RadioButtonGroup getGroup() {
        return this.radioGroup;
    }

    public void deactivate() {
        if (!this.active) {
            return;
        }
        Element element = this.getElement();
        if (element != null) {
            element.stopEffect(EffectEventId.onCustom);
            element.startEffect(EffectEventId.onCustom, null, "hide");
        }
        this.active = false;
        this.publishStateChangedEvent();
    }

    public void activate() {
        if (this.active) {
            return;
        }
        Element element = this.getElement();
        if (element != null) {
            element.stopEffect(EffectEventId.onCustom);
            element.startEffect(EffectEventId.onCustom, null, "show");
            element.setFocus();
        }
        this.active = true;
        this.publishStateChangedEvent();
    }

    @Override
    public boolean isActivated() {
        return this.active;
    }

    @Override
    public void select() {
        this.onClick();
    }

    public void onClick() {
        if (this.radioGroup == null) {
            return;
        }
        this.radioGroup.onRadioButtonClick(this);
    }

    private void linkToRadioGroup(@Nullable String groupId) {
        if (this.screen == null) {
            log.warning("Linking to radio group failed. Is the binding not done yet?");
        }
        if (groupId == null) {
            this.radioGroup = null;
            return;
        }
        this.radioGroup = (RadioButtonGroupControl)this.screen.findNiftyControl(groupId, RadioButtonGroupControl.class);
        if (this.radioGroup == null) {
            log.warning("No radio group with the id [" + groupId + "] found.");
        } else {
            this.radioGroup.registerRadioButton(this);
        }
    }

    private void publishStateChangedEvent() {
        String id;
        if (this.nifty != null && (id = this.getId()) != null) {
            this.nifty.publishEvent(id, (NiftyEvent)new RadioButtonStateChangedEvent(this, this.active));
        }
    }
}

