/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.listbox;

import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.ListBoxSelectionChangedEvent;
import de.lessvoid.nifty.controls.listbox.ListBoxFocusItem;
import de.lessvoid.nifty.controls.listbox.ListBoxSelectionMode;
import de.lessvoid.nifty.controls.listbox.ListBoxSelectionModeDisabled;
import de.lessvoid.nifty.controls.listbox.ListBoxSelectionModeMulti;
import de.lessvoid.nifty.controls.listbox.ListBoxSelectionModeSingle;
import de.lessvoid.nifty.controls.listbox.ListBoxView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ListBoxImpl<T> {
    @Nonnull
    private static final Logger log = Logger.getLogger(ListBoxImpl.class.getName());
    @Nonnull
    private final ListBox<T> listBox;
    @Nonnull
    private final List<T> items;
    @Nonnull
    private final List<ItemWidth<T>> widthList;
    @Nonnull
    private ListBoxSelectionMode<T> selection;
    @Nullable
    private ListBoxView<T> view;
    private int viewOffset = 0;
    private int viewDisplayItemCount = 0;
    private int focusItemIndex = -1;
    @Nonnull
    private final List<T> visibleItemsForDisplay;
    @Nonnull
    private final List<Integer> selectedItemsForDisplay;
    @Nonnull
    private final ListBoxFocusItem listBoxFocusItem;
    private int lastMaxWidth = 0;

    public ListBoxImpl(@Nonnull ListBox<T> listBox) {
        this.listBox = listBox;
        this.items = new ArrayList<T>();
        this.widthList = new ArrayList<ItemWidth<T>>();
        this.selection = new ListBoxSelectionModeSingle();
        this.visibleItemsForDisplay = new ArrayList<T>();
        this.selectedItemsForDisplay = new ArrayList<Integer>();
        this.listBoxFocusItem = new ListBoxFocusItem();
    }

    public int bindToView(@Nonnull ListBoxView<T> newListBoxView, int viewDisplayItemCount) {
        this.view = newListBoxView;
        this.viewDisplayItemCount = viewDisplayItemCount;
        return this.items.size();
    }

    public void updateView(int newViewOffset) {
        if (newViewOffset > 0 && newViewOffset >= this.items.size()) {
            return;
        }
        this.viewOffset = newViewOffset;
        this.updateView();
    }

    public void updateView() {
        if (this.view != null) {
            this.view.display(this.updateCaptions(), this.getFocusItemForDisplay(), this.getSelectionElementsForDisplay());
        } else {
            log.warning("Updating the view is not possible as long as the view is not bound to this implementation.");
        }
    }

    public void selectItemByVisualIndex(int selectionIndex) {
        if (this.invalidVisualIndex(selectionIndex)) {
            return;
        }
        this.selectItemByIndex(this.viewOffset + selectionIndex);
    }

    public void deselectItemByVisualIndex(int selectionIndex) {
        if (this.invalidVisualIndex(selectionIndex)) {
            return;
        }
        this.deselectItemByIndex(this.viewOffset + selectionIndex);
    }

    @Nullable
    public T getItemByVisualIndex(int selectionIndex) {
        if (this.invalidVisualIndex(selectionIndex)) {
            return null;
        }
        if (this.viewOffset + selectionIndex >= this.items.size()) {
            return null;
        }
        return this.items.get(this.viewOffset + selectionIndex);
    }

    public void changeSelectionMode(@Nonnull ListBox.SelectionMode listBoxSelectionMode, boolean forceSelection) {
        this.changeSelectionMode(listBoxSelectionMode, forceSelection, true);
    }

    void changeSelectionMode(@Nonnull ListBox.SelectionMode listBoxSelectionMode, boolean forceSelection, boolean raiseEvent) {
        List<T> oldSelection = this.getSelection();
        this.selection = this.createSelectionMode(listBoxSelectionMode);
        this.selection.enableRequiresSelection(forceSelection);
        ListIterator<T> it = oldSelection.listIterator(oldSelection.size());
        while (it.hasPrevious()) {
            this.selection.add(it.previous());
        }
        if (this.selection.requiresAutoSelection() && this.itemCount() > 0) {
            this.selection.add(this.items.get(0));
        }
        this.updateView();
        if (raiseEvent) {
            this.selectionChangedEvent();
        }
    }

    public void addItem(@Nonnull T newItem) {
        T visibleItem = this.getVisibleItem();
        this.widthList.add(new ItemWidth<T>(newItem, this.view == null ? 0 : this.view.getWidth(newItem)));
        this.items.add(newItem);
        this.widthUpdate();
        this.focusItemIndexUpdate();
        this.updateViewTotalCount();
        if (visibleItem != null) {
            this.restoreVisibleItem(visibleItem);
        }
        this.ensureAutoSelection(newItem);
    }

    public int itemCount() {
        return this.items.size();
    }

    public void clear() {
        this.items.clear();
        this.selection.clear();
        this.widthList.clear();
        this.lastMaxWidth = 0;
        if (this.view != null) {
            this.view.updateTotalWidth(this.lastMaxWidth);
        }
        this.focusItemIndexUpdate();
        this.updateViewTotalCount();
        this.selectionChangedEvent();
    }

    public void selectItemByIndex(int selectionIndex) {
        if (this.invalidIndex(selectionIndex)) {
            return;
        }
        this.selection.add(this.items.get(selectionIndex));
        this.updateView();
        this.selectionChangedEvent();
        this.setFocusItemByIndex(selectionIndex);
    }

    public void selectItem(@Nonnull T item) {
        this.selectItemByIndex(this.items.indexOf(item));
    }

    public void selectNext() {
        if (!(this.selection instanceof ListBoxSelectionModeSingle)) {
            return;
        }
        if (this.selection.getSelection().isEmpty()) {
            return;
        }
        int selectionIndex = this.items.indexOf(this.selection.getSelection().get(0));
        if (this.invalidIndex(selectionIndex)) {
            return;
        }
        if (this.invalidIndex(++selectionIndex)) {
            return;
        }
        this.selectItemByIndex(selectionIndex);
        this.setFocusItemByIndex(selectionIndex);
    }

    public void selectPrevious() {
        if (!(this.selection instanceof ListBoxSelectionModeSingle)) {
            return;
        }
        if (this.selection.getSelection().isEmpty()) {
            return;
        }
        int selectionIndex = this.items.indexOf(this.selection.getSelection().get(0));
        if (this.invalidIndex(selectionIndex)) {
            return;
        }
        if (this.invalidIndex(--selectionIndex)) {
            return;
        }
        this.selectItemByIndex(selectionIndex);
        this.setFocusItemByIndex(selectionIndex);
    }

    public List<T> getSelection() {
        return Collections.unmodifiableList(this.selection.getSelection());
    }

    @Nonnull
    public List<Integer> getSelectedIndices() {
        List<T> sel = this.selection.getSelection();
        if (sel.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (T selItem : sel) {
            result.add(this.items.indexOf(selItem));
        }
        return result;
    }

    public void removeItemByIndex(int itemIndex) {
        if (this.invalidIndex(itemIndex)) {
            return;
        }
        int oldCount = this.itemCount();
        T visibleItem = this.getVisibleItem();
        T item = this.items.get(itemIndex);
        this.selection.removeForced(item);
        this.items.remove(itemIndex);
        this.widthList.remove(this.findItemIndexInWidthList(item));
        this.widthUpdate();
        this.listBoxFocusItem.prepare();
        this.listBoxFocusItem.registerIndex(itemIndex);
        this.updateAfterRemove(oldCount);
        if (visibleItem != null) {
            this.restoreVisibleItem(visibleItem);
        }
    }

    public void removeItem(T item) {
        this.removeItemByIndex(this.items.indexOf(item));
    }

    public void removeAllItems(@Nonnull Collection<T> itemsToRemove) {
        int oldCount = this.itemCount();
        T visibleItem = this.getVisibleItem();
        this.listBoxFocusItem.prepare();
        for (T item : itemsToRemove) {
            this.listBoxFocusItem.registerIndex(this.items.indexOf(item));
            this.widthList.remove(this.findItemIndexInWidthList(item));
        }
        this.widthUpdate();
        if (!this.items.removeAll(itemsToRemove)) {
            return;
        }
        for (T item : this.selection.getSelection()) {
            this.selection.removeForced(item);
        }
        this.updateAfterRemove(oldCount);
        if (visibleItem != null) {
            this.restoreVisibleItem(visibleItem);
        }
    }

    public void deselectItemByIndex(int itemIndex) {
        if (this.invalidIndex(itemIndex)) {
            return;
        }
        this.selection.remove(this.items.get(itemIndex));
        this.updateView();
        this.selectionChangedEvent();
    }

    public void deselectItem(@Nonnull T item) {
        this.deselectItemByIndex(this.items.indexOf(item));
    }

    @Nonnull
    public List<T> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public void insertItem(@Nonnull T item, int index) {
        if (this.invalidIndexForInsert(index)) {
            return;
        }
        T visibleItem = this.getVisibleItem();
        this.widthList.add(new ItemWidth<T>(item, this.view == null ? 0 : this.view.getWidth(item)));
        this.items.add(index, item);
        this.widthUpdate();
        this.focusItemIndexUpdate();
        this.updateViewTotalCount();
        if (visibleItem != null) {
            this.restoreVisibleItem(visibleItem);
        }
        this.ensureAutoSelection(item);
    }

    public void showItem(@Nonnull T item) {
        this.showItemByIndex(this.items.indexOf(item));
    }

    public void showItemByIndex(int itemIndex) {
        if (this.invalidIndex(itemIndex)) {
            return;
        }
        this.viewOffset = itemIndex;
        if (this.itemCount() <= this.viewDisplayItemCount) {
            this.viewOffset = 0;
        } else if (itemIndex > this.items.size() - this.viewDisplayItemCount) {
            this.viewOffset = this.items.size() - this.viewDisplayItemCount;
        }
        this.updateViewScroll();
        this.updateView();
    }

    public void setFocusItem(@Nullable T item) {
        if (item == null) {
            this.setFocusItemByIndex(-1);
        } else {
            this.setFocusItemByIndex(this.items.indexOf(item));
        }
    }

    public void setFocusItemByIndex(int itemIndex) {
        if (this.invalidIndex(itemIndex) || itemIndex == -1) {
            return;
        }
        this.focusItemIndex = itemIndex;
        if (this.focusItemIndex >= this.viewOffset + this.viewDisplayItemCount) {
            this.viewOffset = this.focusItemIndex - this.viewDisplayItemCount + 1;
            this.updateViewScroll();
            this.updateView();
        } else if (this.focusItemIndex < this.viewOffset) {
            this.showItemByIndex(this.focusItemIndex);
        } else {
            this.updateView();
        }
    }

    @Nullable
    public T getFocusItem() {
        if (this.focusItemIndex == -1) {
            return null;
        }
        return this.items.get(this.focusItemIndex);
    }

    public int getFocusItemIndex() {
        return this.focusItemIndex;
    }

    public void setListBoxViewConverter(ListBox.ListBoxViewConverter<T> viewConverter) {
    }

    public void addAllItems(@Nonnull Collection<T> itemsToAdd) {
        if (itemsToAdd.isEmpty()) {
            return;
        }
        for (T item : itemsToAdd) {
            this.widthList.add(new ItemWidth<T>(item, this.view == null ? 0 : this.view.getWidth(item)));
        }
        T visibleItem = this.getVisibleItem();
        this.items.addAll(itemsToAdd);
        this.widthUpdate();
        this.focusItemIndexUpdate();
        this.updateViewTotalCount();
        if (visibleItem != null) {
            this.restoreVisibleItem(visibleItem);
        }
        if (!itemsToAdd.isEmpty()) {
            this.ensureAutoSelection(itemsToAdd.iterator().next());
        }
    }

    public void sortItems(@Nullable Comparator<T> comparator) {
        Collections.sort(this.items, comparator);
    }

    void updateViewTotalCount() {
        if (this.view == null) {
            log.warning("Can't update total count of view while there is not view bound to the list box implementation.");
        } else {
            this.view.updateTotalCount(this.items.size());
            this.updateView();
        }
    }

    void updateViewScroll() {
        if (this.view == null) {
            log.warning("Can't perform view scrolling as long there is no view bound to the list box implementation.");
        } else {
            this.view.scrollTo(this.viewOffset);
        }
    }

    @Nonnull
    private List<Integer> getSelectionElementsForDisplay() {
        this.selectedItemsForDisplay.clear();
        List<T> selectionList = this.selection.getSelection();
        if (selectionList.isEmpty()) {
            return this.selectedItemsForDisplay;
        }
        for (T selectedItem : selectionList) {
            for (int i = 0; i < this.viewDisplayItemCount; ++i) {
                int selectedItemIndex = this.items.indexOf(selectedItem);
                if (selectedItemIndex != this.viewOffset + i) continue;
                this.selectedItemsForDisplay.add(i);
            }
        }
        return this.selectedItemsForDisplay;
    }

    @Nonnull
    private List<T> updateCaptions() {
        this.visibleItemsForDisplay.clear();
        for (int i = 0; i < this.viewDisplayItemCount && this.viewOffset + i < this.items.size(); ++i) {
            T item = this.items.get(this.viewOffset + i);
            this.visibleItemsForDisplay.add(item);
        }
        return this.visibleItemsForDisplay;
    }

    private int getFocusItemForDisplay() {
        for (int i = 0; i < this.viewDisplayItemCount; ++i) {
            if (this.viewOffset + i >= this.items.size() || this.focusItemIndex != this.viewOffset + i) continue;
            return i;
        }
        return -1;
    }

    private boolean invalidVisualIndex(int selectionIndex) {
        if (selectionIndex < 0) {
            return true;
        }
        if (selectionIndex >= this.viewDisplayItemCount) {
            return true;
        }
        return selectionIndex >= this.itemCount();
    }

    private boolean invalidIndex(int itemIndex) {
        if (itemIndex < 0) {
            return true;
        }
        return itemIndex >= this.items.size();
    }

    private boolean invalidIndexForInsert(int itemIndex) {
        if (itemIndex < 0) {
            return true;
        }
        return itemIndex > this.items.size();
    }

    private void focusItemIndexUpdate() {
        if (this.items.size() == 0) {
            this.focusItemIndex = -1;
            return;
        }
        if (this.items.size() == 1) {
            this.focusItemIndex = 0;
            return;
        }
        if (this.focusItemIndex == -1 && this.itemCount() > 0) {
            this.focusItemIndex = 0;
        }
    }

    private void selectionChangedEvent() {
        if (this.view != null) {
            this.view.publish(new ListBoxSelectionChangedEvent<T>(this.listBox, this.getSelection(), this.getSelectedIndices()));
        }
    }

    private void updateAfterRemove(int oldItemCount) {
        this.focusItemIndex = this.listBoxFocusItem.resolve(this.focusItemIndex, oldItemCount);
        this.focusItemIndexUpdate();
        if (this.selection.requiresAutoSelection() && this.itemCount() > 0 && this.focusItemIndex > -1) {
            this.selection.add(this.items.get(this.focusItemIndex));
        }
        if (this.view != null) {
            this.view.updateTotalCount(this.items.size());
        }
        if (this.viewOffset + this.viewDisplayItemCount > this.itemCount() && this.itemCount() > 0) {
            this.showItemByIndex(this.itemCount() - 1);
            this.selectionChangedEvent();
            return;
        }
        this.updateView();
        this.selectionChangedEvent();
    }

    private void widthUpdate() {
        if (this.widthList.isEmpty()) {
            if (this.lastMaxWidth != 0) {
                this.lastMaxWidth = 0;
                if (this.view != null) {
                    this.view.updateTotalWidth(0);
                }
            }
            return;
        }
        Collections.sort(this.widthList);
        if (this.widthList.get(this.widthList.size() - 1).getWidth() != this.lastMaxWidth) {
            this.lastMaxWidth = this.widthList.get(this.widthList.size() - 1).getWidth();
            if (this.view != null) {
                this.view.updateTotalWidth(this.lastMaxWidth);
            }
        }
    }

    private int findItemIndexInWidthList(T item) {
        for (int i = 0; i < this.widthList.size(); ++i) {
            ItemWidth<T> itemWidth = this.widthList.get(i);
            if (!itemWidth.getItem().equals(item)) continue;
            return i;
        }
        return -1;
    }

    private void ensureAutoSelection(@Nonnull T newItem) {
        if (this.selection.requiresAutoSelection()) {
            this.selectItem(newItem);
        }
    }

    @Nonnull
    private ListBoxSelectionMode<T> createSelectionMode(@Nonnull ListBox.SelectionMode selectionMode) {
        switch (selectionMode) {
            case Single: {
                return new ListBoxSelectionModeSingle();
            }
            case Multiple: {
                return new ListBoxSelectionModeMulti();
            }
            case Disabled: {
                return new ListBoxSelectionModeDisabled();
            }
        }
        return new ListBoxSelectionModeSingle();
    }

    @Nullable
    private T getVisibleItem() {
        return this.getItemByVisualIndex(0);
    }

    private void restoreVisibleItem(@Nonnull T visibleItem) {
        this.showItem(visibleItem);
    }

    private static class ItemWidth<T>
    implements Comparable<ItemWidth<T>> {
        @Nonnull
        private final T item;
        private final int width;

        public ItemWidth(@Nonnull T item, int width) {
            this.item = item;
            this.width = width;
        }

        @Override
        public int compareTo(@Nonnull ItemWidth a) {
            return Integer.valueOf(this.width).compareTo(a.width);
        }

        @Nonnull
        public T getItem() {
            return this.item;
        }

        public int getWidth() {
            return this.width;
        }
    }
}

