/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.listbox;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

class ListBoxFocusItem {
    @Nonnull
    private final List<Integer> indicesToRemove = new ArrayList<Integer>();

    ListBoxFocusItem() {
    }

    public void prepare() {
        this.indicesToRemove.clear();
    }

    public void registerIndex(int value) {
        this.indicesToRemove.add(value);
    }

    public int resolve(int focusIndex, int itemCount) {
        if (focusIndex == -1) {
            return -1;
        }
        if (itemCount == 0) {
            return -1;
        }
        if (this.indicesToRemove.isEmpty()) {
            return focusIndex;
        }
        int newFocusIndex = this.calcNewFocusIndex(focusIndex, this.indicesToRemove);
        if (newFocusIndex >= itemCount - this.indicesToRemove.size()) {
            newFocusIndex = itemCount - this.indicesToRemove.size() - 1;
        }
        return newFocusIndex;
    }

    private int calcNewFocusIndex(int focusIndex, @Nonnull List<Integer> indicesToRemove) {
        int newFocusIndex = focusIndex;
        for (int i = 0; i < indicesToRemove.size(); ++i) {
            int removeIdx = indicesToRemove.get(i);
            if (removeIdx >= newFocusIndex) continue;
            --newFocusIndex;
            this.decrementListEntries(indicesToRemove, i);
        }
        return newFocusIndex;
    }

    private void decrementListEntries(@Nonnull List<Integer> indicesToRemove, int startIdx) {
        for (int i = startIdx; i < indicesToRemove.size(); ++i) {
            indicesToRemove.set(i, indicesToRemove.get(i) - 1);
        }
    }
}

