/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.dropdown;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.ListBoxSelectionChangedEvent;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.dropdown.DropDownControl;
import de.lessvoid.nifty.controls.dropdown.DropDownListBoxSelectionChangedEventSubscriber;
import de.lessvoid.nifty.controls.listbox.ListBoxControl;
import de.lessvoid.nifty.effects.Effect;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.effects.impl.Move;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bushe.swing.event.EventTopicSubscriber;

public class DropDownPopup<T>
extends AbstractController {
    @Nonnull
    private static final Logger log = Logger.getLogger(DropDownPopup.class.getName());
    @Nullable
    private Nifty nifty;
    @Nullable
    private Screen screen;
    private DropDownControl<T> dropDownControl;
    private Element popupInstance;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters parameter) {
        super.bind(element);
        this.nifty = nifty;
        this.screen = screen;
        ListBox listBox = (ListBox)element.findNiftyControl("#listBox", ListBox.class);
        if (listBox == null) {
            log.severe("Drop down popup is corrupted. No reference to list box found. Looked for: #listBox");
        }
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return false;
    }

    public void setDropDownElement(@Nonnull DropDownControl<T> dropDownControl, Element popupInstance) {
        this.dropDownControl = dropDownControl;
        this.popupInstance = popupInstance;
        this.linkPopupToDropDownPosition(dropDownControl);
    }

    public void onStartScreen() {
        ListBox listBox;
        Element element;
        if (this.nifty == null || this.screen == null) {
            log.severe("Control is not bound yet. Can't start the screen for this element.");
        }
        if ((element = this.getElement()) != null && (listBox = (ListBox)element.findNiftyControl("#listBox", ListBox.class)) != null) {
            String listBoxId = listBox.getId();
            if (listBoxId == null) {
                log.warning("List box has no ID, can't subscribe to events, functionality limited.");
            } else {
                this.nifty.subscribe(this.screen, listBoxId, ListBoxSelectionChangedEvent.class, (EventTopicSubscriber)new DropDownListBoxSelectionChangedEventSubscriber(this.nifty, this.screen, listBox, this.dropDownControl, this.popupInstance));
            }
        }
        this.linkPopupToDropDownPosition(this.dropDownControl);
        this.dropDownControl.refresh();
    }

    private void linkPopupToDropDownPosition(@Nonnull DropDownControl<T> dropDownControl) {
        Element element;
        if (this.nifty == null) {
            log.severe("Control is not bound yet. Can't start the screen for this element.");
        }
        if ((element = this.getElement()) == null) {
            return;
        }
        Element panel = element.findElementById("#panel");
        if (panel == null) {
            log.severe("Can't find panel of drop down element, linking the popup location is not possible.");
            return;
        }
        Element dropDownElement = dropDownControl.getElement();
        if (dropDownElement == null) {
            return;
        }
        panel.setConstraintX(SizeValue.px((int)dropDownControl.getElement().getX()));
        panel.setConstraintWidth(SizeValue.px((int)dropDownControl.getWidth()));
        element.layoutElements();
        ListBoxControl listBox = (ListBoxControl)element.findNiftyControl("#listBox", ListBoxControl.class);
        if (listBox != null) {
            listBox.ensureWidthConstraints();
            int listHeight = listBox.getHeight();
            panel.setConstraintHeight(SizeValue.px((int)listHeight));
            if (dropDownControl.getElement().getY() + listHeight > this.nifty.getRenderEngine().getHeight()) {
                panel.setConstraintY(SizeValue.px((int)(dropDownControl.getElement().getY() - listHeight)));
                this.updateMoveEffect(panel, listBox, 1);
            } else {
                panel.setConstraintY(SizeValue.px((int)(dropDownControl.getElement().getY() + dropDownControl.getHeight())));
                this.updateMoveEffect(panel, listBox, -1);
            }
            this.getElement().layoutElements();
        }
    }

    private void updateMoveEffect(@Nonnull Element panel, @Nonnull ListBoxControl listBox, int direction) {
        List moveEffects = panel.getEffects(EffectEventId.onStartScreen, Move.class);
        if (!moveEffects.isEmpty()) {
            ((Effect)moveEffects.get(0)).getParameters().setProperty("offsetY", String.valueOf(direction * listBox.getHeight()));
            ((Effect)moveEffects.get(0)).getParameters().setProperty("mode", "fromOffset");
        }
        if (!(moveEffects = panel.getEffects(EffectEventId.onEndScreen, Move.class)).isEmpty()) {
            ((Effect)moveEffects.get(0)).getParameters().setProperty("offsetY", String.valueOf(direction * listBox.getHeight()));
            ((Effect)moveEffects.get(0)).getParameters().setProperty("mode", "toOffset");
        }
    }

    public void close() {
        this.dropDownControl.close();
    }
}

