/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.dragndrop;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.Draggable;
import de.lessvoid.nifty.controls.Droppable;
import de.lessvoid.nifty.controls.DroppableDropFilter;
import de.lessvoid.nifty.controls.DroppableDroppedEvent;
import de.lessvoid.nifty.controls.NiftyInputControl;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.dragndrop.DraggableControl;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Deprecated
public class DroppableControl
extends AbstractController
implements Droppable {
    @Nonnull
    private static final Logger log = Logger.getLogger(DroppableControl.class.getName());
    @Nullable
    private Nifty nifty;
    @Nullable
    private List<DroppableDropFilter> filters;
    @Nullable
    private Element droppableContent;
    @Nullable
    private DraggableControl draggable;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters parameter) {
        super.bind(element);
        this.nifty = nifty;
        this.droppableContent = element.findElementById("#droppableContent");
        if (this.droppableContent == null) {
            log.severe("Failed to locate content area of the droppable. Droppable element will not work. Looked for: #droppableContent");
        }
    }

    public void onStartScreen() {
        if (this.droppableContent == null) {
            log.severe("No droppable content set. The binding failed or did not run at all.");
        } else {
            Element draggableElement;
            this.draggable = DroppableControl.findDraggableChild(this.droppableContent);
            if (this.draggable != null && (draggableElement = this.draggable.getElement()) != null) {
                this.drop(this.draggable, DroppableControl.reactivate(draggableElement), false);
            }
        }
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return false;
    }

    @Nonnull
    private static EndNotify reactivate(final @Nonnull Element element) {
        return new EndNotify(){

            public void perform() {
                element.reactivate();
            }
        };
    }

    @Nullable
    private static DraggableControl findDraggableChild(@Nonnull Element element) {
        List children = element.getChildren();
        int childrenCount = children.size();
        for (int i = 0; i < childrenCount; ++i) {
            Element child = (Element)children.get(i);
            if (DroppableControl.isDraggable(child)) {
                return (DraggableControl)child.getControl(DraggableControl.class);
            }
            DraggableControl draggable = DroppableControl.findDraggableChild(child);
            if (draggable == null) continue;
            return draggable;
        }
        return null;
    }

    private static boolean isDraggable(@Nonnull Element element) {
        NiftyInputControl control = element.getAttachedInputControl();
        if (control != null) {
            return control.getController() instanceof Draggable;
        }
        return false;
    }

    protected void drop(@Nonnull DraggableControl droppedDraggable, EndNotify endNotify) {
        this.drop(droppedDraggable, endNotify, true);
    }

    private void drop(@Nonnull DraggableControl droppedDraggable, @Nullable EndNotify endNotify, boolean notifyObservers) {
        if (this.droppableContent == null) {
            return;
        }
        this.draggable = droppedDraggable;
        Element draggableElement = this.draggable.getElement();
        if (draggableElement != null) {
            draggableElement.setConstraintX(SizeValue.px((int)0));
            draggableElement.setConstraintY(SizeValue.px((int)0));
            draggableElement.markForMove(this.droppableContent, endNotify);
        }
        Droppable source = droppedDraggable.getDroppable();
        droppedDraggable.setDroppable(this);
        if (notifyObservers) {
            this.notifyObservers(source, droppedDraggable);
        }
    }

    @Nullable
    public DraggableControl getDraggable() {
        return this.draggable;
    }

    private void notifyObservers(@Nullable Droppable source, @Nonnull Draggable droppedDraggable) {
        if (this.nifty == null) {
            return;
        }
        String id = this.getId();
        if (id != null) {
            this.nifty.publishEvent(id, (NiftyEvent)new DroppableDroppedEvent(source, droppedDraggable, this));
        }
    }

    @Override
    public void addFilter(@Nonnull DroppableDropFilter filter) {
        if (this.filters == null) {
            this.filters = new ArrayList<DroppableDropFilter>();
        }
        this.filters.add(filter);
    }

    @Override
    public void removeFilter(@Nonnull DroppableDropFilter filter) {
        if (this.filters != null) {
            this.filters.remove(filter);
            if (this.filters.isEmpty()) {
                this.filters = null;
            }
        }
    }

    @Override
    public void removeAllFilters() {
        this.filters = null;
    }

    protected boolean accept(@Nullable Droppable source, @Nonnull Draggable draggable) {
        if (this.filters == null) {
            return true;
        }
        int filterCount = this.filters.size();
        for (int i = 0; i < filterCount; ++i) {
            DroppableDropFilter filter = this.filters.get(i);
            if (filter.accept(source, draggable, this)) continue;
            return false;
        }
        return true;
    }
}

