/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.dragndrop;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.Draggable;
import de.lessvoid.nifty.controls.DraggableDragCanceledEvent;
import de.lessvoid.nifty.controls.DraggableDragStartedEvent;
import de.lessvoid.nifty.controls.Droppable;
import de.lessvoid.nifty.controls.NiftyInputControl;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.dragndrop.DroppableControl;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Deprecated
public class DraggableControl
extends AbstractController
implements Draggable {
    @Nonnull
    private static final String POPUP = "draggablePopup";
    @Nonnull
    private static final Logger log = Logger.getLogger(DraggableControl.class.getName());
    @Nullable
    private Nifty nifty;
    @Nullable
    private Screen screen;
    @Nullable
    private Element originalParent;
    @Nullable
    private Element popup;
    @Nullable
    private Element handle;
    private boolean revert;
    private boolean dropEnabled;
    private boolean dragged = false;
    private boolean triedDragging = false;
    private int originalPositionX;
    private int originalPositionY;
    @Nonnull
    private SizeValue originalConstraintX;
    @Nonnull
    private SizeValue originalConstraintY;
    private int dragStartX;
    private int dragStartY;
    @Nullable
    private Droppable droppable;
    private boolean disableAtEndOfDrag;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters parameter) {
        super.bind(element);
        this.nifty = nifty;
        this.screen = screen;
        String handleId = parameter.get("handle");
        this.handle = element.findElementById(handleId);
        if (this.handle == null) {
            this.handle = element;
        }
        this.revert = parameter.getAsBoolean("revert", true);
        this.dropEnabled = parameter.getAsBoolean("drop", true);
    }

    public void onStartScreen() {
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return false;
    }

    public void bringToFront() {
        if (!this.dragged) {
            this.moveToFront();
        }
    }

    private void dragStart(int mouseX, int mouseY) {
        if (this.dragged || this.triedDragging) {
            return;
        }
        this.triedDragging = true;
        Element draggable = this.getElement();
        if (draggable == null) {
            return;
        }
        this.originalParent = draggable.getParent();
        this.originalPositionX = draggable.getX();
        this.originalPositionY = draggable.getY();
        this.originalConstraintX = draggable.getConstraintX();
        this.originalConstraintY = draggable.getConstraintY();
        this.dragStartX = mouseX;
        this.dragStartY = mouseY;
        if (this.handle != null && this.handle.isMouseInsideElement(mouseX, mouseY)) {
            this.moveDraggableToPopup();
            this.dragged = true;
            this.notifyObserversDragStarted();
        } else {
            this.moveToFront();
        }
    }

    public void drag(int mouseX, int mouseY) {
        if (!this.dragged) {
            this.dragStart(mouseX, mouseY);
            return;
        }
        Element draggable = this.getElement();
        if (draggable == null) {
            return;
        }
        int newPositionX = this.originalPositionX + mouseX - this.dragStartX;
        int newPositionY = this.originalPositionY + mouseY - this.dragStartY;
        draggable.setConstraintX(SizeValue.px((int)newPositionX));
        draggable.setConstraintY(SizeValue.px((int)newPositionY));
        if (this.popup != null) {
            this.popup.layoutElements();
        }
    }

    public void dragStop() {
        this.triedDragging = false;
        if (!this.dragged) {
            this.moveToFront();
            return;
        }
        Element newDroppable = this.findDroppableAtCurrentCoordinates();
        if (newDroppable == null || newDroppable == this.originalParent) {
            this.dragCancel();
        } else {
            DroppableControl droppableControl = (DroppableControl)newDroppable.getControl(DroppableControl.class);
            if (droppableControl == null) {
                log.warning("Droppable has no Droppable control. Corrupted controls! Canceling drag.");
                this.dragCancel();
            } else if (droppableControl.accept(this.droppable, this)) {
                droppableControl.drop(this, this.closePopup());
            } else {
                this.dragCancel();
            }
        }
        this.dragged = false;
        this.postDragActions();
    }

    private void moveDraggableToPopup() {
        if (this.nifty == null || this.screen == null) {
            return;
        }
        final Element draggable = this.getElement();
        if (draggable == null) {
            return;
        }
        this.popup = this.nifty.createPopup(this.screen, POPUP);
        String popupId = this.popup.getId();
        if (popupId == null) {
            log.severe("Newly created popup did not get a ID. Critical internal error. Popup creation failed.");
            return;
        }
        this.nifty.showPopup(this.screen, popupId, null);
        draggable.markForMove(this.popup, new EndNotify(){

            public void perform() {
                draggable.getFocusHandler().requestExclusiveMouseFocus(draggable);
                draggable.setConstraintX(SizeValue.px((int)DraggableControl.this.originalPositionX));
                draggable.setConstraintY(SizeValue.px((int)DraggableControl.this.originalPositionY));
            }
        });
    }

    @Override
    public void moveToFront() {
        final Element draggable = this.getElement();
        if (draggable == null) {
            return;
        }
        Element parent = draggable.getParent();
        List siblings = parent.getChildren();
        if (siblings.get(siblings.size() - 1) == draggable) {
            return;
        }
        draggable.markForMove(parent, new EndNotify(){

            public void perform() {
                draggable.reactivate();
            }
        });
    }

    public void disable() {
        this.disable(true);
    }

    @Override
    public void disable(boolean cancelCurrentDrag) {
        if (this.dragged) {
            if (cancelCurrentDrag) {
                this.dragCancel();
                this.dragged = false;
                super.disable();
            } else {
                this.disableAtEndOfDrag = true;
            }
        } else {
            super.disable();
        }
    }

    private void postDragActions() {
        if (this.disableAtEndOfDrag) {
            this.disableAtEndOfDrag = false;
            super.disable();
        }
    }

    private void dragCancel() {
        Element draggable = this.getElement();
        if (draggable == null) {
            return;
        }
        if (this.revert) {
            draggable.setConstraintX(this.originalConstraintX);
            draggable.setConstraintY(this.originalConstraintY);
        } else {
            draggable.setConstraintX(SizeValue.px((int)draggable.getX()));
            draggable.setConstraintY(SizeValue.px((int)draggable.getY()));
        }
        this.moveDraggableBackToOriginalParent();
        this.notifyObserversDragCanceled();
    }

    @Nullable
    private EndNotify closePopup() {
        return new EndNotify(){

            public void perform() {
                if (DraggableControl.this.popup == null || DraggableControl.this.nifty == null) {
                    return;
                }
                final Element draggable = DraggableControl.this.getElement();
                if (draggable == null) {
                    return;
                }
                String popupId = DraggableControl.this.popup.getId();
                if (popupId == null) {
                    return;
                }
                DraggableControl.this.nifty.closePopup(popupId, new EndNotify(){

                    public void perform() {
                        draggable.reactivate();
                        DraggableControl.this.popup.markForRemoval(new EndNotify(){

                            public void perform() {
                                DraggableControl.this.popup = null;
                            }
                        });
                    }
                });
            }
        };
    }

    private void moveDraggableBackToOriginalParent() {
        if (this.originalParent == null) {
            return;
        }
        Element draggable = this.getElement();
        if (draggable == null) {
            return;
        }
        draggable.markForMove(this.originalParent, this.closePopup());
    }

    @Nullable
    private Element findDroppableAtCurrentCoordinates() {
        if (this.screen == null) {
            return null;
        }
        if (this.dropEnabled) {
            Element draggable = this.getElement();
            if (draggable == null) {
                return null;
            }
            int dragAnkerX = draggable.getX() + draggable.getWidth() / 2;
            int dragAnkerY = draggable.getY() + draggable.getHeight() / 2;
            List layers = this.screen.getLayerElements();
            int layerCount = layers.size();
            for (int i = layerCount - 1; i >= 0; --i) {
                DroppableSearchResult droppableSearchResult;
                Element layer = (Element)layers.get(i);
                if (this.popup == null || layer == this.popup || (droppableSearchResult = this.findDroppableAtCoordinates(layer, dragAnkerX, dragAnkerY)) == null) continue;
                if (droppableSearchResult.getFoundDroppable() == null) break;
                return droppableSearchResult.getFoundDroppable();
            }
        }
        return this.originalParent;
    }

    @Nullable
    private DroppableSearchResult findDroppableAtCoordinates(@Nonnull Element context, int x, int y) {
        List elements = context.getChildren();
        int childCount = elements.size();
        for (int i = childCount - 1; i >= 0; --i) {
            boolean mouseInsideAndVisible;
            Element element = (Element)elements.get(i);
            boolean bl = mouseInsideAndVisible = element.isVisibleWithParent() && element.isMouseInsideElement(x, y);
            if (mouseInsideAndVisible && this.isDroppable(element)) {
                return new DroppableSearchResult(element);
            }
            DroppableSearchResult searchResult = this.findDroppableAtCoordinates(element, x, y);
            if (searchResult != null) {
                return searchResult;
            }
            if (!mouseInsideAndVisible || !element.isVisibleToMouseEvents()) continue;
            return new DroppableSearchResult();
        }
        return null;
    }

    private boolean isDroppable(@Nonnull Element element) {
        NiftyInputControl control = element.getAttachedInputControl();
        if (control != null) {
            return control.getController() instanceof DroppableControl;
        }
        return false;
    }

    @Nullable
    public Droppable getDroppable() {
        return this.droppable;
    }

    @Override
    public void setDroppable(@Nullable Droppable droppable) {
        this.droppable = droppable;
    }

    private void notifyObserversDragStarted() {
        if (this.nifty == null || this.droppable == null) {
            return;
        }
        String id = this.getId();
        if (id != null) {
            this.nifty.publishEvent(id, (NiftyEvent)new DraggableDragStartedEvent(this.droppable, this));
        }
    }

    private void notifyObserversDragCanceled() {
        if (this.nifty == null || this.droppable == null) {
            return;
        }
        String id = this.getId();
        if (id != null) {
            this.nifty.publishEvent(id, (NiftyEvent)new DraggableDragCanceledEvent(this.droppable, this));
        }
    }

    private class DroppableSearchResult {
        @Nullable
        private final Element foundDroppable;

        DroppableSearchResult() {
            this(null);
        }

        DroppableSearchResult(Element foundDroppable) {
            this.foundDroppable = foundDroppable;
        }

        @Nullable
        public Element getFoundDroppable() {
            return this.foundDroppable;
        }
    }
}

