/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.console;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.Console;
import de.lessvoid.nifty.controls.ConsoleExecuteCommandEvent;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.TextField;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyStandardInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bushe.swing.event.EventTopicSubscriber;

@Deprecated
public class ConsoleControl
extends AbstractController
implements Console,
EventTopicSubscriber<NiftyInputEvent> {
    @Nonnull
    private static final Logger log = Logger.getLogger(ConsoleControl.class.getName());
    @Nullable
    private Nifty nifty;
    @Nullable
    private Screen screen;
    @Nullable
    private ListBox<String> listBox;
    @Nullable
    private TextField textfield;
    @Nullable
    private Color standardColor = null;
    @Nonnull
    private Color errorColor = new Color("#f00a");

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters properties) {
        super.bind(element);
        this.nifty = nifty;
        this.screen = screen;
        this.listBox = (ListBox)element.findNiftyControl("#listBox", ListBox.class);
        this.textfield = (TextField)element.findNiftyControl("#textInput", TextField.class);
        if (this.listBox == null) {
            log.severe("Failed to locate the list to show the console log. Console functionality severely limited. Looked for: #listBox");
        }
        if (this.textfield == null) {
            log.severe("Failed to locate the input area of the console. No console input possible. Looked for: #textInput");
        }
        this.initialFill();
    }

    public void init(@Nonnull Parameters parameter) {
        super.init(parameter);
        if (this.textfield == null || this.nifty == null || this.screen == null) {
            log.severe("The element is not bound or the binding failed.");
        } else {
            String id = this.textfield.getId();
            if (id == null) {
                log.warning("The text field does not seem to have a proper ID. Event subscribing is not possible. Console functions limited.");
            } else {
                this.nifty.subscribe(this.screen, id, NiftyInputEvent.class, (EventTopicSubscriber)this);
            }
            Element element = this.getElement();
            if (element != null) {
                element.getParent().layoutElements();
            }
        }
    }

    public void onStartScreen() {
        if (this.textfield != null) {
            this.textfield.setFocus();
        }
    }

    @Override
    @Nullable
    public TextField getTextField() {
        return this.textfield;
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return false;
    }

    public void onEvent(String topic, @Nonnull NiftyInputEvent data) {
        if (data == NiftyStandardInputEvent.SubmitText && this.textfield != null && this.listBox != null) {
            String text = this.textfield.getText();
            this.listBox.addItem(text);
            this.listBox.showItemByIndex(this.listBox.itemCount() - 1);
            this.textfield.setText("");
            String id = this.getId();
            if (id != null && this.nifty != null) {
                this.nifty.publishEvent(id, (NiftyEvent)new ConsoleExecuteCommandEvent(this, text));
            }
        }
    }

    @Override
    public void output(@Nonnull String value) {
        this.out(value, this.standardColor);
    }

    @Override
    public void output(@Nonnull String value, @Nullable Color color) {
        this.out(value, color);
    }

    @Override
    public void outputError(@Nonnull String value) {
        this.out(value, this.errorColor);
    }

    @Override
    @Nonnull
    public String[] getConsoleContent() {
        if (this.listBox == null) {
            return new String[0];
        }
        List<String> var = this.listBox.getItems();
        return var.toArray(new String[var.size()]);
    }

    @Override
    public void clear() {
        if (this.listBox != null) {
            this.listBox.clear();
        }
        this.initialFill();
    }

    @Override
    public void changeColors(@Nullable Color standardColor, @Nonnull Color errorColor) {
        this.standardColor = standardColor;
        this.errorColor = errorColor;
    }

    private void initialFill() {
        if (this.listBox != null) {
            for (int i = 0; i < this.listBox.getDisplayItemCount(); ++i) {
                this.listBox.addItem("");
            }
        }
    }

    private void out(@Nonnull String param, @Nullable Color color) {
        if (this.listBox == null) {
            return;
        }
        String value = this.nifty == null ? param : this.nifty.specialValuesReplace(param);
        String[] lines = value.split("\n");
        ArrayList<String> list = new ArrayList<String>(lines.length);
        for (String line : lines) {
            if (color != null) {
                list.add("\\" + color.getColorString() + "#" + line);
                continue;
            }
            list.add(line);
        }
        this.listBox.addAllItems(list);
        this.listBox.showItemByIndex(this.listBox.itemCount() - 1);
    }
}

