/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.builder.ElementBuilder;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.button.builder.ButtonBuilder;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.ImageRenderer;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.screen.Screen;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MessageBox
extends AbstractController {
    @Nonnull
    private String[] buttonCaptions;
    @Nonnull
    private MessageType messageType = MessageType.INFO;
    @Nullable
    private NiftyImage icon;
    @Nonnull
    private String message;
    @Nonnull
    private final String buttonWidth = "100px";
    @Nonnull
    private final String buttonHeight = "25px";
    @Nullable
    private Nifty nifty;
    @Nullable
    private Element messageboxPopup;
    @Nullable
    private MessageBox msgBox;

    public MessageBox() {
    }

    public MessageBox(@Nonnull Nifty nifty, @Nonnull MessageType messageType, @Nonnull String message, String buttonCaption, String icon) {
        this.nifty = nifty;
        this.messageboxPopup = nifty.createPopup("niftyPopupMessageBox");
        if (this.messageboxPopup == null) {
            return;
        }
        this.msgBox = (MessageBox)this.messageboxPopup.findNiftyControl("#messagebox", MessageBox.class);
        if (this.msgBox != null) {
            this.msgBox.setMessageType(messageType);
            this.msgBox.setMessage(message);
            this.msgBox.setButtonCaption(buttonCaption);
            this.msgBox.setIcon(icon);
            this.msgBox.setupMessageBox();
        }
    }

    public MessageBox(@Nonnull Nifty nifty, @Nonnull MessageType messageType, @Nonnull String message, String buttonCaption) {
        this(nifty, messageType, message, buttonCaption, (String)null);
    }

    public MessageBox(@Nonnull Nifty nifty, @Nonnull MessageType messageType, @Nonnull String message, String[] buttonCaptions, String icon) {
        this.nifty = nifty;
        this.messageboxPopup = nifty.createPopup("niftyPopupMessageBox");
        if (this.messageboxPopup == null) {
            return;
        }
        this.msgBox = (MessageBox)this.messageboxPopup.findNiftyControl("#messagebox", MessageBox.class);
        if (this.msgBox != null) {
            this.msgBox.setMessageType(messageType);
            this.msgBox.setMessage(message);
            this.msgBox.setButtonCaptions(buttonCaptions);
            this.msgBox.setIcon(icon);
            this.msgBox.setupMessageBox();
        }
    }

    public MessageBox(@Nonnull Nifty nifty, @Nonnull MessageType messageType, @Nonnull String message, String ... buttonCaptions) {
        this(nifty, messageType, message, buttonCaptions, (String)null);
    }

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters parameter) {
        this.messageboxPopup = element;
        this.nifty = nifty;
        if (parameter.isSet("buttonCaptions")) {
            this.setButtonCaptions(parameter.getWithDefault("buttonCaptions", "").split(","));
        } else if (parameter.isSet("buttonCaption")) {
            this.setButtonCaption(parameter.get("buttonCaption"));
        }
        if (this.messageType != MessageType.CUSTOM) {
            this.setIcon("messagebox/" + this.messageType.name() + ".png");
        }
    }

    public void onStartScreen() {
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return false;
    }

    public void show() {
        this.nifty.showPopup(this.nifty.getCurrentScreen(), this.messageboxPopup.getId(), null);
    }

    public void close(String command) {
        this.closeMessageBox();
        this.nifty.closePopup(this.messageboxPopup.getParent().getId());
    }

    public void setIcon(@Nullable String icon) {
        if (icon != null) {
            this.icon = this.nifty.createImage(icon, false);
        }
    }

    public void setMessage(@Nonnull String message) {
        this.message = message;
    }

    public void setButtonCaption(String buttonCaption) {
        this.buttonCaptions = new String[]{buttonCaption};
    }

    public void setButtonCaptions(String ... buttonCaptions) {
        this.buttonCaptions = Arrays.copyOf(buttonCaptions, buttonCaptions.length);
    }

    public void setButtonCaptions(@Nonnull String buttonCaptions) {
        this.buttonCaptions = buttonCaptions.split(",");
    }

    public void setMessageType(@Nonnull String messageType) {
        this.messageType = MessageType.valueOf(messageType);
    }

    public void setMessageType(@Nonnull MessageType messageType) {
        this.messageType = messageType;
    }

    private void setupMessageBox() {
        Element imgIcon = this.messageboxPopup.findElementById("#messagebox").findElementById("#message-icon");
        ImageRenderer iconRenderer = (ImageRenderer)imgIcon.getRenderer(ImageRenderer.class);
        iconRenderer.setImage(this.icon);
        Element text = this.messageboxPopup.findElementById("#messagebox").findElementById("#message-text");
        TextRenderer textRenderer = (TextRenderer)text.getRenderer(TextRenderer.class);
        textRenderer.setText(this.message);
        int i = 0;
        for (String buttonCaption : this.buttonCaptions) {
            this.createButton(buttonCaption, buttonCaption, "button_" + ++i);
        }
        this.messageboxPopup.findElementById("#messagebox").layoutElements();
        this.nifty.getCurrentScreen().layoutLayers();
    }

    private void closeMessageBox() {
        this.clearButtons();
        this.nifty.getCurrentScreen().layoutLayers();
    }

    private void createButton(final @Nonnull String buttonCaption, final String command, String buttonId) {
        Element buttonPanel = this.messageboxPopup.findElementById("#messagebox").findElementById("#buttons");
        if (buttonPanel.findElementById("#" + buttonId) == null) {
            new ButtonBuilder("#" + buttonId){
                {
                    super(id);
                    this.style("nifty-button");
                    this.childLayout(ElementBuilder.ChildLayoutType.Horizontal);
                    this.interactOnClick("close(" + command + ")");
                    this.width("100px");
                    this.height("25px");
                    this.label(buttonCaption);
                }
            }.build(this.nifty, this.nifty.getCurrentScreen(), buttonPanel);
        }
    }

    private void clearButtons() {
        List buttons = this.messageboxPopup.findElementById("#messagebox").findElementById("#buttons").getChildren();
        for (Element button : buttons) {
            button.markForRemoval();
        }
    }

    @Nullable
    protected Element getMessageBoxPopup() {
        return this.messageboxPopup;
    }

    public static enum MessageType {
        CUSTOM,
        INFO,
        WARNING,
        ERROR;

    }
}

