/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.helper;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.core.app.ActivityCompat;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001%B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J'\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u0004H\u0002J!\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\u0002\u0010\u0018J-\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\u001b\u001a\u00020\u0011H\u0003\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0016\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010 \u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u0004H\u0003J)\u0010!\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\u001b\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u0004H\u0002J\b\u0010#\u001a\u00020\u000fH\u0003J\u001a\u0010$\u001a\u00020\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/nguyenhoanglam/imagepicker/helper/PermissionHelper;", "", "()V", "PREFERENCE_FILE_NAME", "", "checkPermission", "Lcom/nguyenhoanglam/imagepicker/helper/PermissionHelper$STATUS;", "activity", "Landroid/app/Activity;", "permission", "checkPermissions", "", "permissions", "(Landroid/app/Activity;[Ljava/lang/String;)[Lcom/nguyenhoanglam/imagepicker/helper/PermissionHelper$STATUS;", "hasGranted", "", "grantResult", "", "grantResults", "", "hasSelfPermission", "context", "Landroid/content/Context;", "hasSelfPermissions", "(Landroid/content/Context;[Ljava/lang/String;)Z", "internalRequestPermissions", "", "requestCode", "(Landroid/app/Activity;[Ljava/lang/String;I)V", "isInitialRequestCalled", "isPermissionDeclared", "openAppSettings", "permissionHasGranted", "requestAllPermissions", "setInitialRequestCalled", "shouldAskPermission", "shouldShowRequestPermissionRationale", "STATUS", "imagepicker_release"})
@SourceDebugExtension(value={"SMAP\nPermissionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionHelper.kt\ncom/nguyenhoanglam/imagepicker/helper/PermissionHelper\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,157:1\n37#2,2:158\n1#3:160\n12574#4,2:161\n*S KotlinDebug\n*F\n+ 1 PermissionHelper.kt\ncom/nguyenhoanglam/imagepicker/helper/PermissionHelper\n*L\n51#1:158,2\n142#1:161,2\n*E\n"})
public final class PermissionHelper {
    @NotNull
    public static final PermissionHelper INSTANCE = new PermissionHelper();
    @NotNull
    private static final String PREFERENCE_FILE_NAME = "ImagePicker";

    private PermissionHelper() {
    }

    @NotNull
    public final STATUS checkPermission(@NotNull Activity activity, @NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        if (!this.hasSelfPermission((Context)activity, permission)) {
            if (this.shouldShowRequestPermissionRationale(activity, permission)) {
                return STATUS.DENIED;
            }
            if (!this.isInitialRequestCalled((Context)activity, permission)) {
                this.setInitialRequestCalled((Context)activity, permission);
                return STATUS.NOT_GRANTED;
            }
            return STATUS.DISABLED;
        }
        return STATUS.GRANTED;
    }

    @NotNull
    public final STATUS[] checkPermissions(@NotNull Activity activity, @NotNull String[] permissions) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        ArrayList<STATUS> statuses = new ArrayList<STATUS>();
        for (String permission : permissions) {
            statuses.add(this.checkPermission(activity, permission));
        }
        Collection $this$toTypedArray$iv = statuses;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new STATUS[0]);
    }

    public final void openAppSettings(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts((String)"package", (String)activity.getPackageName(), null));
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(0x10000000);
        intent.addFlags(0x40000000);
        intent.addFlags(0x800000);
        activity.startActivity(intent);
    }

    private final boolean hasGranted(int grantResult) {
        return grantResult == 0;
    }

    public final boolean hasGranted(@NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        for (int result : grantResults) {
            if (this.hasGranted(result)) continue;
            return false;
        }
        return true;
    }

    private final boolean hasSelfPermission(Context context, String permission) {
        if (this.shouldAskPermission()) {
            return this.permissionHasGranted(context, permission);
        }
        return true;
    }

    public final boolean hasSelfPermissions(@NotNull Context context, @NotNull String[] permissions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        if (this.shouldAskPermission()) {
            for (String permission : permissions) {
                if (this.permissionHasGranted(context, permission)) continue;
                return false;
            }
        }
        return true;
    }

    public final void requestAllPermissions(@NotNull Activity activity, @NotNull String[] permissions, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        if (this.shouldAskPermission()) {
            this.internalRequestPermissions(activity, permissions, requestCode);
        }
    }

    @TargetApi(value=23)
    private final void internalRequestPermissions(Activity activity, String[] permissions, int requestCode) {
        if (activity == null) {
            boolean bl = false;
            String string2 = "Given activity is null.";
            throw new IllegalArgumentException(string2.toString());
        }
        activity.requestPermissions(permissions, requestCode);
    }

    @TargetApi(value=23)
    private final boolean permissionHasGranted(Context context, String permission) {
        return this.hasGranted(context.checkSelfPermission(permission));
    }

    @ChecksSdkIntAtLeast(api=23)
    private final boolean shouldAskPermission() {
        return Build.VERSION.SDK_INT >= 23;
    }

    private final boolean shouldShowRequestPermissionRationale(Activity activity, String permission) {
        if (activity != null) {
            return ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission);
        }
        return false;
    }

    public final boolean isPermissionDeclared(@NotNull Context context, @NotNull String permission) {
        boolean bl;
        block3: {
            String[] packagePermissions;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
            if (packagePermissions != null) {
                String[] $this$any$iv = packagePermissions = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)4096).requestedPermissions;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    String element$iv;
                    String p = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)permission, (Object)p)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final void setInitialRequestCalled(Context context, String permission) {
        context.getSharedPreferences(PREFERENCE_FILE_NAME, 0).edit().putBoolean(permission, true).apply();
    }

    private final boolean isInitialRequestCalled(Context context, String permission) {
        return context.getSharedPreferences(PREFERENCE_FILE_NAME, 0).getBoolean(permission, false);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/nguyenhoanglam/imagepicker/helper/PermissionHelper$STATUS;", "", "(Ljava/lang/String;I)V", "GRANTED", "NOT_GRANTED", "DENIED", "DISABLED", "imagepicker_release"})
    public static final class STATUS
    extends Enum<STATUS> {
        public static final /* enum */ STATUS GRANTED = new STATUS();
        public static final /* enum */ STATUS NOT_GRANTED = new STATUS();
        public static final /* enum */ STATUS DENIED = new STATUS();
        public static final /* enum */ STATUS DISABLED = new STATUS();
        private static final /* synthetic */ STATUS[] $VALUES;

        public static STATUS[] values() {
            return (STATUS[])$VALUES.clone();
        }

        public static STATUS valueOf(String value) {
            return Enum.valueOf(STATUS.class, value);
        }

        static {
            $VALUES = sTATUSArray = new STATUS[]{STATUS.GRANTED, STATUS.NOT_GRANTED, STATUS.DENIED, STATUS.DISABLED};
        }
    }
}

