/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.imagepicker;

import android.app.Application;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.progressindicator.CircularProgressIndicator;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.databinding.ImagepickerFragmentBinding;
import com.nguyenhoanglam.imagepicker.helper.CustomGridLayoutManager;
import com.nguyenhoanglam.imagepicker.helper.DeviceHelper;
import com.nguyenhoanglam.imagepicker.helper.ImageHelper;
import com.nguyenhoanglam.imagepicker.helper.LayoutManagerHelper;
import com.nguyenhoanglam.imagepicker.listener.OnImageLongPressListener;
import com.nguyenhoanglam.imagepicker.listener.OnImagePreviewListener;
import com.nguyenhoanglam.imagepicker.listener.OnImageSelectListener;
import com.nguyenhoanglam.imagepicker.model.CallbackStatus;
import com.nguyenhoanglam.imagepicker.model.CustomColor;
import com.nguyenhoanglam.imagepicker.model.GridCount;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.model.ImagePickerConfig;
import com.nguyenhoanglam.imagepicker.model.Result;
import com.nguyenhoanglam.imagepicker.ui.adapter.ImagePickerAdapter;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.BaseFragment;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImageFragment;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImagePickerViewModel;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImagePickerViewModelFactory;
import com.nguyenhoanglam.imagepicker.widget.GridSpacingItemDecoration;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u007f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0017\u0018\u0000 12\u00020\u00012\u00020\u0002:\u00011B\u0005\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u001b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010\"\u001a\u00020\u001e2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J$\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\b\u0010+\u001a\u00020\u001eH\u0016J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.H\u0016J\u0006\u0010/\u001a\u00020\u001eJ\u0006\u00100\u001a\u00020\u001eR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImageFragment;", "Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/BaseFragment;", "Lcom/nguyenhoanglam/imagepicker/listener/OnImageLongPressListener;", "()V", "_binding", "Lcom/nguyenhoanglam/imagepicker/databinding/ImagepickerFragmentBinding;", "binding", "getBinding", "()Lcom/nguyenhoanglam/imagepicker/databinding/ImagepickerFragmentBinding;", "bucketId", "", "Ljava/lang/Long;", "gridCount", "Lcom/nguyenhoanglam/imagepicker/model/GridCount;", "gridLayoutManager", "Lcom/nguyenhoanglam/imagepicker/helper/CustomGridLayoutManager;", "imageAdapter", "Lcom/nguyenhoanglam/imagepicker/ui/adapter/ImagePickerAdapter;", "isShowingPreview", "", "itemDecoration", "Lcom/nguyenhoanglam/imagepicker/widget/GridSpacingItemDecoration;", "selectedImageObserver", "com/nguyenhoanglam/imagepicker/ui/imagepicker/ImageFragment$selectedImageObserver$1", "Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImageFragment$selectedImageObserver$1;", "viewModel", "Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImagePickerViewModel;", "getBucketId", "()Ljava/lang/Long;", "handleOnConfigurationChanged", "", "handleResult", "result", "Lcom/nguyenhoanglam/imagepicker/model/Result;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onDestroyView", "onLongPress", "image", "Lcom/nguyenhoanglam/imagepicker/model/Image;", "selectAllImages", "unselectAllImages", "Companion", "imagepicker_release"})
public final class ImageFragment
extends BaseFragment
implements OnImageLongPressListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ImagepickerFragmentBinding _binding;
    @Nullable
    private Long bucketId;
    private GridCount gridCount;
    private ImagePickerViewModel viewModel;
    private ImagePickerAdapter imageAdapter;
    private CustomGridLayoutManager gridLayoutManager;
    private GridSpacingItemDecoration itemDecoration;
    private boolean isShowingPreview;
    @NotNull
    private final selectedImageObserver.1 selectedImageObserver = new Observer<ArrayList<Image>>(this){
        final /* synthetic */ ImageFragment this$0;
        {
            this.this$0 = $receiver;
        }

        public void onChanged(@NotNull ArrayList<Image> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            ImagePickerAdapter imagePickerAdapter = ImageFragment.access$getImageAdapter$p(this.this$0);
            if (imagePickerAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
                imagePickerAdapter = null;
            }
            imagePickerAdapter.setSelectedImages(value);
            ImagePickerViewModel imagePickerViewModel = ImageFragment.access$getViewModel$p(this.this$0);
            if (imagePickerViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                imagePickerViewModel = null;
            }
            imagePickerViewModel.getSelectedImages().removeObserver((Observer)this);
        }
    };
    @NotNull
    public static final String BUCKET_ID = "BucketId";
    @NotNull
    public static final String GRID_COUNT = "GridCount";

    private final ImagepickerFragmentBinding getBinding() {
        ImagepickerFragmentBinding imagepickerFragmentBinding = this._binding;
        Intrinsics.checkNotNull((Object)imagepickerFragmentBinding);
        return imagepickerFragmentBinding;
    }

    /*
     * WARNING - void declaration
     */
    public void onCreate(@Nullable Bundle savedInstanceState) {
        void $this$onCreate_u24lambda_u240;
        GridCount gridCount;
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        Long l = this.bucketId = bundle != null ? Long.valueOf(bundle.getLong(BUCKET_ID)) : null;
        if (DeviceHelper.INSTANCE.isMinSdk33()) {
            Bundle bundle2 = this.getArguments();
            GridCount gridCount2 = bundle2 != null ? (GridCount)bundle2.getParcelable(GRID_COUNT, GridCount.class) : null;
            gridCount = gridCount2;
            Intrinsics.checkNotNull((Object)gridCount2);
        } else {
            Bundle bundle3 = this.getArguments();
            GridCount gridCount3 = bundle3 != null ? (GridCount)bundle3.getParcelable(GRID_COUNT) : null;
            gridCount = gridCount3;
            Intrinsics.checkNotNull((Object)gridCount3);
        }
        this.gridCount = gridCount;
        FragmentActivity fragmentActivity = this.requireActivity();
        ImageFragment imageFragment = this;
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$onCreate_u24lambda_u240, (String)"this");
        ViewModelStoreOwner viewModelStoreOwner = (ViewModelStoreOwner)$this$onCreate_u24lambda_u240;
        Application application = this.requireActivity().getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"requireActivity().application");
        imageFragment.viewModel = (ImagePickerViewModel)new ViewModelProvider(viewModelStoreOwner, (ViewModelProvider.Factory)new ImagePickerViewModelFactory(application)).get(ImagePickerViewModel.class);
    }

    @NotNull
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        CustomGridLayoutManager customGridLayoutManager;
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        ImagePickerViewModel imagePickerViewModel = this.viewModel;
        if (imagePickerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            imagePickerViewModel = null;
        }
        ImagePickerConfig config = imagePickerViewModel.getConfig();
        FragmentActivity fragmentActivity = this.requireActivity();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity()");
        Context context = (Context)fragmentActivity;
        FragmentActivity fragmentActivity2 = this.getActivity();
        Intrinsics.checkNotNull((Object)fragmentActivity2, (String)"null cannot be cast to non-null type com.nguyenhoanglam.imagepicker.listener.OnImageSelectListener");
        this.imageAdapter = new ImagePickerAdapter(context, config, (OnImageSelectListener)fragmentActivity2, this);
        Context context2 = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"requireContext()");
        GridCount gridCount = this.gridCount;
        if (gridCount == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridCount");
            gridCount = null;
        }
        if ((customGridLayoutManager = (this.gridLayoutManager = LayoutManagerHelper.INSTANCE.newInstance(context2, gridCount))) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridLayoutManager");
            customGridLayoutManager = null;
        }
        this.itemDecoration = new GridSpacingItemDecoration(customGridLayoutManager.getSpanCount(), (int)this.getResources().getDimension(R.dimen.imagepicker_grid_spacing));
        this._binding = ImagepickerFragmentBinding.inflate(inflater, container, false);
        Object object = this.getBinding();
        ImagepickerFragmentBinding $this$onCreateView_u24lambda_u242 = object;
        boolean bl = false;
        FrameLayout frameLayout = $this$onCreateView_u24lambda_u242.getRoot();
        CustomColor customColor = config.getCustomColor();
        Intrinsics.checkNotNull((Object)customColor);
        frameLayout.setBackgroundColor(Color.parseColor((String)customColor.getBackground()));
        CircularProgressIndicator circularProgressIndicator = $this$onCreateView_u24lambda_u242.progressIndicator;
        Object object2 = new int[1];
        CustomColor customColor2 = config.getCustomColor();
        Intrinsics.checkNotNull((Object)customColor2);
        object2[0] = Color.parseColor((String)customColor2.getLoadingIndicator());
        circularProgressIndicator.setIndicatorColor(object2);
        Object $this$onCreateView_u24lambda_u242_u24lambda_u241 = object2 = (Object)$this$onCreateView_u24lambda_u242.recyclerView;
        boolean bl2 = false;
        $this$onCreateView_u24lambda_u242_u24lambda_u241.setHasFixedSize(true);
        CustomGridLayoutManager customGridLayoutManager2 = this.gridLayoutManager;
        if (customGridLayoutManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridLayoutManager");
            customGridLayoutManager2 = null;
        }
        $this$onCreateView_u24lambda_u242_u24lambda_u241.setLayoutManager((RecyclerView.LayoutManager)customGridLayoutManager2);
        GridSpacingItemDecoration gridSpacingItemDecoration = this.itemDecoration;
        if (gridSpacingItemDecoration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"itemDecoration");
            gridSpacingItemDecoration = null;
        }
        $this$onCreateView_u24lambda_u242_u24lambda_u241.addItemDecoration((RecyclerView.ItemDecoration)gridSpacingItemDecoration);
        ImagePickerAdapter imagePickerAdapter = this.imageAdapter;
        if (imagePickerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
            imagePickerAdapter = null;
        }
        $this$onCreateView_u24lambda_u242_u24lambda_u241.setAdapter((RecyclerView.Adapter)imagePickerAdapter);
        $this$onCreateView_u24lambda_u242_u24lambda_u241.addOnItemTouchListener(new RecyclerView.OnItemTouchListener(this){
            final /* synthetic */ ImageFragment this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean onInterceptTouchEvent(@NotNull RecyclerView rv, @NotNull MotionEvent e) {
                Intrinsics.checkNotNullParameter((Object)rv, (String)"rv");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (ImageFragment.access$isShowingPreview$p(this.this$0) && (e.getAction() == 1 || e.getAction() == 3)) {
                    CustomGridLayoutManager customGridLayoutManager = ImageFragment.access$getGridLayoutManager$p(this.this$0);
                    if (customGridLayoutManager == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"gridLayoutManager");
                        customGridLayoutManager = null;
                    }
                    customGridLayoutManager.setScrollEnabled(true);
                    FragmentActivity fragmentActivity = this.this$0.getActivity();
                    Intrinsics.checkNotNull((Object)fragmentActivity, (String)"null cannot be cast to non-null type com.nguyenhoanglam.imagepicker.listener.OnImagePreviewListener");
                    ((OnImagePreviewListener)fragmentActivity).onHideImagePreview();
                    ImageFragment.access$setShowingPreview$p(this.this$0, false);
                    return true;
                }
                return false;
            }

            public void onTouchEvent(@NotNull RecyclerView rv, @NotNull MotionEvent e) {
                Intrinsics.checkNotNullParameter((Object)rv, (String)"rv");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
            }
        });
        ImagePickerViewModel imagePickerViewModel2 = this.viewModel;
        if (imagePickerViewModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            imagePickerViewModel2 = null;
        }
        Object $this$onCreateView_u24lambda_u243 = object = imagePickerViewModel2;
        boolean bl3 = false;
        object2 = (Function1)new Function1<Result, Unit>(this){
            final /* synthetic */ ImageFragment this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Result it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                ImageFragment.access$handleResult(this.this$0, it);
            }
        };
        ((ImagePickerViewModel)((Object)$this$onCreateView_u24lambda_u243)).getResult().observe(this.getViewLifecycleOwner(), new Observer((Function1)object2){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onChanged(Object value) {
                this.function.invoke(value);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
        ((ImagePickerViewModel)((Object)$this$onCreateView_u24lambda_u243)).getSelectedImages().observe(this.getViewLifecycleOwner(), (Observer)this.selectedImageObserver);
        FrameLayout frameLayout2 = this.getBinding().getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout2, (String)"binding.root");
        return (View)frameLayout2;
    }

    @Nullable
    public final Long getBucketId() {
        return this.bucketId;
    }

    /*
     * Unable to fully structure code
     */
    public final void selectAllImages() {
        v0 = this.viewModel;
        if (v0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            v0 = null;
        }
        if ((v1 = (Result)v0.getResult().getValue()) == null || (v1 = v1.getImages()) == null) {
            v1 = images = new ArrayList<E>();
        }
        if ((v2 = this.viewModel) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            v2 = null;
        }
        v3 = selectedImages = (var3_2 = (ArrayList<E>)v2.getSelectedImages().getValue()) == null ? new ArrayList<E>() : var3_2;
        if (this.bucketId == null) ** GOTO lbl-1000
        v4 = this.bucketId;
        var3_3 = 0L;
        if (v4 == null || v4 != var3_3) {
            imagesByBucket = ImageHelper.INSTANCE.filter((ArrayList<Image>)images, this.bucketId);
            selectedImages.addAll(imagesByBucket);
            v5 = this.imageAdapter;
            if (v5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
                v5 = null;
            }
            v5.setSelectedAndAddedImages((ArrayList<Image>)selectedImages, imagesByBucket);
        } else lbl-1000:
        // 2 sources

        {
            selectedImages.addAll((Collection)images);
            v6 = this.imageAdapter;
            if (v6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
                v6 = null;
            }
            v6.setSelectedAndAddedImages((ArrayList<Image>)selectedImages, (ArrayList<Image>)images);
        }
        if ((v7 = this.viewModel) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            v7 = null;
        }
        v7.getSelectedImages().setValue((Object)selectedImages);
    }

    public final void unselectAllImages() {
        ArrayList arrayList;
        ImagePickerViewModel imagePickerViewModel = this.viewModel;
        if (imagePickerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            imagePickerViewModel = null;
        }
        ArrayList selectedImages = (arrayList = (ArrayList)imagePickerViewModel.getSelectedImages().getValue()) == null ? new ArrayList() : arrayList;
        ArrayList<Image> selectedImagesByBucket = ImageHelper.INSTANCE.filter(selectedImages, this.bucketId);
        selectedImages.removeAll(CollectionsKt.toSet((Iterable)selectedImagesByBucket));
        ImagePickerAdapter imagePickerAdapter = this.imageAdapter;
        if (imagePickerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
            imagePickerAdapter = null;
        }
        imagePickerAdapter.setSelectedAndRemovedImages(selectedImages, selectedImagesByBucket);
        ImagePickerViewModel imagePickerViewModel2 = this.viewModel;
        if (imagePickerViewModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            imagePickerViewModel2 = null;
        }
        imagePickerViewModel2.getSelectedImages().setValue((Object)selectedImages);
    }

    private final void handleResult(Result result) {
        ImagepickerFragmentBinding imagepickerFragmentBinding;
        if (result.getStatus() instanceof CallbackStatus.SUCCESS) {
            ArrayList<Image> images = ImageHelper.INSTANCE.filter(result.getImages(), this.bucketId);
            if (!((Collection)images).isEmpty()) {
                ImagePickerAdapter imagePickerAdapter = this.imageAdapter;
                if (imagePickerAdapter == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
                    imagePickerAdapter = null;
                }
                imagePickerAdapter.setImages(images);
                this.getBinding().recyclerView.setVisibility(0);
            } else {
                this.getBinding().recyclerView.setVisibility(8);
            }
        } else {
            this.getBinding().recyclerView.setVisibility(8);
        }
        ImagepickerFragmentBinding $this$handleResult_u24lambda_u244 = imagepickerFragmentBinding = this.getBinding();
        boolean bl = false;
        $this$handleResult_u24lambda_u244.emptyText.setVisibility(result.getStatus() instanceof CallbackStatus.SUCCESS && result.getImages().isEmpty() ? 0 : 8);
        $this$handleResult_u24lambda_u244.progressIndicator.setVisibility(result.getStatus() instanceof CallbackStatus.FETCHING ? 0 : 8);
    }

    @Override
    public void handleOnConfigurationChanged() {
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        GridCount gridCount = this.gridCount;
        if (gridCount == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridCount");
            gridCount = null;
        }
        int newSpanCount = LayoutManagerHelper.INSTANCE.getSpanCountForCurrentConfiguration(context, gridCount);
        CustomGridLayoutManager customGridLayoutManager = this.gridLayoutManager;
        if (customGridLayoutManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridLayoutManager");
            customGridLayoutManager = null;
        }
        this.itemDecoration = new GridSpacingItemDecoration(customGridLayoutManager.getSpanCount(), (int)this.getResources().getDimension(R.dimen.imagepicker_grid_spacing));
        CustomGridLayoutManager customGridLayoutManager2 = this.gridLayoutManager;
        if (customGridLayoutManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridLayoutManager");
            customGridLayoutManager2 = null;
        }
        customGridLayoutManager2.setSpanCount(newSpanCount);
        RecyclerView recyclerView = this.getBinding().recyclerView;
        GridSpacingItemDecoration gridSpacingItemDecoration = this.itemDecoration;
        if (gridSpacingItemDecoration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"itemDecoration");
            gridSpacingItemDecoration = null;
        }
        recyclerView.addItemDecoration((RecyclerView.ItemDecoration)gridSpacingItemDecoration);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this._binding = null;
    }

    @Override
    public void onLongPress(@NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        CustomGridLayoutManager customGridLayoutManager = this.gridLayoutManager;
        if (customGridLayoutManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridLayoutManager");
            customGridLayoutManager = null;
        }
        customGridLayoutManager.setScrollEnabled(false);
        FragmentActivity fragmentActivity = this.getActivity();
        Intrinsics.checkNotNull((Object)fragmentActivity, (String)"null cannot be cast to non-null type com.nguyenhoanglam.imagepicker.listener.OnImagePreviewListener");
        ((OnImagePreviewListener)fragmentActivity).onShowImagePreview(image);
        this.isShowingPreview = true;
    }

    public static final /* synthetic */ boolean access$isShowingPreview$p(ImageFragment $this) {
        return $this.isShowingPreview;
    }

    public static final /* synthetic */ CustomGridLayoutManager access$getGridLayoutManager$p(ImageFragment $this) {
        return $this.gridLayoutManager;
    }

    public static final /* synthetic */ void access$setShowingPreview$p(ImageFragment $this, boolean bl) {
        $this.isShowingPreview = bl;
    }

    public static final /* synthetic */ void access$handleResult(ImageFragment $this, Result result) {
        $this.handleResult(result);
    }

    public static final /* synthetic */ ImagePickerAdapter access$getImageAdapter$p(ImageFragment $this) {
        return $this.imageAdapter;
    }

    public static final /* synthetic */ ImagePickerViewModel access$getViewModel$p(ImageFragment $this) {
        return $this.viewModel;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImageFragment$Companion;", "", "()V", "BUCKET_ID", "", "GRID_COUNT", "newInstance", "Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImageFragment;", "gridCount", "Lcom/nguyenhoanglam/imagepicker/model/GridCount;", "bucketId", "", "imagepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ImageFragment newInstance(long bucketId, @NotNull GridCount gridCount) {
            Intrinsics.checkNotNullParameter((Object)gridCount, (String)"gridCount");
            ImageFragment fragment = new ImageFragment();
            Bundle args = new Bundle();
            args.putLong(ImageFragment.BUCKET_ID, bucketId);
            args.putParcelable(ImageFragment.GRID_COUNT, (Parcelable)gridCount);
            fragment.setArguments(args);
            return fragment;
        }

        @NotNull
        public final ImageFragment newInstance(@NotNull GridCount gridCount) {
            Intrinsics.checkNotNullParameter((Object)gridCount, (String)"gridCount");
            ImageFragment fragment = new ImageFragment();
            Bundle args = new Bundle();
            args.putParcelable(ImageFragment.GRID_COUNT, (Parcelable)gridCount);
            fragment.setArguments(args);
            return fragment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

