/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.camera;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.ContextThemeWrapper;
import android.view.View;
import androidx.activity.OnBackPressedCallback;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.R;
import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.LifecycleOwner;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.databinding.ImagepickerActivityCameraBinding;
import com.nguyenhoanglam.imagepicker.helper.DeviceHelper;
import com.nguyenhoanglam.imagepicker.helper.PermissionHelper;
import com.nguyenhoanglam.imagepicker.helper.ToastHelper;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.model.ImagePickerConfig;
import com.nguyenhoanglam.imagepicker.ui.camera.CameraModule;
import com.nguyenhoanglam.imagepicker.ui.camera.OnImageReadyListener;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0016J \u0010\u0015\u001a\u00020\u00122\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0017j\b\u0012\u0004\u0012\u00020\u0018`\u0019H\u0002J\u0012\u0010\u001a\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J+\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$H\u0016\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020\u0012H\u0014J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\"H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/camera/CameraActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "alertDialog", "Landroid/app/AlertDialog;", "binding", "Lcom/nguyenhoanglam/imagepicker/databinding/ImagepickerActivityCameraBinding;", "cameraModule", "Lcom/nguyenhoanglam/imagepicker/ui/camera/CameraModule;", "config", "Lcom/nguyenhoanglam/imagepicker/model/ImagePickerConfig;", "isOpeningCamera", "", "resultLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "kotlin.jvm.PlatformType", "captureImage", "", "captureImageWithPermission", "finish", "finishCaptureImage", "images", "Ljava/util/ArrayList;", "Lcom/nguyenhoanglam/imagepicker/model/Image;", "Lkotlin/collections/ArrayList;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onRequestPermissionsResult", "requestCode", "", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "onResume", "showOpenSettingDialog", "message", "imagepicker_release"})
@SourceDebugExtension(value={"SMAP\nCameraActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraActivity.kt\ncom/nguyenhoanglam/imagepicker/ui/camera/CameraActivity\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,238:1\n37#2,2:239\n*S KotlinDebug\n*F\n+ 1 CameraActivity.kt\ncom/nguyenhoanglam/imagepicker/ui/camera/CameraActivity\n*L\n140#1:239,2\n*E\n"})
public final class CameraActivity
extends AppCompatActivity {
    private ImagepickerActivityCameraBinding binding;
    private ImagePickerConfig config;
    @NotNull
    private final CameraModule cameraModule = new CameraModule();
    @Nullable
    private AlertDialog alertDialog;
    private boolean isOpeningCamera;
    @NotNull
    private final ActivityResultLauncher<Intent> resultLauncher;

    public CameraActivity() {
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), arg_0 -> CameraActivity.resultLauncher$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026)\n            }\n        }");
        this.resultLauncher = activityResultLauncher;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        ImagePickerConfig imagePickerConfig;
        ImagePickerConfig imagePickerConfig2;
        super.onCreate(savedInstanceState);
        if (this.getIntent() == null) {
            this.finish();
            return;
        }
        if (DeviceHelper.INSTANCE.isMinSdk33()) {
            Object object = this.getIntent().getParcelableExtra("ImagePickerConfig", ImagePickerConfig.class);
            Intrinsics.checkNotNull((Object)object);
            imagePickerConfig2 = (ImagePickerConfig)object;
        } else {
            Parcelable parcelable = this.getIntent().getParcelableExtra("ImagePickerConfig");
            Intrinsics.checkNotNull((Object)parcelable);
            imagePickerConfig2 = (ImagePickerConfig)parcelable;
        }
        if ((imagePickerConfig = (this.config = imagePickerConfig2)) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig = null;
        }
        imagePickerConfig.initDefaultValues((Context)this);
        ImagepickerActivityCameraBinding imagepickerActivityCameraBinding = ImagepickerActivityCameraBinding.inflate(this.getLayoutInflater());
        Intrinsics.checkNotNullExpressionValue((Object)imagepickerActivityCameraBinding, (String)"inflate(layoutInflater)");
        this.binding = imagepickerActivityCameraBinding;
        ImagepickerActivityCameraBinding imagepickerActivityCameraBinding2 = this.binding;
        if (imagepickerActivityCameraBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            imagepickerActivityCameraBinding2 = null;
        }
        this.setContentView((View)imagepickerActivityCameraBinding2.getRoot());
        this.getOnBackPressedDispatcher().addCallback((LifecycleOwner)this, new OnBackPressedCallback(this){
            final /* synthetic */ CameraActivity this$0;
            {
                this.this$0 = $receiver;
                super(true);
            }

            public void handleOnBackPressed() {
                this.this$0.setResult(0);
                this.this$0.finish();
            }
        });
    }

    protected void onResume() {
        block2: {
            block3: {
                super.onResume();
                if (this.isOpeningCamera) break block2;
                if (this.alertDialog == null) break block3;
                AlertDialog alertDialog = this.alertDialog;
                Intrinsics.checkNotNull((Object)alertDialog);
                if (alertDialog.isShowing()) break block2;
            }
            this.captureImageWithPermission();
        }
    }

    private final void captureImageWithPermission() {
        boolean isCameraPermissionDeclared = PermissionHelper.INSTANCE.isPermissionDeclared((Context)this, "android.permission.CAMERA");
        if (DeviceHelper.INSTANCE.isMinSdk29()) {
            if (isCameraPermissionDeclared) {
                String cameraPermission = "android.permission.CAMERA";
                switch (WhenMappings.$EnumSwitchMapping$0[PermissionHelper.INSTANCE.checkPermission((Activity)this, cameraPermission).ordinal()]) {
                    case 1: {
                        this.captureImage();
                        break;
                    }
                    case 2: {
                        String[] stringArray = new String[]{cameraPermission};
                        PermissionHelper.INSTANCE.requestAllPermissions((Activity)this, stringArray, 1002);
                        break;
                    }
                    case 3: {
                        String[] stringArray = new String[]{cameraPermission};
                        PermissionHelper.INSTANCE.requestAllPermissions((Activity)this, stringArray, 1002);
                        break;
                    }
                    default: {
                        String string2 = this.getResources().getString(R.string.imagepicker_msg_no_camera_permission);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(R.st\u2026msg_no_camera_permission)");
                        this.showOpenSettingDialog(string2);
                        break;
                    }
                }
            } else {
                this.captureImage();
            }
        } else if (isCameraPermissionDeclared) {
            String[] stringArray = new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"};
            PermissionHelper.STATUS[] statuses = PermissionHelper.INSTANCE.checkPermissions((Activity)this, stringArray);
            if (statuses[0] == PermissionHelper.STATUS.GRANTED && statuses[1] == PermissionHelper.STATUS.GRANTED) {
                this.captureImage();
            } else if (statuses[0] == PermissionHelper.STATUS.DISABLED && statuses[1] == PermissionHelper.STATUS.DISABLED) {
                this.getResources().getString(R.string.imagepicker_msg_no_camera_permission);
            } else if (statuses[0] == PermissionHelper.STATUS.DISABLED) {
                this.getResources().getString(R.string.imagepicker_msg_no_camera_permission);
            } else if (statuses[1] == PermissionHelper.STATUS.DISABLED) {
                this.getResources().getString(R.string.imagepicker_msg_no_photo_access_permission);
            } else {
                ArrayList<String> requestPermissions = new ArrayList<String>();
                int n = statuses.length;
                for (int i = 0; i < n; ++i) {
                    int index = i;
                    PermissionHelper.STATUS value = statuses[i];
                    if (value != PermissionHelper.STATUS.NOT_GRANTED && value != PermissionHelper.STATUS.DENIED) continue;
                    requestPermissions.add(index == 0 ? "android.permission.CAMERA" : "android.permission.WRITE_EXTERNAL_STORAGE");
                }
                Collection $this$toTypedArray$iv = requestPermissions;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                PermissionHelper.INSTANCE.requestAllPermissions((Activity)this, thisCollection$iv.toArray(new String[0]), 1002);
            }
        } else {
            String writePermission = "android.permission.WRITE_EXTERNAL_STORAGE";
            switch (WhenMappings.$EnumSwitchMapping$0[PermissionHelper.INSTANCE.checkPermission((Activity)this, writePermission).ordinal()]) {
                case 1: {
                    this.captureImage();
                    break;
                }
                case 2: {
                    String[] stringArray = new String[]{writePermission};
                    PermissionHelper.INSTANCE.requestAllPermissions((Activity)this, stringArray, 1001);
                    break;
                }
                case 3: {
                    String[] stringArray = new String[]{writePermission};
                    PermissionHelper.INSTANCE.requestAllPermissions((Activity)this, stringArray, 1001);
                    break;
                }
                default: {
                    String string3 = this.getResources().getString(R.string.imagepicker_msg_no_photo_access_permission);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"resources.getString(R.st\u2026_photo_access_permission)");
                    this.showOpenSettingDialog(string3);
                }
            }
        }
    }

    private final void showOpenSettingDialog(String message) {
        AlertDialog.Builder builder;
        AlertDialog.Builder $this$showOpenSettingDialog_u24lambda_u243 = builder = new AlertDialog.Builder((Context)new ContextThemeWrapper((Context)this, R.style.Theme_AppCompat_Light_Dialog));
        boolean bl = false;
        $this$showOpenSettingDialog_u24lambda_u243.setMessage((CharSequence)message);
        $this$showOpenSettingDialog_u24lambda_u243.setNegativeButton(R.string.imagepicker_action_cancel, (arg_0, arg_1) -> CameraActivity.showOpenSettingDialog$lambda$3$lambda$1(this, arg_0, arg_1));
        $this$showOpenSettingDialog_u24lambda_u243.setPositiveButton(R.string.imagepicker_action_ok, (arg_0, arg_1) -> CameraActivity.showOpenSettingDialog$lambda$3$lambda$2(this, arg_0, arg_1));
        AlertDialog alertDialog = this.alertDialog = builder.create();
        Intrinsics.checkNotNull((Object)alertDialog);
        alertDialog.show();
    }

    private final void captureImage() {
        Intent intent;
        if (!DeviceHelper.INSTANCE.checkCameraAvailability((Context)this)) {
            this.finish();
            return;
        }
        Context context = (Context)this;
        ImagePickerConfig imagePickerConfig = this.config;
        if (imagePickerConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig = null;
        }
        if ((intent = this.cameraModule.getCameraIntent(context, imagePickerConfig)) == null) {
            Context context2 = (Context)this;
            String string2 = this.getString(R.string.imagepicker_error_camera);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.imagepicker_error_camera)");
            ToastHelper.Companion.show$default(ToastHelper.Companion, context2, string2, 0, 4, null);
            return;
        }
        this.resultLauncher.launch((Object)intent);
        this.isOpeningCamera = true;
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        switch (requestCode) {
            case 1001: 
            case 1002: {
                if (PermissionHelper.INSTANCE.hasGranted(grantResults)) {
                    this.captureImage();
                    break;
                }
                this.finish();
                break;
            }
            default: {
                super.onRequestPermissionsResult(requestCode, permissions, grantResults);
                this.finish();
            }
        }
    }

    private final void finishCaptureImage(ArrayList<Image> images) {
        Intent data = new Intent();
        data.putParcelableArrayListExtra("ImagePickerImages", images);
        this.setResult(-1, data);
        this.finish();
    }

    public void finish() {
        super.finish();
        if (Build.VERSION.SDK_INT >= 34) {
            this.overrideActivityTransition(1, 0, 0);
        } else {
            this.overridePendingTransition(0, 0);
        }
    }

    private static final void resultLauncher$lambda$0(CameraActivity this$0, ActivityResult result) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (result.getResultCode() == -1) {
            CameraModule cameraModule = this$0.cameraModule;
            Context context = (Context)this$0;
            ImagePickerConfig imagePickerConfig = this$0.config;
            if (imagePickerConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                imagePickerConfig = null;
            }
            cameraModule.saveImage(context, imagePickerConfig, new OnImageReadyListener(this$0){
                final /* synthetic */ CameraActivity this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onImageReady(@NotNull ArrayList<Image> images) {
                    Intrinsics.checkNotNullParameter(images, (String)"images");
                    CameraActivity.access$finishCaptureImage(this.this$0, images);
                }

                public void onImageNotReady() {
                    CameraActivity.access$finishCaptureImage(this.this$0, new ArrayList<E>());
                }
            });
        } else {
            this$0.finishCaptureImage(new ArrayList<Image>());
        }
    }

    private static final void showOpenSettingDialog$lambda$3$lambda$1(CameraActivity this$0, DialogInterface dialogInterface, int n) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.finish();
    }

    private static final void showOpenSettingDialog$lambda$3$lambda$2(CameraActivity this$0, DialogInterface dialogInterface, int n) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        PermissionHelper.INSTANCE.openAppSettings((Activity)this$0);
        this$0.finish();
    }

    public static final /* synthetic */ void access$finishCaptureImage(CameraActivity $this, ArrayList images) {
        $this.finishCaptureImage(images);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PermissionHelper.STATUS.values().length];
            try {
                nArray[PermissionHelper.STATUS.GRANTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionHelper.STATUS.NOT_GRANTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionHelper.STATUS.DENIED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

