/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.helper;

import android.content.Context;
import androidx.recyclerview.widget.GridLayoutManager;
import com.nguyenhoanglam.imagepicker.model.GridCount;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Lcom/nguyenhoanglam/imagepicker/helper/LayoutManagerHelper;", "", "()V", "getSpanCountForCurrentConfiguration", "", "context", "Landroid/content/Context;", "gridCount", "Lcom/nguyenhoanglam/imagepicker/model/GridCount;", "newInstance", "Landroidx/recyclerview/widget/GridLayoutManager;", "imagepicker_release"})
public final class LayoutManagerHelper {
    @NotNull
    public static final LayoutManagerHelper INSTANCE = new LayoutManagerHelper();

    private LayoutManagerHelper() {
    }

    @NotNull
    public final GridLayoutManager newInstance(@NotNull Context context, @NotNull GridCount gridCount) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)gridCount, (String)"gridCount");
        int spanCount = this.getSpanCountForCurrentConfiguration(context, gridCount);
        return new GridLayoutManager(context, spanCount);
    }

    public final int getSpanCountForCurrentConfiguration(@NotNull Context context, @NotNull GridCount gridCount) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)gridCount, (String)"gridCount");
        boolean isPortrait = context.getResources().getConfiguration().orientation == 1;
        return isPortrait ? gridCount.getPortrait() : gridCount.getLandscape();
    }
}

