/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.helper;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.core.app.ActivityCompat;
import com.nguyenhoanglam.imagepicker.helper.PreferenceHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u0005H\u0002J!\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0019J-\u0010\u001a\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u001b\u001a\u00020\u0012H\u0003\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u0005H\u0003J)\u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u001b\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u001cJ\b\u0010 \u001a\u00020\u0010H\u0003J\u0018\u0010!\u001a\u00020\u00102\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0005\u00a8\u0006#"}, d2={"Lcom/nguyenhoanglam/imagepicker/helper/PermissionHelper;", "", "()V", "asArray", "", "", "permissions", "([Ljava/lang/String;)[Ljava/lang/String;", "checkPermission", "", "activity", "Landroid/app/Activity;", "permission", "listener", "Lcom/nguyenhoanglam/imagepicker/helper/PermissionHelper$PermissionAskListener;", "hasGranted", "", "grantResult", "", "grantResults", "", "hasSelfPermission", "context", "Landroid/content/Context;", "hasSelfPermissions", "(Landroid/content/Context;[Ljava/lang/String;)Z", "internalRequestPermissions", "requestCode", "(Landroid/app/Activity;[Ljava/lang/String;I)V", "openAppSettings", "permissionHasGranted", "requestAllPermissions", "shouldAskPermission", "shouldShowRequestPermissionRationale", "PermissionAskListener", "imagepicker_release"})
public final class PermissionHelper {
    @NotNull
    public static final PermissionHelper INSTANCE = new PermissionHelper();

    private PermissionHelper() {
    }

    public final void checkPermission(@NotNull Activity activity, @NotNull String permission, @NotNull PermissionAskListener listener) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (!this.hasSelfPermission((Context)activity, permission)) {
            if (this.shouldShowRequestPermissionRationale(activity, permission)) {
                listener.onPermissionPreviouslyDenied();
            } else if (PreferenceHelper.isFirstTimeAskingPermission((Context)activity, permission)) {
                PreferenceHelper.firstTimeAskingPermission((Context)activity, permission, false);
                listener.onNeedPermission();
            } else {
                listener.onPermissionDisabled();
            }
        } else {
            listener.onPermissionGranted();
        }
    }

    public final void openAppSettings(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts((String)"package", (String)activity.getPackageName(), null));
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(0x10000000);
        intent.addFlags(0x40000000);
        intent.addFlags(0x800000);
        activity.startActivity(intent);
    }

    @NotNull
    public final String[] asArray(String ... permissions) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        if (!(!(permissions.length == 0))) {
            boolean $i$a$-require-PermissionHelper$asArray$22 = false;
            String $i$a$-require-PermissionHelper$asArray$22 = "There is no given permission";
            throw new IllegalArgumentException($i$a$-require-PermissionHelper$asArray$22.toString());
        }
        String[] dest = new String[permissions.length];
        for (String dest[i] : permissions) {
        }
        return dest;
    }

    public final boolean hasGranted(int grantResult) {
        return grantResult == 0;
    }

    public final boolean hasGranted(@NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        for (int result : grantResults) {
            if (this.hasGranted(result)) continue;
            return false;
        }
        return true;
    }

    private final boolean hasSelfPermission(Context context, String permission) {
        return this.shouldAskPermission() ? this.permissionHasGranted(context, permission) : true;
    }

    public final boolean hasSelfPermissions(@NotNull Context context, @NotNull String[] permissions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        if (this.shouldAskPermission()) {
            for (String permission : permissions) {
                if (this.permissionHasGranted(context, permission)) continue;
                return false;
            }
        }
        return true;
    }

    public final void requestAllPermissions(@NotNull Activity activity, @NotNull String[] permissions, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        if (this.shouldAskPermission()) {
            this.internalRequestPermissions(activity, permissions, requestCode);
        }
    }

    @TargetApi(value=23)
    private final void internalRequestPermissions(Activity activity, String[] permissions, int requestCode) {
        if (activity == null) {
            boolean bl = false;
            String string2 = "Given activity is null.";
            throw new IllegalArgumentException(string2.toString());
        }
        activity.requestPermissions(permissions, requestCode);
    }

    @TargetApi(value=23)
    private final boolean permissionHasGranted(Context context, String permission) {
        return this.hasGranted(context.checkSelfPermission(permission));
    }

    @ChecksSdkIntAtLeast(api=23)
    private final boolean shouldAskPermission() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public final boolean shouldShowRequestPermissionRationale(@Nullable Activity activity, @NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        if (activity != null) {
            return ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission);
        }
        return false;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J\b\u0010\u0005\u001a\u00020\u0003H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\u0007"}, d2={"Lcom/nguyenhoanglam/imagepicker/helper/PermissionHelper$PermissionAskListener;", "", "onNeedPermission", "", "onPermissionDisabled", "onPermissionGranted", "onPermissionPreviouslyDenied", "imagepicker_release"})
    public static interface PermissionAskListener {
        public void onNeedPermission();

        public void onPermissionPreviouslyDenied();

        public void onPermissionDisabled();

        public void onPermissionGranted();
    }
}

