/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.camera;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.ContextThemeWrapper;
import android.view.View;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.databinding.ImagepickerActivityCameraBinding;
import com.nguyenhoanglam.imagepicker.helper.DeviceHelper;
import com.nguyenhoanglam.imagepicker.helper.PermissionHelper;
import com.nguyenhoanglam.imagepicker.helper.ToastHelper;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.model.ImagePickerConfig;
import com.nguyenhoanglam.imagepicker.ui.camera.CameraModule;
import com.nguyenhoanglam.imagepicker.ui.camera.OnImageReadyListener;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u0016\u0010\u0019\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u0016H\u0016J\u0012\u0010\u001e\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0014J+\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010$\u001a\u00020%H\u0016\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\u0016H\u0014J\b\u0010(\u001a\u00020\u0016H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/camera/CameraActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "alertDialog", "Landroid/app/AlertDialog;", "binding", "Lcom/nguyenhoanglam/imagepicker/databinding/ImagepickerActivityCameraBinding;", "cameraModule", "Lcom/nguyenhoanglam/imagepicker/ui/camera/CameraModule;", "config", "Lcom/nguyenhoanglam/imagepicker/model/ImagePickerConfig;", "isOpeningCamera", "", "permissions", "", "", "[Ljava/lang/String;", "resultLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "kotlin.jvm.PlatformType", "captureImage", "", "captureImageWithPermission", "finish", "finishCaptureImage", "images", "Ljava/util/ArrayList;", "Lcom/nguyenhoanglam/imagepicker/model/Image;", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onRequestPermissionsResult", "requestCode", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "onResume", "showOpenSettingDialog", "imagepicker_release"})
public final class CameraActivity
extends AppCompatActivity {
    private ImagepickerActivityCameraBinding binding;
    private ImagePickerConfig config;
    @NotNull
    private final CameraModule cameraModule = new CameraModule();
    @Nullable
    private AlertDialog alertDialog;
    private boolean isOpeningCamera;
    @NotNull
    private final String[] permissions;
    @NotNull
    private final ActivityResultLauncher<Intent> resultLauncher;

    public CameraActivity() {
        ActivityResultLauncher activityResultLauncher = new ActivityResultLauncher[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
        this.permissions = activityResultLauncher;
        activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), arg_0 -> CameraActivity.resultLauncher$lambda-0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026)\n            }\n        }");
        this.resultLauncher = activityResultLauncher;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        Object object;
        Parcelable parcelable;
        super.onCreate(savedInstanceState);
        if (this.getIntent() == null) {
            this.finish();
            return;
        }
        Parcelable parcelable2 = this.getIntent().getParcelableExtra("ImagePickerConfig");
        Intrinsics.checkNotNull((Object)parcelable2);
        Object object2 = parcelable2;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"intent.getParcelableExtr\u2026Constants.EXTRA_CONFIG)!!");
        this.config = (ImagePickerConfig)object2;
        object2 = this.config;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            parcelable = null;
        } else {
            parcelable = object2;
        }
        parcelable.initDefaultValues((Context)this);
        object2 = ImagepickerActivityCameraBinding.inflate(this.getLayoutInflater());
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"inflate(layoutInflater)");
        this.binding = object2;
        object2 = this.binding;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            object = null;
        } else {
            object = object2;
        }
        this.setContentView((View)((ImagepickerActivityCameraBinding)object).getRoot());
    }

    protected void onResume() {
        block2: {
            block3: {
                super.onResume();
                if (this.isOpeningCamera) break block2;
                if (this.alertDialog == null) break block3;
                AlertDialog alertDialog = this.alertDialog;
                Intrinsics.checkNotNull((Object)alertDialog);
                if (alertDialog.isShowing()) break block2;
            }
            this.captureImageWithPermission();
        }
    }

    private final void captureImageWithPermission() {
        if (DeviceHelper.INSTANCE.isMinSdk29()) {
            this.captureImage();
            return;
        }
        String[] stringArray = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
        String[] permissions = stringArray;
        PermissionHelper.INSTANCE.checkPermission((Activity)this, "android.permission.WRITE_EXTERNAL_STORAGE", new PermissionHelper.PermissionAskListener(this, permissions){
            final /* synthetic */ CameraActivity this$0;
            final /* synthetic */ String[] $permissions;
            {
                this.this$0 = $receiver;
                this.$permissions = $permissions;
            }

            public void onNeedPermission() {
                PermissionHelper.INSTANCE.requestAllPermissions((Activity)this.this$0, this.$permissions, 1001);
            }

            public void onPermissionPreviouslyDenied() {
                PermissionHelper.INSTANCE.requestAllPermissions((Activity)this.this$0, this.$permissions, 1001);
            }

            public void onPermissionDisabled() {
                CameraActivity.access$showOpenSettingDialog(this.this$0);
            }

            public void onPermissionGranted() {
                CameraActivity.access$captureImage(this.this$0);
            }
        });
    }

    private final void showOpenSettingDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)new ContextThemeWrapper((Context)this, R.style.Theme_AppCompat_Light_Dialog));
        boolean bl = false;
        boolean bl2 = false;
        AlertDialog.Builder $this$showOpenSettingDialog_u24lambda_u2d3 = builder;
        boolean bl3 = false;
        $this$showOpenSettingDialog_u24lambda_u2d3.setMessage(R.string.imagepicker_msg_no_external_storage_permission);
        $this$showOpenSettingDialog_u24lambda_u2d3.setNegativeButton(R.string.imagepicker_action_cancel, (arg_0, arg_1) -> CameraActivity.showOpenSettingDialog$lambda-3$lambda-1(this, arg_0, arg_1));
        $this$showOpenSettingDialog_u24lambda_u2d3.setPositiveButton(R.string.imagepicker_action_ok, (arg_0, arg_1) -> CameraActivity.showOpenSettingDialog$lambda-3$lambda-2(this, arg_0, arg_1));
        AlertDialog alertDialog = this.alertDialog = builder.create();
        Intrinsics.checkNotNull((Object)alertDialog);
        alertDialog.show();
    }

    private final void captureImage() {
        ImagePickerConfig imagePickerConfig;
        if (!DeviceHelper.INSTANCE.checkCameraAvailability((Context)this)) {
            this.finish();
            return;
        }
        Context context = (Context)this;
        Object object = this.config;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig = null;
        } else {
            imagePickerConfig = object;
        }
        Intent intent = this.cameraModule.getCameraIntent(context, imagePickerConfig);
        if (intent == null) {
            Context context2 = (Context)this;
            object = this.getString(R.string.imagepicker_error_open_camera);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getString(R.string.imagepicker_error_open_camera)");
            ToastHelper.Companion.show$default(ToastHelper.Companion, context2, (String)object, 0, 4, null);
            return;
        }
        this.resultLauncher.launch((Object)intent);
        this.isOpeningCamera = true;
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        int n = requestCode;
        if (n == 1001) {
            if (PermissionHelper.INSTANCE.hasGranted(grantResults)) {
                this.captureImage();
            } else {
                this.finish();
            }
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            this.finish();
        }
    }

    private final void finishCaptureImage(ArrayList<Image> images) {
        Intent data = new Intent();
        data.putParcelableArrayListExtra("ImagePickerImages", images);
        this.setResult(-1, data);
        this.finish();
    }

    public void onBackPressed() {
        this.setResult(0);
        this.finish();
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }

    private static final void resultLauncher$lambda-0(CameraActivity this$0, ActivityResult result) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (result.getResultCode() == -1) {
            ImagePickerConfig imagePickerConfig;
            CameraModule cameraModule = this$0.cameraModule;
            Context context = (Context)this$0;
            ImagePickerConfig imagePickerConfig2 = this$0.config;
            if (imagePickerConfig2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                imagePickerConfig = null;
            } else {
                imagePickerConfig = imagePickerConfig2;
            }
            cameraModule.saveImage(context, imagePickerConfig, new OnImageReadyListener(this$0){
                final /* synthetic */ CameraActivity this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onImageReady(@NotNull ArrayList<Image> images) {
                    Intrinsics.checkNotNullParameter(images, (String)"images");
                    CameraActivity.access$finishCaptureImage(this.this$0, images);
                }

                public void onImageNotReady() {
                    boolean bl = false;
                    CameraActivity.access$finishCaptureImage(this.this$0, new ArrayList<E>());
                }
            });
        } else {
            boolean bl = false;
            this$0.finishCaptureImage(new ArrayList<Image>());
        }
    }

    private static final void showOpenSettingDialog$lambda-3$lambda-1(CameraActivity this$0, DialogInterface $noName_0, int $noName_1) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.finish();
    }

    private static final void showOpenSettingDialog$lambda-3$lambda-2(CameraActivity this$0, DialogInterface $noName_0, int $noName_1) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        PermissionHelper.INSTANCE.openAppSettings((Activity)this$0);
        this$0.finish();
    }

    public static final /* synthetic */ void access$showOpenSettingDialog(CameraActivity $this) {
        $this.showOpenSettingDialog();
    }

    public static final /* synthetic */ void access$captureImage(CameraActivity $this) {
        $this.captureImage();
    }

    public static final /* synthetic */ void access$finishCaptureImage(CameraActivity $this, ArrayList images) {
        $this.finishCaptureImage(images);
    }
}

